/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.collection;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import org.geotoolkit.util.collection.CheckedCollection;

public abstract class DerivedSet<B, E>
extends AbstractSet<E>
implements CheckedCollection<E>,
Serializable {
    private static final long serialVersionUID = -4662336508586424581L;
    protected final Set<B> base;
    private final Class<E> derivedType;

    public DerivedSet(Set<B> set, Class<E> clazz) {
        this.base = set;
        this.derivedType = clazz;
    }

    @Override
    public Class<E> getElementType() {
        return this.derivedType;
    }

    protected abstract E baseToDerived(B var1);

    protected abstract B derivedToBase(E var1);

    @Override
    public Iterator<E> iterator() {
        return new Iter(this.base.iterator());
    }

    @Override
    public int size() {
        int n = 0;
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++n;
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        return this.base.isEmpty() || super.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        if (this.derivedType.isInstance(object)) {
            return this.base.contains(this.derivedToBase(this.derivedType.cast(object)));
        }
        return false;
    }

    @Override
    public boolean add(E e) throws UnsupportedOperationException {
        return this.base.add(this.derivedToBase(e));
    }

    @Override
    public boolean remove(Object object) throws UnsupportedOperationException {
        if (this.derivedType.isInstance(object)) {
            return this.base.remove(this.derivedToBase(this.derivedType.cast(object)));
        }
        return false;
    }

    private final class Iter
    implements Iterator<E> {
        private final Iterator<B> iterator;
        private transient E next;

        public Iter(Iterator<B> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            while (this.next == null) {
                if (!this.iterator.hasNext()) {
                    return false;
                }
                this.next = DerivedSet.this.baseToDerived(this.iterator.next());
            }
            return true;
        }

        @Override
        public E next() {
            while (this.next == null) {
                this.next = DerivedSet.this.baseToDerived(this.iterator.next());
            }
            Object e = this.next;
            this.next = null;
            return e;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

