/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.eogeojson10;

import com.sun.jersey.api.client.ClientResponse;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.opengis.cite.eogeojson10.ErrorMessage;
import org.opengis.cite.eogeojson10.util.NamespaceBindings;
import org.opengis.cite.eogeojson10.util.XMLUtils;
import org.opengis.cite.validation.SchematronValidator;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ETSAssert {
    private static final Logger LOGR = Logger.getLogger(ETSAssert.class.getPackage().getName());

    private ETSAssert() {
    }

    public static void assertQualifiedName(Node node, QName qName) {
        Assert.assertEquals(node.getLocalName(), qName.getLocalPart(), ErrorMessage.get("LocalName"));
        Assert.assertEquals(node.getNamespaceURI(), qName.getNamespaceURI(), ErrorMessage.get("NamespaceName"));
    }

    public static void assertXPath(String expr, Node context, Map<String, String> namespaceBindings) {
        Boolean result;
        if (null == context) {
            throw new NullPointerException("Context node is null.");
        }
        NamespaceBindings bindings = NamespaceBindings.withStandardBindings();
        bindings.addAllBindings(namespaceBindings);
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(bindings);
        try {
            result = (Boolean)xpath.evaluate(expr, context, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException xpe) {
            String msg = ErrorMessage.format("XPathError", expr);
            LOGR.log(Level.WARNING, msg, xpe);
            throw new AssertionError((Object)msg);
        }
        Element elemNode = Document.class.isInstance(context) ? ((Document)Document.class.cast(context)).getDocumentElement() : (Element)context;
        Assert.assertTrue(result, ErrorMessage.format("XPathResult", elemNode.getNodeName(), expr));
    }

    public static void assertSchemaValid(Validator validator, Source source) {
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        validator.setErrorHandler(errHandler);
        try {
            validator.validate(source);
        }
        catch (Exception e) {
            throw new AssertionError((Object)ErrorMessage.format("XMLError", e.getMessage()));
        }
        Assert.assertFalse(errHandler.errorsDetected(), ErrorMessage.format("NotSchemaValid", errHandler.getErrorCount(), errHandler.toString()));
    }

    public static void assertSchematronValid(URL schemaRef, Source xmlSource, String activePhase) {
        SchematronValidator validator;
        String phase = null == activePhase || activePhase.isEmpty() ? "#ALL" : activePhase;
        try {
            validator = new SchematronValidator(new StreamSource(schemaRef.toString()), phase);
        }
        catch (Exception e) {
            StringBuilder msg = new StringBuilder("Failed to process Schematron schema at ");
            msg.append(schemaRef).append('\n');
            msg.append(e.getMessage());
            throw new AssertionError(msg);
        }
        DOMResult result = (DOMResult)validator.validate(xmlSource);
        Assert.assertFalse(validator.ruleViolationsDetected(), ErrorMessage.format("NotSchemaValid", validator.getRuleViolationCount(), XMLUtils.writeNodeToString(result.getNode())));
    }

    public static void assertDescendantElementCount(Document xmlEntity, QName elementName, int expectedCount) {
        NodeList features = xmlEntity.getElementsByTagNameNS(elementName.getNamespaceURI(), elementName.getLocalPart());
        Assert.assertEquals(features.getLength(), expectedCount, String.format("Unexpected number of %s descendant elements.", elementName));
    }

    public static void assertExceptionReport(ClientResponse rsp, String exceptionCode, String locator) {
        Assert.assertEquals(rsp.getStatus(), ClientResponse.Status.BAD_REQUEST.getStatusCode(), ErrorMessage.get("UnexpectedStatus"));
        Document doc = rsp.getEntity(Document.class);
        String expr = String.format("//ows:Exception[@exceptionCode = '%s']", exceptionCode);
        NodeList nodeList = null;
        try {
            nodeList = XMLUtils.evaluateXPath(doc, expr, null);
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        Assert.assertTrue(nodeList.getLength() > 0, "Exception not found in response: " + expr);
        if (null != locator && !locator.isEmpty()) {
            Element exception = (Element)nodeList.item(0);
            String locatorValue = exception.getAttribute("locator").toLowerCase();
            Assert.assertTrue(locatorValue.contains(locator.toLowerCase()), String.format("Expected locator attribute to contain '%s']", locator));
        }
    }
}

