/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.converter;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.gui.swing.tree.DefaultMutableTreeNode;
import org.geotoolkit.gui.swing.tree.Trees;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.collection.XCollections;
import org.geotoolkit.util.converter.ClassPair;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.converter.CollectionConverter;
import org.geotoolkit.util.converter.DateConverter;
import org.geotoolkit.util.converter.FallbackConverter;
import org.geotoolkit.util.converter.FileConverter;
import org.geotoolkit.util.converter.HeuristicRegistry;
import org.geotoolkit.util.converter.IdentityConverter;
import org.geotoolkit.util.converter.LongConverter;
import org.geotoolkit.util.converter.NonconvertibleObjectException;
import org.geotoolkit.util.converter.NumberConverter;
import org.geotoolkit.util.converter.Numbers;
import org.geotoolkit.util.converter.ObjectConverter;
import org.geotoolkit.util.converter.StringConverter;
import org.geotoolkit.util.converter.URIConverter;
import org.geotoolkit.util.converter.URLConverter;
import org.geotoolkit.util.logging.Logging;

@ThreadSafe
public class ConverterRegistry {
    private final Map<ClassPair<?, ?>, ObjectConverter<?, ?>> converters = new LinkedHashMap();
    private transient Map<Class<?>, Set<Class<?>>> convertibleTypes;

    public static ConverterRegistry system() {
        return System.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void register(ObjectConverter<?, ?> objectConverter) {
        if (objectConverter instanceof FallbackConverter) {
            ObjectConverter objectConverter2;
            ObjectConverter objectConverter3;
            FallbackConverter fallbackConverter;
            FallbackConverter fallbackConverter2 = fallbackConverter = (FallbackConverter)objectConverter;
            synchronized (fallbackConverter2) {
                objectConverter3 = fallbackConverter.converter(true);
                objectConverter2 = fallbackConverter.converter(false);
            }
            this.register(objectConverter3);
            this.register(objectConverter2);
            return;
        }
        Class<?> clazz = objectConverter.getSourceClass();
        Class<?> classArray = objectConverter.getTargetClass();
        Class<?> clazz2 = Classes.findCommonClass(clazz, classArray);
        Map<ClassPair<?, ?>, ObjectConverter<?, ?>> map = this.converters;
        synchronized (map) {
            void var6_12;
            Class<?> object = classArray;
            while (var6_12 != null && !var6_12.equals(clazz2)) {
                ClassPair classPair = new ClassPair(clazz, var6_12);
                this.register(classPair, objectConverter);
                Class clazz3 = var6_12.getSuperclass();
            }
            for (Class<?> clazz4 : classArray.getInterfaces()) {
                if (clazz4.isAssignableFrom(clazz) || Cloneable.class.isAssignableFrom(clazz4) || Comparable.class.isAssignableFrom(clazz4) && clazz.equals(Number.class) || clazz4.isAssignableFrom(clazz)) continue;
                ClassPair classPair = new ClassPair(clazz, clazz4);
                this.register(classPair, objectConverter);
            }
        }
    }

    private void register(ClassPair<?, ?> classPair, ObjectConverter<?, ?> objectConverter) {
        assert (Thread.holdsLock(this.converters));
        assert (objectConverter.getSourceClass().isAssignableFrom(classPair.sourceClass)) : objectConverter;
        assert (classPair.targetClass.isAssignableFrom(objectConverter.getTargetClass())) : objectConverter;
        ObjectConverter<?, ?> objectConverter2 = this.converters.get(classPair);
        if (objectConverter2 != null) {
            assert (!objectConverter2.equals(objectConverter)) : classPair;
            boolean bl = classPair.isDefining(objectConverter);
            if (classPair.isDefining(objectConverter2) == bl) {
                objectConverter = FallbackConverter.createUnsafe(objectConverter2, objectConverter);
            } else if (!bl) {
                return;
            }
        }
        if (objectConverter != objectConverter2) {
            this.converters.put(classPair, objectConverter);
            this.convertibleTypes = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S, T> ObjectConverter<S, T> converter(Class<S> clazz, Class<T> clazz2) throws NonconvertibleObjectException {
        ClassPair<S, T> classPair = new ClassPair<S, T>(clazz, clazz2);
        Map<ClassPair<?, ?>, ObjectConverter<?, ?>> map = this.converters;
        synchronized (map) {
            ObjectConverter<S, T> objectConverter = classPair.cast(this.converters.get(classPair));
            if (objectConverter != null) {
                return objectConverter;
            }
            ClassPair<S, T> classPair2 = classPair;
            while ((classPair2 = classPair2.parentSource()) != null) {
                objectConverter = classPair.cast(this.converters.get(classPair2));
                if (objectConverter == null) continue;
                this.register(classPair, objectConverter);
                return objectConverter;
            }
            objectConverter = this.createConverter(clazz, clazz2);
            if (objectConverter != null) {
                this.register(classPair, objectConverter);
                return objectConverter;
            }
        }
        if (clazz2.isAssignableFrom(clazz)) {
            return classPair.cast(IdentityConverter.create(clazz));
        }
        throw new NonconvertibleObjectException(Errors.format(257, clazz, clazz2));
    }

    <S, T> ObjectConverter<S, T> createConverter(Class<S> clazz, Class<T> clazz2) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Class<? extends T> findCommonTarget(Class<T> clazz, Class<?> ... classArray) {
        Object object;
        if (classArray.length == 0) {
            return clazz;
        }
        Set[] setArray = new Set[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            LinkedHashSet object2 = new LinkedHashSet();
            for (Class clazz2 = classArray[i]; clazz2 != null && clazz.isAssignableFrom(clazz2); clazz2 = clazz2.getSuperclass()) {
                object2.add(clazz2);
            }
            setArray[i] = object2;
        }
        Object object3 = this.converters;
        synchronized (object3) {
            for (ObjectConverter objectConverter : this.converters.values()) {
                Class clazz2 = objectConverter.getTargetClass();
                if (!clazz.isAssignableFrom(clazz2)) continue;
                object = objectConverter.getSourceClass();
                for (int i = 0; i < classArray.length; ++i) {
                    Class<?> clazz3 = classArray[i];
                    if (!((Class)object).isAssignableFrom(clazz3)) continue;
                    setArray[i].add(clazz2);
                }
            }
        }
        object3 = setArray[0];
        for (int i = 1; i < setArray.length; ++i) {
            object3.retainAll(setArray[i]);
        }
        Class<? extends Number> clazz5 = null;
        int n = -1;
        int n2 = -1;
        object = object3.iterator();
        while (object.hasNext()) {
            int n3;
            Class<? extends Number> clazz4;
            Class clazz6 = (Class)object.next();
            int n4 = 0;
            int n5 = 0;
            int n6 = classArray.length;
            while (--n6 >= 0) {
                clazz4 = classArray[n6];
                if (!clazz4.isAssignableFrom(clazz6)) continue;
                n4 = n6;
                ++n5;
            }
            if (n5 < n3) continue;
            if (n5 == n3) {
                if (Number.class.isAssignableFrom(clazz6) && Number.class.isAssignableFrom(clazz5)) {
                    Class clazz7 = clazz6;
                    clazz4 = clazz5;
                    try {
                        clazz5 = Numbers.widestClass(clazz7, clazz4);
                        n2 = n4;
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Logging.recoverableException(ConverterRegistry.class, "getCommonTarget", illegalArgumentException);
                    }
                }
                if (n4 >= n2) continue;
            }
            n2 = n4;
            n3 = n5;
            clazz5 = clazz6;
        }
        return clazz5 != null ? clazz5.asSubclass(clazz) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Class<?>, Set<Class<?>>> getConvertibleTypes() {
        Map<ClassPair<?, ?>, ObjectConverter<?, ?>> map = this.converters;
        synchronized (map) {
            if (this.convertibleTypes == null) {
                LinkedHashMap linkedHashMap = new LinkedHashMap();
                for (ClassPair<?, ?> object : this.converters.keySet()) {
                    LinkedHashSet linkedHashSet = (LinkedHashSet)linkedHashMap.get(object.sourceClass);
                    if (linkedHashSet == null) {
                        linkedHashSet = new LinkedHashSet();
                        linkedHashMap.put(object.sourceClass, linkedHashSet);
                    }
                    linkedHashSet.add(object.targetClass);
                }
                for (Map.Entry entry : linkedHashMap.entrySet()) {
                    entry.setValue(XCollections.unmodifiableSet((Set)entry.getValue()));
                }
                this.convertibleTypes = XCollections.unmodifiableMap(linkedHashMap);
            }
        }
        return this.convertibleTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(Classes.getShortClassName(this));
        Map<ClassPair<?, ?>, ObjectConverter<?, ?>> map = this.converters;
        synchronized (map) {
            for (Map.Entry<ClassPair<?, ?>, ObjectConverter<?, ?>> entry : this.converters.entrySet()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(entry.getKey());
                ObjectConverter<?, ?> objectConverter = entry.getValue();
                if (objectConverter instanceof FallbackConverter) {
                    ((FallbackConverter)objectConverter).toTree(defaultMutableTreeNode2);
                }
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
        }
        return Trees.toString(defaultMutableTreeNode);
    }

    private static final class System
    extends HeuristicRegistry {
        static final System INSTANCE = new System();

        private System() {
            this.register(StringConverter.Number.INSTANCE);
            this.register(StringConverter.Double.INSTANCE);
            this.register(StringConverter.Float.INSTANCE);
            this.register(StringConverter.Long.INSTANCE);
            this.register(StringConverter.Integer.INSTANCE);
            this.register(StringConverter.Short.INSTANCE);
            this.register(StringConverter.Byte.INSTANCE);
            this.register(StringConverter.Boolean.INSTANCE);
            this.register(StringConverter.BigDecimal.INSTANCE);
            this.register(StringConverter.BigInteger.INSTANCE);
            this.register(StringConverter.Color.INSTANCE);
            this.register(StringConverter.Locale.INSTANCE);
            this.register(StringConverter.Charset.INSTANCE);
            this.register(StringConverter.InternationalString.INSTANCE);
            this.register(StringConverter.File.INSTANCE);
            this.register(StringConverter.URL.INSTANCE);
            this.register(StringConverter.URI.INSTANCE);
            this.register(NumberConverter.Comparable.INSTANCE);
            this.register(NumberConverter.Double.INSTANCE);
            this.register(NumberConverter.Float.INSTANCE);
            this.register(NumberConverter.Long.INSTANCE);
            this.register(NumberConverter.Integer.INSTANCE);
            this.register(NumberConverter.Short.INSTANCE);
            this.register(NumberConverter.Byte.INSTANCE);
            this.register(NumberConverter.Boolean.INSTANCE);
            this.register(NumberConverter.BigDecimal.INSTANCE);
            this.register(NumberConverter.BigInteger.INSTANCE);
            this.register(NumberConverter.Color.INSTANCE);
            this.register(NumberConverter.String.INSTANCE);
            this.register(DateConverter.Timestamp.INSTANCE);
            this.register(DateConverter.SQL.INSTANCE);
            this.register(DateConverter.Long.INSTANCE);
            this.register(LongConverter.Date.INSTANCE);
            this.register(FileConverter.URI.INSTANCE);
            this.register(FileConverter.URL.INSTANCE);
            this.register(FileConverter.String.INSTANCE);
            this.register(URLConverter.URI.INSTANCE);
            this.register(URLConverter.File.INSTANCE);
            this.register(URLConverter.String.INSTANCE);
            this.register(URIConverter.URL.INSTANCE);
            this.register(URIConverter.File.INSTANCE);
            this.register(URIConverter.String.INSTANCE);
            this.register(CollectionConverter.List.INSTANCE);
            this.register(CollectionConverter.Set.INSTANCE);
            Iterator<ObjectConverter> iterator = ServiceLoader.load(ObjectConverter.class).iterator();
            while (iterator.hasNext()) {
                this.register(iterator.next());
            }
        }
    }
}

