/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.math;

import org.geotoolkit.math.ExtrapolationException;
import org.geotoolkit.math.Search1D;

public class Hermite1D
extends Search1D {
    public double dx;
    private double[] y2;

    @Override
    public void setData(double[] x, double[] y) {
        super.setData(x, y);
        this.y2 = null;
    }

    public void setData(double[] x, double[] y, double[] y2) {
        super.setData(x, y);
        this.y2 = y2;
    }

    @Override
    public void clear() {
        super.clear();
        this.y2 = null;
    }

    @Override
    protected double interpolate(double xi, boolean reUseIndex) throws ExtrapolationException {
        double dy_khi;
        double dy_klo;
        if (this.ignoreYNaN && !reUseIndex) {
            this.validateIndex(this.y);
        }
        if (this.klo == this.khi) {
            return this.y[this.klo];
        }
        if (this.y2 != null) {
            dy_klo = this.y2[this.klo];
            dy_khi = this.y2[this.khi];
        } else {
            int slo = this.klo;
            if (--slo < 0 || this.isNaN(slo)) {
                slo = this.klo;
            }
            int shi = this.khi;
            if (++shi >= this.x.length || this.isNaN(shi)) {
                shi = this.khi;
            }
            dy_klo = (this.y[this.khi] - this.y[slo]) / (this.x[this.khi] - this.x[slo]);
            dy_khi = (this.y[shi] - this.y[this.klo]) / (this.x[shi] - this.x[this.klo]);
        }
        this.dx = this.x[this.khi] - this.x[this.klo];
        double deltaX_klo = xi - this.x[this.klo];
        double deltaX_khi = this.x[this.khi] - xi;
        double rankX_klo = deltaX_klo / this.dx;
        double rankX_khi = deltaX_khi / this.dx;
        return (float)((this.y[this.klo] * (1.0 + 2.0 * rankX_klo) + dy_klo * deltaX_klo) * (rankX_khi * rankX_khi) + (this.y[this.khi] * (1.0 + 2.0 * rankX_khi) - dy_khi * deltaX_khi) * (rankX_klo * rankX_klo));
    }

    private final boolean isNaN(int index) {
        return Double.isNaN(this.x[index]) || this.ignoreYNaN && Double.isNaN(this.y[index]);
    }
}

