/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.eogeojson10.core;

import java.io.File;
import java.io.InputStream;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;
import org.opengis.cite.eogeojson10.DataFixture;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CoreTests
extends DataFixture {
    @Test(description="Implements /conf/core, Sections 7.1 and Section 7.8")
    public void validateEOMetadataGeoJSONValidPerSchema() {
        StringBuffer errorMessage = new StringBuffer();
        String schemaToApply = "/org/opengis/cite/eogeojson10/jsonschema/eo-geojson-schema-standalone.json";
        boolean valid = false;
        InputStream inputStream = this.getClass().getResourceAsStream(schemaToApply);
        Schema schema = null;
        try {
            JSONObject rawSchema = new JSONObject(this.convertInputStreamToString(inputStream));
            schema = SchemaLoader.load((JSONObject)rawSchema);
            schema.validate((Object)this.readJSONObjectFromFile(new File(this.testSubject)));
            valid = true;
        }
        catch (Exception ex) {
            errorMessage.append("Validation of single feature document failed because " + ex.getMessage() + "\n");
            valid = false;
        }
        if (!valid) {
            Assert.assertTrue((boolean)valid, (String)("Validation failed. " + errorMessage.toString() + " . "));
        }
        JSONObject jo = null;
        boolean validCol = false;
        try {
            jo = this.readJSONObjectFromFile(new File(this.collectionTestSubject));
            if (jo.has("type")) {
                if (jo.get("type").equals("FeatureCollection")) {
                    schema.validate((Object)jo);
                    validCol = true;
                } else {
                    validCol = false;
                    errorMessage.append("Validation of feature collection did not have type property value that equals 'FeatureCollection'\n");
                }
            } else {
                validCol = false;
                errorMessage.append("Validation of feature collection did not have type property\n");
            }
        }
        catch (Exception ex) {
            errorMessage.append("Validation of Feature Collection failed because " + ex.getMessage() + "\n");
            validCol = false;
        }
        if (!validCol) {
            Assert.assertTrue((boolean)validCol, (String)("Validation failed. " + errorMessage.toString()));
        }
    }
}

