/*
 * Decompiled with CFR 0.152.
 */
package com.bric.geom;

import com.bric.geom.RectangleReader;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class Clipper {
    private static final float TOLERANCE = 1.0E-4f;

    public static GeneralPath clipToRect(Shape s2, Rectangle2D r) {
        return Clipper.clipToRect(s2, null, r);
    }

    public static GeneralPath clipToRect(Shape s2, AffineTransform t2, Rectangle2D r) {
        RectangleClipper clipper = new RectangleClipper(r);
        return clipper.clip(s2, t2);
    }

    abstract void cap(Point2D.Float var1);

    abstract boolean contains(float var1, float var2);

    abstract int collectIntersectionTimes(Function var1, Function var2, double[] var3);

    GeneralPath clip(Shape incomingShape, AffineTransform transform) {
        PathIterator i = incomingShape.getPathIterator(transform);
        ClippedPath p = new ClippedPath(i.getWindingRule());
        float initialX = 0.0f;
        float initialY = 0.0f;
        float[] f = new float[6];
        boolean shouldClose = false;
        float lastX = 0.0f;
        float lastY = 0.0f;
        LFunction lxf = new LFunction();
        LFunction lyf = new LFunction();
        QFunction qxf = new QFunction();
        QFunction qyf = new QFunction();
        CFunction cxf = new CFunction();
        CFunction cyf = new CFunction();
        Function xf = null;
        Function yf = null;
        Point2D.Float point = new Point2D.Float();
        double[] intersectionTimes = new double[16];
        while (!i.isDone()) {
            int k = i.currentSegment(f);
            if (k == 0) {
                initialX = f[0];
                initialY = f[1];
                point.setLocation(f[0], f[1]);
                this.cap(point);
                p.moveTo(point.x, point.y);
                lastX = f[0];
                lastY = f[1];
            } else if (k == 4) {
                f[0] = initialX;
                f[1] = initialY;
                k = 1;
                shouldClose = true;
            }
            xf = null;
            if (k == 1) {
                lxf.define(lastX, f[0]);
                lyf.define(lastY, f[1]);
                xf = lxf;
                yf = lyf;
            } else if (k == 2) {
                qxf.define(lastX, f[0], f[2]);
                qyf.define(lastY, f[1], f[3]);
                xf = qxf;
                yf = qyf;
            } else if (k == 3) {
                cxf.define(lastX, f[0], f[2], f[4]);
                cyf.define(lastY, f[1], f[3], f[5]);
                xf = cxf;
                yf = cyf;
            }
            if (xf != null) {
                int tCtr = this.collectIntersectionTimes(xf, yf, intersectionTimes);
                intersectionTimes[tCtr++] = 1.0;
                intersectionTimes[tCtr++] = 0.0;
                Arrays.sort(intersectionTimes, 0, tCtr);
                boolean lastValueWasCapped = !this.contains(lastX, lastY);
                for (int a = 0; a < tCtr; ++a) {
                    boolean midValueInvalid;
                    if (a > 0 && intersectionTimes[a] == intersectionTimes[a - 1] || !(intersectionTimes[a] > 0.0) || !(intersectionTimes[a] <= 1.0)) continue;
                    float x = (float)xf.evaluate(intersectionTimes[a]);
                    float y = (float)yf.evaluate(intersectionTimes[a]);
                    point.setLocation(x, y);
                    this.cap(point);
                    boolean thisValueIsCapped = !(Math.abs(x - point.x) < 1.0E-4f) || !(Math.abs(y - point.y) < 1.0E-4f);
                    float x2 = (float)xf.evaluate((intersectionTimes[a] + intersectionTimes[a - 1]) / 2.0);
                    float y2 = (float)yf.evaluate((intersectionTimes[a] + intersectionTimes[a - 1]) / 2.0);
                    boolean bl = midValueInvalid = !this.contains(x2, y2);
                    if (xf instanceof LFunction || thisValueIsCapped || lastValueWasCapped || midValueInvalid) {
                        p.lineTo(point.x, point.y);
                    } else if (xf instanceof QFunction || xf instanceof CFunction) {
                        p.curveTo(xf, yf, intersectionTimes[a - 1], intersectionTimes[a]);
                    } else {
                        throw new RuntimeException("Unexpected condition.");
                    }
                    lastValueWasCapped = thisValueIsCapped;
                }
                lastX = (float)xf.evaluate(1.0);
                lastY = (float)yf.evaluate(1.0);
            }
            if (shouldClose) {
                p.closePath();
                shouldClose = false;
            }
            i.next();
        }
        p.flush();
        return p.g;
    }

    public static void clip(Graphics2D g2, Shape newClip) {
        Shape oldClip = g2.getClip();
        if (oldClip == null) {
            g2.setClip(newClip);
            return;
        }
        Rectangle2D oldRect = RectangleReader.convert(oldClip);
        Rectangle2D newRect = RectangleReader.convert(newClip);
        if (oldRect != null && newRect != null) {
            Rectangle2D intersectedClip = oldRect.createIntersection(newRect);
            if (intersectedClip.getWidth() < 0.0 || intersectedClip.getHeight() < 0.0) {
                intersectedClip.setFrame(intersectedClip.getX(), intersectedClip.getY(), 0.0, 0.0);
            }
            g2.setClip(intersectedClip);
            return;
        }
        if (newRect != null && oldRect == null) {
            GeneralPath intersectedClip = Clipper.clipToRect(oldClip, newRect);
            g2.setClip(intersectedClip);
            return;
        }
        if (newRect == null && oldRect != null) {
            GeneralPath intersectedClip = Clipper.clipToRect(newClip, oldRect);
            g2.setClip(intersectedClip);
            return;
        }
        g2.clip(newClip);
    }

    private static class RectangleClipper
    extends Clipper {
        final float rTop;
        final float rLeft;
        final float rRight;
        final float rBottom;

        private RectangleClipper(Rectangle2D rect) {
            this.rTop = (float)rect.getY();
            this.rLeft = (float)rect.getX();
            this.rRight = (float)(rect.getX() + rect.getWidth());
            this.rBottom = (float)(rect.getY() + rect.getHeight());
        }

        @Override
        boolean contains(float x, float y) {
            return x >= this.rLeft && x <= this.rRight && y >= this.rTop && y <= this.rBottom;
        }

        @Override
        void cap(Point2D.Float p) {
            if (p.x < this.rLeft) {
                p.x = this.rLeft;
            }
            if (p.x > this.rRight) {
                p.x = this.rRight;
            }
            if (p.y < this.rTop) {
                p.y = this.rTop;
            }
            if (p.y > this.rBottom) {
                p.y = this.rBottom;
            }
        }

        @Override
        int collectIntersectionTimes(Function xf, Function yf, double[] intersectionTimes) {
            int sum = 0;
            sum += xf.evaluateInverse(this.rLeft, intersectionTimes, sum);
            sum += xf.evaluateInverse(this.rRight, intersectionTimes, sum);
            sum += yf.evaluateInverse(this.rTop, intersectionTimes, sum);
            sum += yf.evaluateInverse(this.rBottom, intersectionTimes, sum);
            return sum;
        }
    }

    static class ClippedPath {
        public final GeneralPath g;
        private final ArrayList<float[]> uncommittedPoints = new ArrayList();
        private float initialX;
        private float initialY;

        public ClippedPath(int windingRule) {
            this.g = new GeneralPath(windingRule);
        }

        public void moveTo(float x, float y) {
            this.flush();
            this.g.moveTo(x, y);
            this.initialX = x;
            this.initialY = y;
        }

        public void curveTo(Function xf, Function yf, double t0, double t1) {
            this.flush();
            double dt = t1 - t0;
            double dx0 = xf.getDerivative(t0) * dt;
            double dx1 = xf.getDerivative(t1) * dt;
            double dy0 = yf.getDerivative(t0) * dt;
            double dy1 = yf.getDerivative(t1) * dt;
            double x0 = xf.evaluate(t0);
            double x1 = xf.evaluate(t1);
            double y0 = yf.evaluate(t0);
            double y1 = yf.evaluate(t1);
            this.g.curveTo((float)(x0 + dx0 / 3.0), (float)(y0 + dy0 / 3.0), (float)(x1 - dx1 / 3.0), (float)(y1 - dy1 / 3.0), (float)x1, (float)y1);
        }

        public void lineTo(float x, float y) {
            float[] last;
            if (this.uncommittedPoints.size() > 0 && Math.abs((last = this.uncommittedPoints.get(this.uncommittedPoints.size() - 1))[0] - x) < 1.0E-4f && Math.abs(last[1] - y) < 1.0E-4f) {
                return;
            }
            this.uncommittedPoints.add(new float[]{x, y});
        }

        public void closePath() {
            this.lineTo(this.initialX, this.initialY);
            this.flush();
            this.g.closePath();
        }

        public void flush() {
            int size = this.uncommittedPoints.size();
            if (size < 1) {
                return;
            }
            if (size < 3) {
                for (float[] p : this.uncommittedPoints) {
                    this.g.lineTo(p[0], p[1]);
                }
            } else {
                int i = 0;
                float[] first = this.uncommittedPoints.get(i++);
                float[] middle = this.uncommittedPoints.get(i++);
                do {
                    float vx;
                    float uy;
                    int n = i++;
                    float ux = middle[0] - first[0];
                    float[] last = this.uncommittedPoints.get(n);
                    float vy = last[1] - first[1];
                    if (Math.abs(ux * vy - (uy = middle[1] - first[1]) * (vx = last[0] - first[0])) > 1.0E-4f) {
                        this.g.lineTo(first[0], first[1]);
                        first = middle;
                    }
                    middle = last;
                } while (i < size);
                this.g.lineTo(first[0], first[1]);
                this.g.lineTo(middle[0], middle[1]);
            }
            this.uncommittedPoints.clear();
        }
    }

    static class LFunction
    implements Function {
        double slope;
        double intercept;

        public void define(double x1, double x2) {
            this.slope = x2 - x1;
            this.intercept = x1;
        }

        public String toString() {
            return this.slope + "*t+" + this.intercept;
        }

        @Override
        public double evaluate(double t2) {
            return this.slope * t2 + this.intercept;
        }

        @Override
        public int evaluateInverse(double x, double[] dest, int offset) {
            dest[offset] = (x - this.intercept) / this.slope;
            return 1;
        }

        @Override
        public double getDerivative(double t2) {
            return this.slope;
        }
    }

    static class QFunction
    implements Function {
        double a;
        double b;
        double c;

        public String toString() {
            return this.a + "*t*t+" + this.b + "*t+" + this.c;
        }

        public void define(double x0, double x1, double x2) {
            this.a = x0 - 2.0 * x1 + x2;
            this.b = -2.0 * x0 + 2.0 * x1;
            this.c = x0;
        }

        @Override
        public double evaluate(double t2) {
            return this.a * t2 * t2 + this.b * t2 + this.c;
        }

        @Override
        public double getDerivative(double t2) {
            return 2.0 * this.a * t2 + this.b;
        }

        @Override
        public int evaluateInverse(double x, double[] dest, int offset) {
            double C2 = this.c - x;
            double det = this.b * this.b - 4.0 * this.a * C2;
            if (det < 0.0) {
                return 0;
            }
            if (det == 0.0) {
                dest[offset] = -this.b / (2.0 * this.a);
                return 1;
            }
            det = Math.sqrt(det);
            dest[offset++] = (-this.b + det) / (2.0 * this.a);
            dest[offset++] = (-this.b - det) / (2.0 * this.a);
            return 2;
        }
    }

    static class CFunction
    implements Function {
        double a;
        double b;
        double c;
        double d;
        double[] t2;
        double[] eqn;

        public String toString() {
            return this.a + "*t*t*t+" + this.b + "*t*t+" + this.c + "*t+" + this.d;
        }

        public void define(double x0, double x1, double x2, double x3) {
            this.a = -x0 + 3.0 * x1 - 3.0 * x2 + x3;
            this.b = 3.0 * x0 - 6.0 * x1 + 3.0 * x2;
            this.c = -3.0 * x0 + 3.0 * x1;
            this.d = x0;
        }

        @Override
        public double evaluate(double t2) {
            return this.a * t2 * t2 * t2 + this.b * t2 * t2 + this.c * t2 + this.d;
        }

        @Override
        public double getDerivative(double t2) {
            return 3.0 * this.a * t2 * t2 + 2.0 * this.b * t2 + this.c;
        }

        @Override
        public int evaluateInverse(double x, double[] dest, int offset) {
            int k;
            if (this.eqn == null) {
                this.eqn = new double[4];
            }
            this.eqn[0] = this.d - x;
            this.eqn[1] = this.c;
            this.eqn[2] = this.b;
            this.eqn[3] = this.a;
            if (offset == 0) {
                int k2 = CubicCurve2D.solveCubic(this.eqn, dest);
                if (k2 < 0) {
                    return 0;
                }
                return k2;
            }
            if (this.t2 == null) {
                this.t2 = new double[3];
            }
            if ((k = CubicCurve2D.solveCubic(this.eqn, this.t2)) < 0) {
                return 0;
            }
            System.arraycopy(this.t2, 0, dest, offset, k);
            return k;
        }
    }

    static interface Function {
        public double evaluate(double var1);

        public int evaluateInverse(double var1, double[] var3, int var4);

        public double getDerivative(double var1);
    }
}

