/*
 * Decompiled with CFR 0.152.
 */
package com.bric.math.function;

import com.bric.math.function.Function;
import com.bric.math.function.PolynomialFunction;
import java.util.HashSet;
import java.util.Iterator;

public class PiecewiseFunction
implements Function {
    Function[] functions;
    double[] upperBounds;
    private double fixedIntervalLength = -1.0;

    public static PiecewiseFunction create(Function f, Function fDeriv, double min2, double max, int functions) {
        Function[] array = new Function[functions];
        double[] bounds = new double[functions - 1];
        for (int a = 0; a < functions; ++a) {
            double minX = min2 + (max - min2) * (double)a / (double)functions;
            double maxX = min2 + (max - min2) * (double)(a + 1) / (double)functions;
            double minY = f.evaluate(minX);
            double maxY = f.evaluate(maxX);
            if (Double.isNaN(minY) || Double.isNaN(maxY)) {
                throw new IllegalArgumentException("f(" + minX + ") = " + minY + ", f(" + maxX + ") = " + maxY);
            }
            double minYDeriv = fDeriv.evaluate(minX);
            double maxYDeriv = fDeriv.evaluate(maxX);
            if (Double.isNaN(minYDeriv) || Double.isNaN(maxYDeriv) || Double.isInfinite(minYDeriv) || Double.isInfinite(maxYDeriv)) {
                array[a] = f;
            } else {
                try {
                    array[a] = PolynomialFunction.createFit(new double[]{minX, maxX}, new double[]{minY, maxY}, new double[]{minYDeriv, maxYDeriv});
                }
                catch (RuntimeException e) {
                    System.err.println("a = " + a);
                    System.err.println("mixX = " + minX);
                    System.err.println("maxX = " + maxX);
                    System.err.println("minY = " + minY);
                    System.err.println("maxY = " + maxY);
                    System.err.println("minYDeriv = " + minYDeriv);
                    System.err.println("maxYDeriv = " + maxYDeriv);
                    throw e;
                }
            }
            if (a == 0) continue;
            bounds[a - 1] = minX;
        }
        return new PiecewiseFunction(array, bounds);
    }

    public PiecewiseFunction(Function[] functions, double[] upperBounds) {
        if (upperBounds.length + 1 != functions.length) {
            throw new IllegalArgumentException("there should be 1 less upperbounds (" + upperBounds.length + ") than functions (" + functions.length + ")");
        }
        this.functions = new Function[functions.length];
        System.arraycopy(functions, 0, this.functions, 0, functions.length);
        this.upperBounds = new double[upperBounds.length];
        System.arraycopy(upperBounds, 0, this.upperBounds, 0, upperBounds.length);
        if (upperBounds.length > 2) {
            double delta = upperBounds[1] - upperBounds[0];
            for (int a = 2; a < upperBounds.length; ++a) {
                double k = upperBounds[a] - upperBounds[a - 1];
                if (!(Math.abs(delta - k) > 1.0E-11)) continue;
                return;
            }
            this.fixedIntervalLength = delta;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PiecewiseFunction[ ");
        sb.append(" x=(-inf, " + this.upperBounds[0] + "] " + this.functions[0]);
        for (int a = 1; a < this.upperBounds.length; ++a) {
            sb.append(", ");
            sb.append(" x=(" + this.upperBounds[a - 1] + ", " + this.upperBounds[a] + "] " + this.functions[a]);
        }
        sb.append(" x=(" + this.upperBounds[this.upperBounds.length - 1] + ", +inf) " + this.functions[this.functions.length - 1]);
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public double evaluate(double x) {
        if (this.fixedIntervalLength > 0.0) {
            double min2 = this.upperBounds[0] - this.fixedIntervalLength;
            double max = this.upperBounds[this.upperBounds.length - 1] + this.fixedIntervalLength;
            int index = (int)((x - min2) / (max - min2) * (double)this.functions.length);
            if (index == this.functions.length) {
                --index;
            }
            return this.functions[index].evaluate(x);
        }
        for (int a = 0; a < this.upperBounds.length; ++a) {
            if (!(x < this.upperBounds[a])) continue;
            return this.functions[a].evaluate(x);
        }
        return this.functions[this.functions.length - 1].evaluate(x);
    }

    @Override
    public double[] evaluateInverse(double y) {
        HashSet<Double> set = new HashSet<Double>();
        for (int a = 0; a < this.functions.length; ++a) {
            double[] x = this.functions[a].evaluateInverse(y);
            double minX = a == 0 ? Double.MIN_VALUE : this.upperBounds[a - 1];
            double maxX = a == this.functions.length - 1 ? Double.MAX_VALUE : this.upperBounds[a];
            for (int b = 0; b < x.length; ++b) {
                if (!(x[b] >= minX) || !(x[b] <= maxX)) continue;
                set.add(new Double(x[b]));
            }
        }
        int ctr = 0;
        double[] array = new double[set.size()];
        Iterator i = set.iterator();
        while (i.hasNext()) {
            array[ctr++] = (Double)i.next();
        }
        return array;
    }

    public Function getFunction(int index) {
        return this.functions[index];
    }

    public int getFunctionCount() {
        return this.functions.length;
    }

    public void setFunction(int index, Function f) {
        this.functions[index] = f;
    }
}

