/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.jsonoverlay.gen;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TypeData {
    private Collection<Type> types;
    private Map<String, String> imports = new HashMap<String, String>();
    private List<String> defaultExtendInterfaces = null;
    private Map<String, Type> typeMap = null;
    private String modelType = null;
    private String discriminator = null;
    @JsonProperty
    private Object decls;

    public void init() {
        this.typeMap = this.types.stream().collect(Collectors.toMap(Type::getName, t2 -> t2));
        this.types.stream().forEach(t2 -> t2.init(this));
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    public Collection<Type> getTypes() {
        return this.types;
    }

    public Map<String, Type> getTypeMap() {
        return this.typeMap;
    }

    public Type getType(String typeName) {
        return this.typeMap.get(typeName);
    }

    public Map<String, String> getImports() {
        return this.imports;
    }

    public List<String> getDefaultExtendInterfaces() {
        return this.defaultExtendInterfaces;
    }

    public static enum Structure {
        scalar,
        collection,
        map;

    }

    public static class Method {
        private String name;
        private String type;
        private List<String> argDecls;
        private List<String> code;

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public List<String> getArgDecls() {
            return this.argDecls;
        }

        public List<String> getCode() {
            return this.code;
        }
    }

    public static class Field {
        private String name;
        private String plural;
        private Structure structure = Structure.scalar;
        private String type;
        private String keyName = "name";
        private String keyPattern;
        private boolean noImpl;
        private String id;
        private boolean boolDefault = false;
        private String parentPath;
        private Type container;

        public void init(String id, Type container) {
            this.id = id;
            this.container = container;
            if (this.name == null) {
                String[] parts = id.split("/");
                String lastPart = parts[parts.length - 1];
                String defaultName = lastPart.substring(0, 1).toUpperCase() + lastPart.substring(1);
                if (this.structure == Structure.scalar) {
                    this.name = defaultName;
                } else {
                    String string = this.name = defaultName.endsWith("s") ? defaultName.substring(0, defaultName.length() - 1) : defaultName;
                }
            }
            if (this.type == null) {
                this.type = this.getTypeData().getType(this.name) != null ? this.name : "String";
            }
        }

        public String getId() {
            return this.id;
        }

        public Type getContainer() {
            return this.container;
        }

        public TypeData getTypeData() {
            return this.container.getTypeData();
        }

        public String getName() {
            return this.name;
        }

        public String getLcName() {
            String lcName;
            switch (lcName = this.lcFirst(this.name)) {
                case "default": 
                case "enum": {
                    lcName = lcName + "Value";
                }
            }
            return lcName;
        }

        public String getPlural() {
            return this.plural != null ? this.plural : this.name + "s";
        }

        public String getLcPlural() {
            return this.lcFirst(this.getPlural());
        }

        public Structure getStructure() {
            return this.structure;
        }

        public String getType() {
            return this.type.equals("Primitive") ? "Object" : this.type;
        }

        String lcFirst(String s2) {
            return s2.substring(0, 1).toLowerCase() + s2.substring(1);
        }

        public String getKeyName() {
            return this.keyName;
        }

        public String getKeyPattern() {
            return this.keyPattern;
        }

        public boolean isNoImpl() {
            return this.noImpl;
        }

        public boolean isBoolean() {
            return this.getType().equals("Boolean");
        }

        public boolean getBoolDefault() {
            return this.boolDefault;
        }

        public String getParentPath() {
            return this.parentPath != null ? this.parentPath : this.id;
        }

        public String getImplType() {
            Type objectType = this.getContainer().getTypeData().getTypeMap().get(this.getType());
            return Type.getImplType(objectType != null ? objectType.getName() : this.type);
        }

        public boolean isScalarType() {
            switch (this.getType()) {
                case "String": 
                case "Integer": 
                case "Number": 
                case "Boolean": 
                case "Primitive": 
                case "Object": {
                    return true;
                }
            }
            return false;
        }

        public String getPropertyName() {
            return this.structure == Structure.scalar ? this.getLcName() : this.getLcPlural();
        }

        public String getOverlayType() {
            return this.getType() + (this.isScalarType() ? "Overlay" : "");
        }
    }

    public static class Type {
        private String name;
        private Map<String, Field> fields = new LinkedHashMap<String, Field>();
        private List<String> extendInterfaces = new ArrayList<String>();
        private Map<String, Collection<String>> imports = new HashMap<String, Collection<String>>();
        private boolean noGen = false;
        private String extensionOf;
        private Map<String, String> renames = new HashMap<String, String>();
        @JsonProperty(value="abstract")
        private boolean abstractType = false;
        private String discriminator = null;
        private String discriminatorValue = null;
        private List<String> enumValues = new ArrayList<String>();
        private TypeData typeData;

        public void init(TypeData typeData) {
            this.typeData = typeData;
            for (Map.Entry<String, Field> field : this.fields.entrySet()) {
                field.getValue().init(field.getKey(), this);
            }
        }

        public TypeData getTypeData() {
            return this.typeData;
        }

        public Collection<String> getRequiredImports(String ... moduleTypes) {
            List interfaces;
            LinkedHashSet<String> results = new LinkedHashSet<String>();
            List list = interfaces = this.extendInterfaces != null ? this.extendInterfaces : this.typeData.defaultExtendInterfaces;
            if (interfaces != null) {
                results.addAll(interfaces);
            }
            for (String moduleType : moduleTypes) {
                if (this.imports.get(moduleType) == null) continue;
                results.addAll(this.imports.get(moduleType));
            }
            return results;
        }

        public String getIntfExtendsDecl() {
            List interfaces = this.extendInterfaces != null ? this.extendInterfaces : this.typeData.defaultExtendInterfaces;
            return interfaces != null ? " extends " + interfaces.stream().collect(Collectors.joining(",")) : "";
        }

        public String getName() {
            return this.name;
        }

        public String getLcName() {
            String lcName = this.lcFirst(this.name);
            return lcName;
        }

        public Map<String, Field> getFields() {
            return this.fields;
        }

        public List<String> getExtendInterfaces() {
            return this.extendInterfaces;
        }

        public Map<String, Collection<String>> getImports() {
            return this.imports;
        }

        public boolean isNoGen() {
            return this.noGen;
        }

        public String getExtensionOf() {
            return this.extensionOf;
        }

        public Map<String, String> getRenames() {
            return this.renames;
        }

        public boolean isAbstract() {
            return this.abstractType;
        }

        public String getDiscriminator() {
            return this.discriminator != null ? this.discriminator : this.typeData.getDiscriminator();
        }

        public String getDiscriminatorValue() {
            return this.discriminatorValue != null ? this.discriminatorValue : this.name;
        }

        public List<String> getEnumValues() {
            return this.enumValues;
        }

        public String getImplType() {
            return this.isNoGen() ? this.name : Type.getImplType(this.name);
        }

        public static String getImplType(String typeName) {
            switch (typeName) {
                case "String": 
                case "Integer": 
                case "Number": 
                case "Boolean": 
                case "Primitive": 
                case "Object": {
                    return typeName + "Overlay";
                }
            }
            return typeName + "Impl";
        }

        String lcFirst(String s2) {
            return s2.substring(0, 1).toLowerCase() + s2.substring(1);
        }
    }
}

