/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarantlr4.runtime.misc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;

public class Stats {
    public static final String ANTLRWORKS_DIR = "antlrworks";

    public static double stddev(int[] X2) {
        int m4 = X2.length;
        if (m4 <= 1) {
            return 0.0;
        }
        double xbar = Stats.avg(X2);
        double s2 = 0.0;
        for (int i = 0; i < m4; ++i) {
            s2 += ((double)X2[i] - xbar) * ((double)X2[i] - xbar);
        }
        return Math.sqrt(s2 /= (double)(m4 - 1));
    }

    public static double avg(int[] X2) {
        double xbar = 0.0;
        int m4 = X2.length;
        if (m4 == 0) {
            return 0.0;
        }
        for (int i = 0; i < m4; ++i) {
            xbar += (double)X2[i];
        }
        if (xbar >= 0.0) {
            return xbar / (double)m4;
        }
        return 0.0;
    }

    public static int min(int[] X2) {
        int min2 = Integer.MAX_VALUE;
        int m4 = X2.length;
        if (m4 == 0) {
            return 0;
        }
        for (int i = 0; i < m4; ++i) {
            if (X2[i] >= min2) continue;
            min2 = X2[i];
        }
        return min2;
    }

    public static int max(int[] X2) {
        int max = Integer.MIN_VALUE;
        int m4 = X2.length;
        if (m4 == 0) {
            return 0;
        }
        for (int i = 0; i < m4; ++i) {
            if (X2[i] <= max) continue;
            max = X2[i];
        }
        return max;
    }

    public static double avg(List<Integer> X2) {
        double xbar = 0.0;
        int m4 = X2.size();
        if (m4 == 0) {
            return 0.0;
        }
        for (int i = 0; i < m4; ++i) {
            xbar += (double)X2.get(i).intValue();
        }
        if (xbar >= 0.0) {
            return xbar / (double)m4;
        }
        return 0.0;
    }

    public static int min(List<Integer> X2) {
        int min2 = Integer.MAX_VALUE;
        int m4 = X2.size();
        if (m4 == 0) {
            return 0;
        }
        for (int i = 0; i < m4; ++i) {
            if (X2.get(i) >= min2) continue;
            min2 = X2.get(i);
        }
        return min2;
    }

    public static int max(List<Integer> X2) {
        int max = Integer.MIN_VALUE;
        int m4 = X2.size();
        if (m4 == 0) {
            return 0;
        }
        for (int i = 0; i < m4; ++i) {
            if (X2.get(i) <= max) continue;
            max = X2.get(i);
        }
        return max;
    }

    public static int sum(int[] X2) {
        int s2 = 0;
        int m4 = X2.length;
        if (m4 == 0) {
            return 0;
        }
        for (int i = 0; i < m4; ++i) {
            s2 += X2[i];
        }
        return s2;
    }

    public static void writeReport(String filename, String data) throws IOException {
        String absoluteFilename = Stats.getAbsoluteFileName(filename);
        File f = new File(absoluteFilename);
        File parent = f.getParentFile();
        parent.mkdirs();
        FileOutputStream fos = new FileOutputStream(f, true);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        PrintStream ps = new PrintStream(bos);
        ps.println(data);
        ps.close();
        bos.close();
        fos.close();
    }

    public static String getAbsoluteFileName(String filename) {
        return System.getProperty("user.home") + File.separator + ANTLRWORKS_DIR + File.separator + filename;
    }
}

