/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarantlr4.v4.gui;

import groovyjarjarantlr4.v4.gui.TreePostScriptGenerator;
import groovyjarjarantlr4.v4.gui.TreeTextProvider;
import groovyjarjarantlr4.v4.gui.TreeViewer;
import groovyjarjarantlr4.v4.runtime.Parser;
import groovyjarjarantlr4.v4.runtime.misc.NotNull;
import groovyjarjarantlr4.v4.runtime.misc.Nullable;
import groovyjarjarantlr4.v4.runtime.misc.Utils;
import groovyjarjarantlr4.v4.runtime.tree.Tree;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import javax.print.PrintException;
import javax.swing.JDialog;

public class Trees {
    public static Future<JDialog> inspect(@Nullable Tree t2, @Nullable List<String> ruleNames) {
        TreeViewer viewer = new TreeViewer(ruleNames, t2);
        return viewer.open();
    }

    public static Future<JDialog> inspect(@Nullable Tree t2, @Nullable Parser parser) {
        List<String> ruleNames = parser != null ? Arrays.asList(parser.getRuleNames()) : null;
        return Trees.inspect(t2, ruleNames);
    }

    public static void save(@Nullable Tree t2, @Nullable Parser parser, String fileName) throws IOException, PrintException {
        List<String> ruleNames = parser != null ? Arrays.asList(parser.getRuleNames()) : null;
        Trees.save(t2, ruleNames, fileName);
    }

    public static void save(Tree t2, @Nullable Parser parser, String fileName, String fontName, int fontSize) throws IOException {
        List<String> ruleNames = parser != null ? Arrays.asList(parser.getRuleNames()) : null;
        Trees.save(t2, ruleNames, fileName, fontName, fontSize);
    }

    public static void save(Tree t2, @Nullable List<String> ruleNames, String fileName) throws IOException, PrintException {
        Trees.writePS(t2, ruleNames, fileName);
    }

    public static void save(Tree t2, @Nullable List<String> ruleNames, String fileName, String fontName, int fontSize) throws IOException {
        Trees.writePS(t2, ruleNames, fileName, fontName, fontSize);
    }

    public static String getPS(Tree t2, @Nullable List<String> ruleNames, String fontName, int fontSize) {
        TreePostScriptGenerator psgen = new TreePostScriptGenerator(ruleNames, t2, fontName, fontSize);
        return psgen.getPS();
    }

    public static String getPS(Tree t2, @Nullable List<String> ruleNames) {
        return Trees.getPS(t2, ruleNames, "Helvetica", 11);
    }

    public static void writePS(Tree t2, @Nullable List<String> ruleNames, String fileName, String fontName, int fontSize) throws IOException {
        String ps = Trees.getPS(t2, ruleNames, fontName, fontSize);
        FileWriter f = new FileWriter(fileName);
        try (BufferedWriter bw = new BufferedWriter(f);){
            bw.write(ps);
        }
    }

    public static void writePS(Tree t2, @Nullable List<String> ruleNames, String fileName) throws IOException {
        Trees.writePS(t2, ruleNames, fileName, "Helvetica", 11);
    }

    public static String toStringTree(@Nullable Tree t2, @NotNull TreeTextProvider nodeTextProvider) {
        if (t2 == null) {
            return "null";
        }
        String s2 = Utils.escapeWhitespace(nodeTextProvider.getText(t2), false);
        if (t2.getChildCount() == 0) {
            return s2;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        s2 = Utils.escapeWhitespace(nodeTextProvider.getText(t2), false);
        buf.append(s2);
        buf.append(' ');
        for (int i = 0; i < t2.getChildCount(); ++i) {
            if (i > 0) {
                buf.append(' ');
            }
            buf.append(Trees.toStringTree(t2.getChild(i), nodeTextProvider));
        }
        buf.append(")");
        return buf.toString();
    }

    private Trees() {
    }
}

