/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.Platform;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.EagerLetExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.PositionVariable;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.Tokenizer;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.functions.Concat;
import net.sf.saxon.functions.ConstructorFunctionLibrary;
import net.sf.saxon.functions.ExecutableFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.StringJoin;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.SystemFunctionLibrary;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.Choose;
import net.sf.saxon.instruct.Comment;
import net.sf.saxon.instruct.ComputedAttribute;
import net.sf.saxon.instruct.ComputedElement;
import net.sf.saxon.instruct.CopyOf;
import net.sf.saxon.instruct.DocumentInstr;
import net.sf.saxon.instruct.ElementCreator;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.FixedAttribute;
import net.sf.saxon.instruct.FixedElement;
import net.sf.saxon.instruct.LocationMap;
import net.sf.saxon.instruct.ProcessingInstruction;
import net.sf.saxon.instruct.QuerySimpleContentConstructor;
import net.sf.saxon.instruct.ResultDocument;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.TraceExpression;
import net.sf.saxon.instruct.UserFunctionParameter;
import net.sf.saxon.instruct.ValueOf;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceConstant;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.query.GlobalVariableDefinition;
import net.sf.saxon.query.ModuleURIResolver;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.QueryReader;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.sort.TupleExpression;
import net.sf.saxon.sort.TupleSorter;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

class QueryParser
extends ExpressionParser {
    private boolean memoFunction = false;
    private boolean disableCycleChecks = false;
    private int errorCount = 0;
    private XPathException firstError = null;
    protected Executable executable;
    private boolean foundCopyNamespaces = false;
    private boolean foundBoundarySpaceDeclaration = false;
    private boolean foundOrderingDeclaration = false;
    private boolean foundEmptyOrderingDeclaration = false;
    private boolean foundDefaultCollation = false;
    private boolean foundConstructionDeclaration = false;
    private boolean foundDefaultFunctionNamespace = false;
    private boolean foundDefaultElementNamespace = false;
    private boolean foundBaseURIDeclaration = false;
    private boolean preambleProcessed = false;
    public Set importedModules = new HashSet(5);
    List namespacesToBeSealed = new ArrayList(10);
    List schemaImports = new ArrayList(5);
    List moduleImports = new ArrayList(5);
    private Expression defaultValue = null;
    private static Pattern encNamePattern = Pattern.compile("^[A-Za-z]([A-Za-z0-9._\\x2D])*$");

    protected QueryParser() {
    }

    public XQueryExpression makeXQueryExpression(String query, QueryModule staticContext, Configuration config) throws XPathException {
        try {
            query = config.getXMLVersion() == 10 ? QueryParser.normalizeLineEndings10(query) : QueryParser.normalizeLineEndings11(query);
            Executable exec = staticContext.getExecutable();
            if (exec == null) {
                exec = new Executable(config);
                exec.setHostLanguage(51);
                staticContext.setExecutable(exec);
            }
            Properties outputProps = new Properties();
            outputProps.setProperty("method", "xml");
            outputProps.setProperty("indent", "yes");
            exec.setDefaultOutputProperties(outputProps);
            exec.setLocationMap(new LocationMap());
            exec.setFunctionLibrary(new ExecutableFunctionLibrary(config));
            this.setExecutable(exec);
            Expression exp = this.parseQuery(query, 0, 0, staticContext);
            int loc = this.env.getLocationMap().allocateLocationId(this.env.getSystemId(), 1);
            exp.setContainer(new ExpressionParser.TemporaryContainer(staticContext.getLocationMap(), loc));
            exec.fixupQueryModules(staticContext);
            if (!this.disableCycleChecks) {
                Iterator miter = exec.getQueryLibraryModules();
                while (miter.hasNext()) {
                    QueryModule module = (QueryModule)miter.next();
                    module.lookForModuleCycles(new Stack(), 1);
                }
            }
            XQueryExpression queryExp = new XQueryExpression(exp, exec, staticContext, config);
            FunctionLibrary userlib = exec.getFunctionLibrary();
            FunctionLibraryList lib = new FunctionLibraryList();
            lib.addFunctionLibrary(SystemFunctionLibrary.getSystemFunctionLibrary(0));
            lib.addFunctionLibrary(config.getVendorFunctionLibrary());
            lib.addFunctionLibrary(new ConstructorFunctionLibrary(config));
            if (config.isAllowExternalFunctions()) {
                Configuration.getPlatform().addFunctionLibraries(lib, config);
            }
            lib.addFunctionLibrary(userlib);
            exec.setFunctionLibrary(lib);
            return queryExp;
        }
        catch (XPathException e) {
            if (!e.hasBeenReported()) {
                this.reportError(e);
            }
            throw e;
        }
    }

    private static String normalizeLineEndings11(String in) {
        if (in.indexOf(10) < 0 && in.indexOf(133) < 0 && in.indexOf(8232) < 0) {
            return in;
        }
        FastStringBuffer sb = new FastStringBuffer(in.length());
        block4: for (int i = 0; i < in.length(); ++i) {
            char ch = in.charAt(i);
            switch (ch) {
                case '\u0085': 
                case '\u2028': {
                    sb.append('\n');
                    continue block4;
                }
                case '\r': {
                    if (i < in.length() - 1 && (in.charAt(i + 1) == '\n' || in.charAt(i + 1) == '\u0085')) {
                        sb.append('\n');
                        ++i;
                        continue block4;
                    }
                    sb.append('\n');
                    continue block4;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private static String normalizeLineEndings10(String in) {
        if (in.indexOf(10) < 0) {
            return in;
        }
        FastStringBuffer sb = new FastStringBuffer(in.length());
        block3: for (int i = 0; i < in.length(); ++i) {
            char ch = in.charAt(i);
            switch (ch) {
                case '\r': {
                    if (i < in.length() - 1 && in.charAt(i + 1) == '\n') {
                        sb.append('\n');
                        ++i;
                        continue block3;
                    }
                    sb.append('\n');
                    continue block3;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable exec) {
        this.executable = exec;
    }

    public void setDisableCycleChecks(boolean disable) {
        this.disableCycleChecks = disable;
    }

    private Expression parseQuery(String queryString, int start, int terminator, QueryModule env) throws XPathException {
        this.env = env;
        this.nameChecker = env.getConfiguration().getNameChecker();
        this.language = 3;
        this.t = new Tokenizer();
        try {
            this.t.tokenize(queryString, start, -1, 1);
        }
        catch (XPathException err) {
            this.grumble(err.getMessage());
        }
        this.parseVersionDeclaration();
        this.parseProlog();
        this.processPreamble();
        Expression exp = this.parseExpression();
        if (this.t.currentToken != terminator) {
            this.grumble("Unexpected token " + this.currentTokenDisplay() + " beyond end of query");
        }
        this.setLocation(exp);
        if (this.errorCount == 0) {
            return exp;
        }
        XPathException err = new XPathException("One or more static errors were reported during query analysis");
        err.setHasBeenReported();
        err.setErrorCode(this.firstError.getErrorCodeLocalPart());
        throw err;
    }

    public final void parseLibraryModule(String queryString, QueryModule env) throws XPathException {
        this.env = env;
        this.nameChecker = env.getConfiguration().getNameChecker();
        this.executable = env.getExecutable();
        this.t = new Tokenizer();
        try {
            this.t.tokenize(queryString, 0, -1, 1);
        }
        catch (XPathException err) {
            this.grumble(err.getMessage());
        }
        this.parseVersionDeclaration();
        this.parseModuleDeclaration();
        this.parseProlog();
        this.processPreamble();
        if (this.t.currentToken != 0) {
            this.grumble("Unrecognized content found after the variable and function declarations in a library module");
        }
        if (this.errorCount != 0) {
            err = new XPathException("Static errors were reported in the imported library module");
            err.setErrorCode(this.firstError.getErrorCodeLocalPart());
            throw err;
        }
    }

    protected void grumble(String message, String errorCode) throws XPathException {
        String s2 = this.t.recentText();
        ExpressionLocation loc = this.makeLocator();
        String prefix = this.getLanguage() + ("XPST0003".equals(errorCode) ? " syntax error " : " static error ") + (message.startsWith("...") ? "near" : "in") + " #" + s2 + "#:\n    ";
        XPathException exception = new XPathException(prefix + message);
        exception.setErrorCode(errorCode);
        exception.setLocator(loc);
        this.reportError(exception);
    }

    private void reportError(XPathException exception) throws XPathException {
        ++this.errorCount;
        if (this.firstError == null) {
            this.firstError = exception;
        }
        ((QueryModule)this.env).reportFatalError(exception);
        throw exception;
    }

    private ExpressionLocation makeLocator() {
        int line = this.t.getLineNumber();
        int column = this.t.getColumnNumber();
        ExpressionLocation loc = new ExpressionLocation();
        loc.setSystemId(this.env.getSystemId());
        loc.setLineNumber(line);
        loc.setColumnNumber(column);
        return loc;
    }

    private void parseVersionDeclaration() throws XPathException {
        if (this.t.currentToken == 70) {
            this.nextToken();
            this.expect(102);
            if (!"1.0".equals(this.t.currentTokenValue)) {
                this.grumble("XQuery version must be 1.0", "XQST0031");
            }
            this.nextToken();
            if ("encoding".equals(this.t.currentTokenValue)) {
                this.nextToken();
                this.expect(102);
                if (!encNamePattern.matcher(this.t.currentTokenValue).matches()) {
                    this.grumble("Encoding name contains invalid characters", "XQST0087");
                }
                this.nextToken();
            }
            this.expect(90);
            this.nextToken();
        }
    }

    private void parseModuleDeclaration() throws XPathException {
        this.expect(80);
        this.nextToken();
        this.expect(101);
        String prefix = this.t.currentTokenValue;
        this.nextToken();
        this.expect(6);
        this.nextToken();
        this.expect(102);
        String uri = this.URILiteral(this.t.currentTokenValue);
        this.checkProhibitedPrefixes(prefix, uri);
        if (uri.length() == 0) {
            this.grumble("Module namespace cannot be \"\"", "XQST0088");
            uri = "http://saxon.fallback.namespace/";
        }
        this.nextToken();
        this.expect(90);
        this.nextToken();
        try {
            ((QueryModule)this.env).declarePrologNamespace(prefix, uri);
        }
        catch (XPathException err) {
            err.setLocator(this.makeLocator());
            this.reportError(err);
        }
        ((QueryModule)this.env).setModuleNamespace(uri);
    }

    private void parseProlog() throws XPathException {
        boolean allowModuleDecl = true;
        boolean allowDeclarations = true;
        while (true) {
            try {
                while (true) {
                    if (this.t.currentToken == 80) {
                        String uri = ((QueryModule)this.env).getModuleNamespace();
                        if (uri == null) {
                            this.grumble("Module declaration must not be used in a main module");
                        } else {
                            this.grumble("Module declaration appears more than once");
                        }
                        if (!allowModuleDecl) {
                            this.grumble("Module declaration must precede other declarations in the query prolog");
                        }
                    }
                    allowModuleDecl = false;
                    switch (this.t.currentToken) {
                        case 71: {
                            if (!allowDeclarations) {
                                this.grumble("Namespace declarations cannot follow variables, functions, or options");
                            }
                            this.parseNamespaceDeclaration();
                            break;
                        }
                        case 72: {
                            this.nextToken();
                            this.expect(101);
                            if (this.t.currentTokenValue.equals("element")) {
                                if (!allowDeclarations) {
                                    this.grumble("Namespace declarations cannot follow variables, functions, or options");
                                }
                                this.parseDefaultElementNamespace();
                                break;
                            }
                            if (this.t.currentTokenValue.equals("function")) {
                                if (!allowDeclarations) {
                                    this.grumble("Namespace declarations cannot follow variables, functions, or options");
                                }
                                this.parseDefaultFunctionNamespace();
                                break;
                            }
                            if (this.t.currentTokenValue.equals("collation")) {
                                if (!allowDeclarations) {
                                    this.grumble("Collation declarations must appear earlier in the prolog");
                                }
                                this.parseDefaultCollation();
                                break;
                            }
                            if (this.t.currentTokenValue.equals("order")) {
                                if (!allowDeclarations) {
                                    this.grumble("Order declarations must appear earlier in the prolog");
                                }
                                this.parseDefaultOrder();
                                break;
                            }
                            this.grumble("After 'declare default', expected 'element', 'function', or 'collation'");
                            break;
                        }
                        case 75: {
                            if (!allowDeclarations) {
                                this.grumble("'declare boundary-space' must appear earlier in the query prolog");
                            }
                            this.parseBoundarySpaceDeclaration();
                            break;
                        }
                        case 84: {
                            if (!allowDeclarations) {
                                this.grumble("'declare ordering' must appear earlier in the query prolog");
                            }
                            this.parseOrderingDeclaration();
                            break;
                        }
                        case 85: {
                            if (!allowDeclarations) {
                                this.grumble("'declare copy-namespaces' must appear earlier in the query prolog");
                            }
                            this.parseCopyNamespacesDeclaration();
                            break;
                        }
                        case 74: {
                            if (!allowDeclarations) {
                                this.grumble("'declare base-uri' must appear earlier in the query prolog");
                            }
                            this.parseBaseURIDeclaration();
                            break;
                        }
                        case 76: {
                            if (!allowDeclarations) {
                                this.grumble("Import schema must appear earlier in the prolog");
                            }
                            this.parseSchemaImport();
                            break;
                        }
                        case 77: {
                            if (!allowDeclarations) {
                                this.grumble("Import module must appear earlier in the prolog");
                            }
                            this.parseModuleImport();
                            break;
                        }
                        case 78: {
                            if (allowDeclarations) {
                                this.sealNamespaces(this.namespacesToBeSealed, this.env.getConfiguration());
                                allowDeclarations = false;
                            }
                            this.processPreamble();
                            this.parseVariableDeclaration();
                            break;
                        }
                        case 79: {
                            if (allowDeclarations) {
                                this.sealNamespaces(this.namespacesToBeSealed, this.env.getConfiguration());
                                allowDeclarations = false;
                            }
                            this.processPreamble();
                            this.parseFunctionDeclaration();
                            break;
                        }
                        case 86: {
                            if (allowDeclarations) {
                                this.sealNamespaces(this.namespacesToBeSealed, this.env.getConfiguration());
                                allowDeclarations = false;
                            }
                            this.parseOptionDeclaration();
                            break;
                        }
                        case 73: {
                            if (!allowDeclarations) {
                                this.grumble("'declare construction' must appear earlier in the query prolog");
                            }
                            this.parseConstructionDeclaration();
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    this.expect(90);
                    this.nextToken();
                }
            }
            catch (XPathException err) {
                if (err.getLocator() == null) {
                    err.setLocator(this.makeLocator());
                }
                if (!err.hasBeenReported()) {
                    ++this.errorCount;
                    if (this.firstError == null) {
                        this.firstError = err;
                    }
                    ((QueryModule)this.env).reportFatalError(err);
                }
                while (this.t.currentToken != 90) {
                    this.nextToken();
                    if (this.t.currentToken == 0) {
                        return;
                    }
                    if (this.t.currentToken == 115) {
                        this.t.lookAhead();
                        continue;
                    }
                    if (this.t.currentToken != 117) continue;
                    this.parsePseudoXML(true);
                }
                this.nextToken();
                continue;
            }
            break;
        }
    }

    private void sealNamespaces(List namespacesToBeSealed, Configuration config) {
        for (String ns : namespacesToBeSealed) {
            config.sealNamespace(ns);
        }
    }

    private void processPreamble() throws XPathException {
        if (this.preambleProcessed) {
            return;
        }
        this.preambleProcessed = true;
        if (this.foundDefaultCollation) {
            String collationName = this.env.getDefaultCollationName();
            try {
                URI collationURI = new URI(collationName);
                if (!collationURI.isAbsolute()) {
                    URI base = new URI(this.env.getBaseURI());
                    collationURI = base.resolve(collationURI);
                    collationName = collationURI.toString();
                }
            }
            catch (URISyntaxException err) {
                this.grumble("Default collation name '" + collationName + "' is not a valid URI");
                collationName = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
            }
            if (this.env.getCollation(collationName) == null) {
                this.grumble("Default collation name '" + collationName + "' is not a recognized collation", "XQST0038");
                collationName = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
            }
            ((QueryModule)this.env).setDefaultCollationName(collationName);
        }
        for (Import imp : this.schemaImports) {
            this.applySchemaImport(imp);
        }
        for (Import imp : this.moduleImports) {
            QueryModule parent;
            if (!(this.disableCycleChecks || imp.namespaceURI.equals(((QueryModule)this.env).getModuleNamespace()) || (parent = (QueryModule)this.env).mayImportModule(imp.namespaceURI))) {
                XPathException err = new XPathException("A module cannot import itself directly or indirectly, unless all modules in the cycle are in the same namespace");
                err.setErrorCode("XQST0073");
                err.setIsStaticError(true);
                throw err;
            }
            this.applyModuleImport(imp);
        }
    }

    private void parseDefaultCollation() throws XPathException {
        if (this.foundDefaultCollation) {
            this.grumble("default collation appears more than once", "XQST0038");
        }
        this.foundDefaultCollation = true;
        this.nextToken();
        this.expect(102);
        String uri = this.URILiteral(this.t.currentTokenValue);
        ((QueryModule)this.env).setDefaultCollationName(uri);
        this.nextToken();
    }

    private void parseDefaultOrder() throws XPathException {
        if (this.foundEmptyOrderingDeclaration) {
            this.grumble("empty ordering declaration appears more than once", "XQST0069");
        }
        this.foundEmptyOrderingDeclaration = true;
        this.nextToken();
        if (!this.isKeyword("empty")) {
            this.grumble("After 'declare default order', expected keyword 'empty'");
        }
        this.nextToken();
        if (this.isKeyword("least")) {
            ((QueryModule)this.env).setEmptyLeast(true);
        } else if (this.isKeyword("greatest")) {
            ((QueryModule)this.env).setEmptyLeast(false);
        } else {
            this.grumble("After 'declare default order empty', expected keyword 'least' or 'greatest'");
        }
        this.nextToken();
    }

    private void parseBoundarySpaceDeclaration() throws XPathException {
        if (this.foundBoundarySpaceDeclaration) {
            this.grumble("'declare boundary-space' appears more than once", "XQST0068");
        }
        this.foundBoundarySpaceDeclaration = true;
        this.nextToken();
        this.expect(101);
        if ("preserve".equals(this.t.currentTokenValue)) {
            ((QueryModule)this.env).setPreserveBoundarySpace(true);
        } else if ("strip".equals(this.t.currentTokenValue)) {
            ((QueryModule)this.env).setPreserveBoundarySpace(false);
        } else {
            this.grumble("boundary-space must be 'preserve' or 'strip'");
        }
        this.nextToken();
    }

    private void parseOrderingDeclaration() throws XPathException {
        if (this.foundOrderingDeclaration) {
            this.grumble("ordering mode declaration appears more than once", "XQST0065");
        }
        this.foundOrderingDeclaration = true;
        this.nextToken();
        this.expect(101);
        if (!"ordered".equals(this.t.currentTokenValue) && !"unordered".equals(this.t.currentTokenValue)) {
            this.grumble("ordering mode must be 'ordered' or 'unordered'");
        }
        this.nextToken();
    }

    private void parseCopyNamespacesDeclaration() throws XPathException {
        if (this.foundCopyNamespaces) {
            this.grumble("declare inherit-namespaces appears more than once", "XQST0055");
        }
        this.foundCopyNamespaces = true;
        this.nextToken();
        this.expect(101);
        if ("preserve".equals(this.t.currentTokenValue)) {
            ((QueryModule)this.env).setPreserveNamespaces(true);
        } else if ("no-preserve".equals(this.t.currentTokenValue)) {
            ((QueryModule)this.env).setPreserveNamespaces(false);
        } else {
            this.grumble("copy-namespaces must be followed by 'preserve' or 'no-preserve'");
        }
        this.nextToken();
        this.expect(7);
        this.nextToken();
        this.expect(101);
        if ("inherit".equals(this.t.currentTokenValue)) {
            ((QueryModule)this.env).setInheritNamespaces(true);
        } else if ("no-inherit".equals(this.t.currentTokenValue)) {
            ((QueryModule)this.env).setInheritNamespaces(false);
        } else {
            this.grumble("After the comma in the copy-namespaces declaration, expected 'inherit' or 'no-inherit'");
        }
        this.nextToken();
    }

    private void parseConstructionDeclaration() throws XPathException {
        int val;
        if (this.foundConstructionDeclaration) {
            this.grumble("declare construction appears more than once", "XQST0067");
        }
        this.foundConstructionDeclaration = true;
        this.nextToken();
        this.expect(101);
        if ("preserve".equals(this.t.currentTokenValue)) {
            val = 3;
        } else if ("strip".equals(this.t.currentTokenValue)) {
            val = 4;
        } else {
            this.grumble("construction mode must be 'preserve' or 'strip'");
            val = 4;
        }
        ((QueryModule)this.env).setConstructionMode(val);
        this.nextToken();
    }

    private void parseSchemaImport() throws XPathException {
        if (!this.env.getConfiguration().isSchemaAware(51)) {
            this.grumble("To import a schema, you need the schema-aware version of Saxon", "XQST0009");
        }
        Import sImport = new Import();
        String prefix = null;
        sImport.namespaceURI = null;
        sImport.locationURIs = new ArrayList(5);
        this.nextToken();
        if (this.isKeyword("namespace")) {
            this.t.setState(0);
            this.nextToken();
            this.expect(101);
            prefix = this.t.currentTokenValue;
            this.nextToken();
            this.expect(6);
            this.nextToken();
        } else if (this.isKeyword("default")) {
            this.nextToken();
            if (!this.isKeyword("element")) {
                this.grumble("In 'import schema', expected 'element namespace'");
            }
            this.nextToken();
            if (!this.isKeyword("namespace")) {
                this.grumble("In 'import schema', expected keyword 'namespace'");
            }
            this.nextToken();
            prefix = "";
        }
        if (this.t.currentToken == 102) {
            String uri = this.URILiteral(this.t.currentTokenValue);
            this.checkProhibitedPrefixes(prefix, uri);
            sImport.namespaceURI = uri;
            this.nextToken();
            if (this.isKeyword("at")) {
                this.nextToken();
                this.expect(102);
                sImport.locationURIs.add(this.URILiteral(this.t.currentTokenValue));
                this.nextToken();
                while (this.t.currentToken == 7) {
                    this.nextToken();
                    this.expect(102);
                    sImport.locationURIs.add(this.URILiteral(this.t.currentTokenValue));
                    this.nextToken();
                }
            } else if (this.t.currentToken != 90) {
                this.grumble("After the target namespace URI, expected 'at' or ';'");
            }
        } else {
            this.grumble("After 'import schema', expected 'namespace', 'default', or a string-literal");
        }
        if (prefix != null) {
            try {
                if (prefix.length() == 0) {
                    ((QueryModule)this.env).setDefaultElementNamespace(sImport.namespaceURI);
                } else {
                    if (sImport.namespaceURI == null || "".equals(sImport.namespaceURI)) {
                        this.grumble("A prefix cannot be bound to the null namespace", "XQST0057");
                    }
                    ((QueryModule)this.env).declarePrologNamespace(prefix, sImport.namespaceURI);
                }
            }
            catch (XPathException err) {
                err.setLocator(this.makeLocator());
                this.reportError(err);
            }
        }
        for (Import imp : this.schemaImports) {
            if (!imp.namespaceURI.equals(sImport.namespaceURI)) continue;
            this.grumble("Schema namespace '" + sImport.namespaceURI + "' is imported more than once", "XQST0058");
            break;
        }
        this.schemaImports.add(sImport);
    }

    private void applySchemaImport(Import sImport) throws XPathException {
        Configuration config = this.env.getConfiguration();
        if (!config.isSchemaAvailable(sImport.namespaceURI)) {
            if (!sImport.locationURIs.isEmpty()) {
                try {
                    PipelineConfiguration pipe = config.makePipelineConfiguration();
                    config.readMultipleSchemas(pipe, this.env.getBaseURI(), sImport.locationURIs, sImport.namespaceURI);
                    this.namespacesToBeSealed.add(sImport.namespaceURI);
                }
                catch (TransformerConfigurationException err) {
                    this.grumble("Error in schema. " + err.getMessage(), "XQST0059");
                }
            } else {
                this.grumble("Unable to locate requested schema", "XQST0059");
            }
        }
        ((QueryModule)this.env).addImportedSchema(sImport.namespaceURI);
    }

    private void parseModuleImport() throws XPathException {
        QueryModule thisModule = (QueryModule)this.env;
        Import mImport = new Import();
        String prefix = null;
        mImport.namespaceURI = null;
        mImport.locationURIs = new ArrayList(5);
        this.nextToken();
        if (this.t.currentToken == 101 && this.t.currentTokenValue.equals("namespace")) {
            this.t.setState(0);
            this.nextToken();
            this.expect(101);
            prefix = this.t.currentTokenValue;
            this.nextToken();
            this.expect(6);
            this.nextToken();
        }
        if (this.t.currentToken == 102) {
            String uri = this.URILiteral(this.t.currentTokenValue);
            this.checkProhibitedPrefixes(prefix, uri);
            mImport.namespaceURI = uri;
            if (mImport.namespaceURI.length() == 0) {
                this.grumble("Imported module namespace cannot be \"\"", "XQST0088");
                mImport.namespaceURI = "http://saxon.fallback.namespace/line" + this.t.getLineNumber();
            }
            if (this.importedModules.contains(mImport.namespaceURI)) {
                this.grumble("Two 'import module' declarations specify the same module namespace", "XQST0047");
            }
            this.importedModules.add(mImport.namespaceURI);
            ((QueryModule)this.env).addImportedNamespace(mImport.namespaceURI);
            this.nextToken();
            if (this.isKeyword("at")) {
                do {
                    this.nextToken();
                    this.expect(102);
                    mImport.locationURIs.add(this.URILiteral(this.t.currentTokenValue));
                    this.nextToken();
                } while (this.t.currentToken == 7);
            }
        } else {
            this.grumble("After 'import module', expected 'namespace' or a string-literal");
        }
        if (prefix != null) {
            try {
                thisModule.declarePrologNamespace(prefix, mImport.namespaceURI);
            }
            catch (XPathException err) {
                err.setLocator(this.makeLocator());
                this.reportError(err);
            }
        }
        this.moduleImports.add(mImport);
    }

    public void applyModuleImport(Import mImport) throws XPathException {
        int h2;
        boolean foundOne = false;
        Platform platform = Configuration.getPlatform();
        for (int i = 0; i < mImport.locationURIs.size(); ++i) {
            try {
                String uri = (String)mImport.locationURIs.get(i);
                URI abs = platform.makeAbsolute(uri, this.env.getBaseURI());
                mImport.locationURIs.set(i, abs);
                continue;
            }
            catch (URISyntaxException e) {
                this.grumble("Invalid URI " + mImport.locationURIs.get(i) + ": " + e.getMessage());
            }
        }
        List existingModules = this.executable.getQueryLibraryModules(mImport.namespaceURI);
        if (existingModules != null) {
            for (int m4 = 0; m4 < existingModules.size(); ++m4) {
                QueryModule importedModule = (QueryModule)existingModules.get(m4);
                if (!importedModule.getLocationURI().equals(((QueryModule)this.env).getLocationURI())) {
                    foundOne = true;
                }
                if (!this.disableCycleChecks && ((QueryModule)this.env).getModuleNamespace() != null && !((QueryModule)this.env).getModuleNamespace().equals(importedModule.getModuleNamespace()) && importedModule.importsNamespaceIndirectly(((QueryModule)this.env).getModuleNamespace())) {
                    this.grumble("A cycle exists among the module imports, involving namespaces " + ((QueryModule)this.env).getModuleNamespace() + " and " + importedModule.getModuleNamespace());
                }
                for (h2 = mImport.locationURIs.size() - 1; h2 >= 0; --h2) {
                    if (!mImport.locationURIs.get(h2).equals(importedModule.getLocationURI())) continue;
                    mImport.locationURIs.remove(h2);
                }
            }
        }
        if (mImport.locationURIs.isEmpty() && foundOne) {
            return;
        }
        ModuleURIResolver resolver2 = ((QueryModule)this.env).getUserQueryContext().getModuleURIResolver();
        String[] hints = new String[mImport.locationURIs.size()];
        for (h2 = 0; h2 < hints.length; ++h2) {
            hints[h2] = mImport.locationURIs.get(h2).toString();
        }
        StreamSource[] sources = null;
        if (resolver2 != null) {
            sources = resolver2.resolve(mImport.namespaceURI, this.env.getBaseURI(), hints);
        }
        if (sources == null) {
            if (hints.length == 0 && existingModules == null) {
                this.grumble("Cannot locate module for namespace " + mImport.namespaceURI, "XQST0059");
            }
            resolver2 = this.env.getConfiguration().getStandardModuleURIResolver();
            sources = resolver2.resolve(mImport.namespaceURI, this.env.getBaseURI(), hints);
        }
        for (int m5 = 0; m5 < sources.length; ++m5) {
            StreamSource ss = sources[m5];
            String baseURI = ss.getSystemId();
            if (baseURI == null) {
                if (m5 < hints.length) {
                    ss.setSystemId(hints[m5]);
                    baseURI = hints[m5];
                } else {
                    this.grumble("No base URI available for imported module", "XQST0059");
                }
            }
            existingModules = this.executable.getQueryLibraryModules(mImport.namespaceURI);
            boolean loaded = false;
            if (existingModules != null && m5 < hints.length) {
                for (int e = 0; e < existingModules.size(); ++e) {
                    if (!((QueryModule)existingModules.get(e)).getLocationURI().equals(mImport.locationURIs.get(m5))) continue;
                    loaded = true;
                    break;
                }
            }
            if (loaded) break;
            try {
                String queryText = QueryReader.readSourceQuery(ss, this.nameChecker);
                try {
                    if (ss.getInputStream() != null) {
                        ss.getInputStream().close();
                    } else if (ss.getReader() != null) {
                        ss.getReader().close();
                    }
                }
                catch (IOException e) {
                    throw new XPathException("Failure while closing file for imported query module");
                }
                QueryModule.makeQueryModule(baseURI, this.executable, (QueryModule)this.env, queryText, mImport.namespaceURI, this.disableCycleChecks);
                continue;
            }
            catch (XPathException err) {
                err.maybeSetLocation(this.makeLocator());
                this.reportError(err);
            }
        }
    }

    private void parseBaseURIDeclaration() throws XPathException {
        if (this.foundBaseURIDeclaration) {
            this.grumble("Base URI Declaration may only appear once", "XQST0032");
        }
        this.foundBaseURIDeclaration = true;
        this.nextToken();
        this.expect(102);
        String uri = this.URILiteral(this.t.currentTokenValue);
        try {
            URI baseURI = new URI(uri);
            if (!baseURI.isAbsolute()) {
                String oldBase = this.env.getBaseURI();
                URI oldBaseURI = new URI(oldBase);
                uri = oldBaseURI.resolve(uri).toString();
            }
            ((QueryModule)this.env).setBaseURI(uri);
        }
        catch (URISyntaxException err) {
            ((QueryModule)this.env).setBaseURI(uri);
        }
        this.nextToken();
    }

    private void parseDefaultFunctionNamespace() throws XPathException {
        if (this.foundDefaultFunctionNamespace) {
            this.grumble("default function namespace appears more than once", "XQST0066");
        }
        this.foundDefaultFunctionNamespace = true;
        this.nextToken();
        this.expect(101);
        if (!"namespace".equals(this.t.currentTokenValue)) {
            this.grumble("After 'declare default function', expected 'namespace'");
        }
        this.nextToken();
        this.expect(102);
        String uri = this.URILiteral(this.t.currentTokenValue);
        ((QueryModule)this.env).setDefaultFunctionNamespace(uri);
        this.nextToken();
    }

    private void parseDefaultElementNamespace() throws XPathException {
        if (this.foundDefaultElementNamespace) {
            this.grumble("default element namespace appears more than once", "XQST0066");
        }
        this.foundDefaultElementNamespace = true;
        this.nextToken();
        this.expect(101);
        if (!"namespace".equals(this.t.currentTokenValue)) {
            this.grumble("After 'declare default element', expected 'namespace'");
        }
        this.nextToken();
        this.expect(102);
        String uri = this.URILiteral(this.t.currentTokenValue);
        ((QueryModule)this.env).setDefaultElementNamespace(uri);
        this.nextToken();
    }

    private void parseNamespaceDeclaration() throws XPathException {
        this.nextToken();
        this.expect(101);
        String prefix = this.t.currentTokenValue;
        if (!this.nameChecker.isValidNCName(prefix)) {
            this.grumble("Invalid namespace prefix " + Err.wrap(prefix));
        }
        this.nextToken();
        this.expect(6);
        this.nextToken();
        this.expect(102);
        String uri = this.URILiteral(this.t.currentTokenValue);
        this.checkProhibitedPrefixes(prefix, uri);
        try {
            ((QueryModule)this.env).declarePrologNamespace(prefix, uri);
        }
        catch (XPathException err) {
            err.setLocator(this.makeLocator());
            this.reportError(err);
        }
        this.nextToken();
    }

    private void checkProhibitedPrefixes(String prefix, String uri) throws XPathException {
        if (prefix == null) {
            prefix = "";
        }
        if (uri == null) {
            uri = "";
        }
        if ("xmlns".equals(prefix)) {
            this.grumble("The namespace prefix 'xmlns' cannot be redeclared", "XQST0070");
        }
        if (uri.equals("http://www.w3.org/2000/xmlns/")) {
            this.grumble("The xmlns namespace URI is reserved");
        }
        if (uri.equals("http://www.w3.org/XML/1998/namespace") && !prefix.equals("xml")) {
            this.grumble("The XML namespace cannot be bound to any prefix other than 'xml'");
        }
        if (prefix.equals("xml") && !uri.equals("http://www.w3.org/XML/1998/namespace")) {
            this.grumble("The prefix 'xml' cannot be bound to any namespace other than http://www.w3.org/XML/1998/namespace");
        }
    }

    private void parseVariableDeclaration() throws XPathException {
        int offset = this.t.currentTokenStartOffset;
        GlobalVariableDefinition var = new GlobalVariableDefinition();
        var.setLineNumber(this.t.getLineNumber());
        var.setSystemId(this.env.getSystemId());
        this.nextToken();
        this.expect(21);
        this.t.setState(1);
        this.nextToken();
        this.expect(101);
        String varName = this.t.currentTokenValue;
        StructuredQName varQName = this.makeStructuredQName(this.t.currentTokenValue, false);
        var.setVariableQName(varQName);
        String uri = varQName.getNamespaceURI();
        String moduleURI = ((QueryModule)this.env).getModuleNamespace();
        if (moduleURI != null && !moduleURI.equals(uri)) {
            this.grumble("A variable declared in a library module must be in the module namespace", "XQST0048");
        }
        this.nextToken();
        SequenceType requiredType = SequenceType.ANY_SEQUENCE;
        if (this.isKeyword("as")) {
            this.t.setState(2);
            this.nextToken();
            requiredType = this.parseSequenceType();
        }
        var.setRequiredType(requiredType);
        if (this.t.currentToken == 52) {
            this.t.setState(0);
            this.nextToken();
            Expression exp = this.parseExprSingle();
            var.setIsParameter(false);
            var.setValueExpression(this.makeTracer(offset, exp, 185, varQName));
        } else if (this.t.currentToken == 101) {
            if ("external".equals(this.t.currentTokenValue)) {
                var.setIsParameter(true);
                if (this.defaultValue != null) {
                    var.setValueExpression(this.defaultValue);
                }
                this.nextToken();
            } else {
                this.grumble("Variable must either be initialized or be declared as external");
            }
        } else {
            this.grumble("Expected ':=' or 'external' in variable declaration");
        }
        QueryModule qenv = (QueryModule)this.env;
        if (qenv.getModuleNamespace() != null && !uri.equals(qenv.getModuleNamespace())) {
            this.grumble("Variable " + Err.wrap(varName, 5) + " is not defined in the module namespace");
        }
        try {
            qenv.declareVariable(var);
        }
        catch (XPathException e) {
            this.grumble(e.getMessage(), e.getErrorCodeLocalPart());
        }
    }

    private void parseFunctionDeclaration() throws XPathException {
        String moduleURI;
        StructuredQName qName;
        String uri;
        int offset = this.t.currentTokenStartOffset;
        this.nextToken();
        this.expect(34);
        if (this.t.currentTokenValue.indexOf(58) < 0) {
            uri = this.env.getDefaultFunctionNamespace();
            qName = new StructuredQName("", uri, this.t.currentTokenValue);
        } else {
            qName = this.makeStructuredQName(this.t.currentTokenValue, false);
            uri = qName.getNamespaceURI();
        }
        if (uri.length() == 0) {
            this.grumble("The function must be in a namespace", "XQST0060");
        }
        if ((moduleURI = ((QueryModule)this.env).getModuleNamespace()) != null && !moduleURI.equals(uri)) {
            this.grumble("A function in a library module must be in the module namespace", "XQST0048");
        }
        if (NamespaceConstant.isReservedInQuery(uri)) {
            this.grumble("The function name " + this.t.currentTokenValue + " is in a reserved namespace", "XQST0045");
        }
        XQueryFunction func = new XQueryFunction();
        func.setFunctionName(qName);
        func.setResultType(SequenceType.ANY_SEQUENCE);
        func.setBody(null);
        func.setLineNumber(this.t.getLineNumber(offset));
        func.setColumnNumber(this.t.getColumnNumber(offset));
        func.setSystemId(this.env.getSystemId());
        func.setStaticContext(this.env);
        func.setMemoFunction(this.memoFunction);
        func.setExecutable(this.getExecutable());
        this.nextToken();
        HashSet<StructuredQName> paramNames = new HashSet<StructuredQName>(8);
        while (this.t.currentToken != 104) {
            this.expect(21);
            this.nextToken();
            this.expect(101);
            String argName = this.t.currentTokenValue;
            StructuredQName argQName = this.makeStructuredQName(argName, false);
            if (paramNames.contains(argQName)) {
                this.grumble("Duplicate parameter name " + Err.wrap(this.t.currentTokenValue, 5), "XQST0039");
            }
            paramNames.add(argQName);
            SequenceType paramType = SequenceType.ANY_SEQUENCE;
            this.nextToken();
            if (this.t.currentToken == 101 && "as".equals(this.t.currentTokenValue)) {
                this.nextToken();
                paramType = this.parseSequenceType();
            }
            UserFunctionParameter arg = new UserFunctionParameter();
            arg.setRequiredType(paramType);
            arg.setVariableQName(argQName);
            func.addArgument(arg);
            this.declareRangeVariable(arg);
            if (this.t.currentToken == 104) break;
            if (this.t.currentToken == 7) {
                this.nextToken();
                continue;
            }
            this.grumble("Expected ',' or ')' after function argument, found '" + Token.tokens[this.t.currentToken] + '\'');
        }
        this.t.setState(1);
        this.nextToken();
        if (this.isKeyword("as")) {
            this.t.setState(2);
            this.nextToken();
            func.setResultType(this.parseSequenceType());
        }
        if (this.isKeyword("external")) {
            this.grumble("Saxon does not allow external functions to be declared");
        } else {
            this.expect(53);
            this.t.setState(0);
            this.nextToken();
            func.setBody(this.parseExpression());
            this.expect(115);
            this.lookAhead();
        }
        UserFunctionParameter[] params = func.getParameterDefinitions();
        for (int i = 0; i < params.length; ++i) {
            this.undeclareRangeVariable();
        }
        this.t.setState(0);
        this.nextToken();
        QueryModule qenv = (QueryModule)this.env;
        try {
            qenv.declareFunction(func);
        }
        catch (XPathException e) {
            this.grumble(e.getMessage(), e.getErrorCodeLocalPart());
        }
        this.memoFunction = false;
    }

    private void parseOptionDeclaration() throws XPathException {
        this.nextToken();
        this.expect(101);
        int varNameCode = this.makeNameCode(this.t.currentTokenValue, false);
        String uri = this.env.getNamePool().getURI(varNameCode);
        if (uri.length() == 0) {
            this.grumble("The QName identifying an option declaration must be prefixed", "XPST0081");
            return;
        }
        this.nextToken();
        this.expect(102);
        String value = this.URILiteral(this.t.currentTokenValue);
        if (uri.equals("http://saxon.sf.net/")) {
            String localName = this.env.getNamePool().getLocalName(varNameCode);
            if (localName.equals("output")) {
                this.setOutputProperty(value);
            } else if (localName.equals("default")) {
                this.defaultValue = this.setDefaultValue(value);
            } else if (localName.equals("memo-function")) {
                if (value.equals("true")) {
                    this.memoFunction = true;
                } else if (value.equals("false")) {
                    this.memoFunction = false;
                } else {
                    this.warning("Value of saxon:memo-function must be 'true' or 'false'");
                }
            } else if (localName.equals("allow-cycles")) {
                if (value.equals("true")) {
                    this.disableCycleChecks = true;
                } else if (value.equals("false")) {
                    this.disableCycleChecks = false;
                } else {
                    this.warning("Value of saxon:allow-cycles must be 'true' or 'false'");
                }
            } else {
                this.warning("Unknown Saxon option declaration: " + this.env.getNamePool().getDisplayName(varNameCode));
            }
        }
        this.nextToken();
    }

    private void setOutputProperty(String property) {
        int equals = property.indexOf("=");
        if (equals < 0) {
            this.badOutputProperty("no equals sign");
        } else if (equals == 0) {
            this.badOutputProperty("starts with '=");
        } else if (equals == property.length() - 1) {
            this.badOutputProperty("ends with '=");
        }
        String keyword = Whitespace.trim(property.substring(0, equals));
        String value = Whitespace.trim(property.substring(equals + 1));
        Properties props = this.getExecutable().getDefaultOutputProperties();
        try {
            int key = this.makeNameCode(keyword, false) & 0xFFFFF;
            String lname = this.env.getNamePool().getLocalName(key);
            String uri = this.env.getNamePool().getURI(key);
            ResultDocument.setSerializationProperty(props, uri, lname, value, this.env.getNamespaceResolver(), false, this.nameChecker);
        }
        catch (XPathException e) {
            this.badOutputProperty(e.getMessage());
        }
    }

    private void badOutputProperty(String s2) {
        try {
            this.warning("Invalid serialization property (" + s2 + ") - ignored");
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
    }

    public Expression setDefaultValue(String exp) {
        try {
            IndependentContext ic = new IndependentContext(this.env.getConfiguration());
            ic.setNamespaceResolver(this.env.getNamespaceResolver());
            Expression expr = ExpressionTool.make(exp, ic, 0, 0, 1, false);
            ItemType contextItemType = Type.ITEM_TYPE;
            ExpressionVisitor visitor = ExpressionVisitor.make(ic);
            expr = visitor.typeCheck(expr, contextItemType);
            expr = visitor.optimize(expr, contextItemType);
            SlotManager stackFrameMap = ic.getStackFrameMap();
            ExpressionTool.allocateSlots(expr, stackFrameMap.getNumberOfVariables(), stackFrameMap);
            return expr;
        }
        catch (XPathException e) {
            try {
                this.warning("Invalid expression for default value: " + e.getMessage() + " (ignored)");
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
            return null;
        }
    }

    protected Expression parseForExpression() throws XPathException {
        int i;
        int offset = this.t.currentTokenStartOffset;
        Expression whereCondition = null;
        int whereOffset = -1;
        ArrayList clauseList = new ArrayList(4);
        while (true) {
            if (this.t.currentToken == 111) {
                this.parseForClause(clauseList);
                continue;
            }
            if (this.t.currentToken != 116) break;
            this.parseLetClause(clauseList);
        }
        if (this.t.currentToken == 28 || this.isKeyword("where")) {
            whereOffset = this.t.currentTokenStartOffset;
            this.nextToken();
            whereCondition = this.parseExprSingle();
        }
        int orderByOffset = this.t.currentTokenStartOffset;
        if (this.isKeyword("stable")) {
            this.nextToken();
            if (!this.isKeyword("order")) {
                this.grumble("'stable' must be followed by 'order by'");
            }
        }
        List sortSpecList = null;
        if (this.isKeyword("order")) {
            this.t.setState(1);
            this.nextToken();
            if (!this.isKeyword("by")) {
                this.grumble("'order' must be followed by 'by'");
            }
            this.t.setState(0);
            this.nextToken();
            sortSpecList = this.parseSortDefinition();
        }
        int returnOffset = this.t.currentTokenStartOffset;
        this.expect(25);
        this.t.setState(0);
        this.nextToken();
        Expression action = this.parseExprSingle();
        action = this.makeTracer(returnOffset, action, 2014, null);
        if (sortSpecList != null) {
            TupleExpression exp = new TupleExpression(1 + sortSpecList.size());
            this.setLocation(exp);
            exp.setExpression(0, action);
            for (i = 0; i < sortSpecList.size(); ++i) {
                try {
                    RoleLocator role = new RoleLocator(6, "FLWR", i, null);
                    role.setSourceLocator(this.makeLocator());
                    Expression sk = TypeChecker.staticTypeCheck(((SortSpec)sortSpecList.get((int)i)).sortKey, SequenceType.OPTIONAL_ATOMIC, false, role, ExpressionVisitor.make(this.env));
                    exp.setExpression(i + 1, sk);
                    continue;
                }
                catch (XPathException err) {
                    this.grumble(err.getMessage());
                }
            }
            action = exp;
        }
        if (whereCondition != null) {
            action = Choose.makeConditional(whereCondition, action);
            action = this.makeTracer(whereOffset, action, 2018, null);
            this.setLocation(action);
        }
        for (int i2 = clauseList.size() - 1; i2 >= 0; --i2) {
            Assignation exp;
            Object clause = clauseList.get(i2);
            if (clause instanceof ExpressionParser.ForClause) {
                ExpressionParser.ForClause fc = (ExpressionParser.ForClause)clause;
                exp = (ForExpression)fc.rangeVariable;
                ((ForExpression)exp).setPositionVariable(fc.positionVariable);
                exp.setLocationId(this.env.getLocationMap().allocateLocationId(this.env.getSystemId(), this.t.getLineNumber(fc.offset)));
                exp.setSequence(fc.sequence);
                exp.setAction(action);
                action = this.makeTracer(fc.offset, exp, 2012, fc.rangeVariable.getVariableQName());
                continue;
            }
            LetClause lc = (LetClause)clause;
            exp = lc.variable;
            exp.setLocationId(this.env.getLocationMap().allocateLocationId(this.env.getSystemId(), this.t.getLineNumber(lc.offset)));
            exp.setAction(action);
            action = this.makeTracer(lc.offset, exp, 2013, lc.variable.getVariableQName());
        }
        if (sortSpecList != null) {
            SortKeyDefinition[] keys = new SortKeyDefinition[sortSpecList.size()];
            for (i = 0; i < keys.length; ++i) {
                SortSpec spec = (SortSpec)sortSpecList.get(i);
                SortKeyDefinition key = new SortKeyDefinition();
                key.setSortKey(((SortSpec)sortSpecList.get((int)i)).sortKey);
                key.setOrder(new StringLiteral(spec.ascending ? "ascending" : "descending"));
                key.setEmptyLeast(spec.emptyLeast);
                if (spec.collation != null) {
                    StringCollator comparator = this.env.getCollation(spec.collation);
                    if (comparator == null) {
                        this.grumble("Unknown collation '" + spec.collation + '\'', "XQST0076");
                    }
                    key.setCollation(comparator);
                }
                keys[i] = key;
            }
            TupleSorter sorter = new TupleSorter(action, keys);
            this.setLocation(sorter);
            action = this.makeTracer(orderByOffset, sorter, 2019, null);
        }
        for (int i3 = clauseList.size() - 1; i3 >= 0; --i3) {
            Object clause = clauseList.get(i3);
            if (clause instanceof ExpressionParser.ForClause && ((ExpressionParser.ForClause)clause).positionVariable != null) {
                this.undeclareRangeVariable();
            }
            this.undeclareRangeVariable();
        }
        this.setLocation(action, offset);
        return action;
    }

    private LetExpression makeLetExpression() {
        if (this.env.getConfiguration().isCompileWithTracing()) {
            return new EagerLetExpression();
        }
        return new LetExpression();
    }

    private void parseForClause(List clauseList) throws XPathException {
        boolean first = true;
        do {
            ExpressionParser.ForClause clause = new ExpressionParser.ForClause();
            if (first) {
                clause.offset = this.t.currentTokenStartOffset;
            }
            clauseList.add(clause);
            this.nextToken();
            if (first) {
                first = false;
            } else {
                clause.offset = this.t.currentTokenStartOffset;
            }
            this.expect(21);
            this.nextToken();
            this.expect(101);
            String var = this.t.currentTokenValue;
            ForExpression v = new ForExpression();
            StructuredQName varQName = this.makeStructuredQName(var, false);
            v.setVariableQName(varQName);
            v.setRequiredType(SequenceType.SINGLE_ITEM);
            clause.rangeVariable = v;
            this.nextToken();
            if (this.isKeyword("as")) {
                this.nextToken();
                SequenceType type = this.parseSequenceType();
                if (type.getCardinality() != 16384) {
                    this.warning("Occurrence indicator on singleton range variable has no effect");
                    type = SequenceType.makeSequenceType(type.getPrimaryType(), 16384);
                }
                v.setRequiredType(type);
            }
            clause.positionVariable = null;
            if (this.isKeyword("at")) {
                this.nextToken();
                this.expect(21);
                this.nextToken();
                this.expect(101);
                PositionVariable pos = new PositionVariable();
                StructuredQName posQName = this.makeStructuredQName(this.t.currentTokenValue, false);
                if (posQName.equals(varQName)) {
                    this.grumble("The two variables declared in a single 'for' clause must have different names", "XQST0089");
                }
                pos.setVariableQName(posQName);
                clause.positionVariable = pos;
                this.nextToken();
            }
            this.expect(30);
            this.nextToken();
            clause.sequence = this.parseExprSingle();
            this.declareRangeVariable(clause.rangeVariable);
            if (clause.positionVariable == null) continue;
            this.declareRangeVariable(clause.positionVariable);
        } while (this.t.currentToken == 7);
    }

    private void parseLetClause(List clauseList) throws XPathException {
        boolean first = true;
        do {
            LetClause clause = new LetClause();
            if (first) {
                clause.offset = this.t.currentTokenStartOffset;
            }
            clauseList.add(clause);
            this.nextToken();
            if (first) {
                first = false;
            } else {
                clause.offset = this.t.currentTokenStartOffset;
            }
            this.expect(21);
            this.nextToken();
            this.expect(101);
            String var = this.t.currentTokenValue;
            LetExpression v = new LetExpression();
            StructuredQName varQName = this.makeStructuredQName(var, false);
            v.setRequiredType(SequenceType.ANY_SEQUENCE);
            v.setVariableQName(varQName);
            clause.variable = v;
            this.nextToken();
            if (this.isKeyword("as")) {
                this.nextToken();
                v.setRequiredType(this.parseSequenceType());
            }
            this.expect(52);
            this.nextToken();
            v.setSequence(this.parseExprSingle());
            this.declareRangeVariable(v);
        } while (this.t.currentToken == 7);
    }

    public static Expression makeStringJoin(Expression exp, StaticContext env) {
        TypeHierarchy th;
        ItemType t2 = (exp = new Atomizer(exp, env.getConfiguration())).getItemType(th = env.getConfiguration().getTypeHierarchy());
        if (!t2.equals(BuiltInAtomicType.STRING) && !t2.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            exp = new AtomicSequenceConverter(exp, BuiltInAtomicType.STRING);
        }
        StringJoin fn = (StringJoin)SystemFunction.makeSystemFunction("string-join", new Expression[]{exp, new StringLiteral(StringValue.SINGLE_SPACE)});
        ExpressionTool.copyLocationInfo(exp, fn);
        return fn;
    }

    private List parseSortDefinition() throws XPathException {
        ArrayList<SortSpec> sortSpecList = new ArrayList<SortSpec>(5);
        while (true) {
            SortSpec sortSpec = new SortSpec();
            sortSpec.sortKey = this.parseExprSingle();
            sortSpec.ascending = true;
            sortSpec.emptyLeast = ((QueryModule)this.env).isEmptyLeast();
            sortSpec.collation = this.env.getDefaultCollationName();
            if (this.isKeyword("ascending")) {
                this.nextToken();
            } else if (this.isKeyword("descending")) {
                sortSpec.ascending = false;
                this.nextToken();
            }
            if (this.isKeyword("empty")) {
                this.nextToken();
                if (this.isKeyword("greatest")) {
                    sortSpec.emptyLeast = false;
                    this.nextToken();
                } else if (this.isKeyword("least")) {
                    sortSpec.emptyLeast = true;
                    this.nextToken();
                } else {
                    this.grumble("'empty' must be followed by 'greatest' or 'least'");
                }
            }
            if (this.isKeyword("collation")) {
                this.nextToken();
                this.expect(102);
                String collationName = this.URILiteral(this.t.currentTokenValue);
                try {
                    URI collationURI = new URI(collationName);
                    if (!collationURI.isAbsolute()) {
                        URI base = new URI(this.env.getBaseURI());
                        collationURI = base.resolve(collationURI);
                        collationName = collationURI.toString();
                    }
                }
                catch (URISyntaxException err) {
                    this.grumble("Collation name '" + collationName + "' is not a valid URI");
                    collationName = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
                }
                sortSpec.collation = collationName;
                this.nextToken();
            }
            sortSpecList.add(sortSpec);
            if (this.t.currentToken != 7) break;
            this.nextToken();
        }
        return sortSpecList;
    }

    protected Expression parseTypeswitchExpression() throws XPathException {
        Expression defaultAction;
        int offset = this.t.currentTokenStartOffset;
        this.nextToken();
        Expression operand = this.parseExpression();
        ArrayList<SequenceType> types = new ArrayList<SequenceType>(10);
        ArrayList<Expression> actions = new ArrayList<Expression>(10);
        this.expect(104);
        this.nextToken();
        LetExpression outerLet = this.makeLetExpression();
        outerLet.setRequiredType(SequenceType.ANY_SEQUENCE);
        outerLet.setVariableQName(new StructuredQName("zz", "http://saxon.sf.net/", "zz_typeswitchVar"));
        outerLet.setSequence(operand);
        while (this.t.currentToken == 59) {
            Expression action;
            SequenceType type;
            int caseOffset = this.t.currentTokenStartOffset;
            this.nextToken();
            if (this.t.currentToken == 21) {
                this.nextToken();
                this.expect(101);
                String var = this.t.currentTokenValue;
                StructuredQName varQName = this.makeStructuredQName(var, false);
                this.nextToken();
                this.expect(101);
                if (!"as".equals(this.t.currentTokenValue)) {
                    this.grumble("After 'case $" + var + "', expected 'as'");
                }
                this.nextToken();
                type = this.parseSequenceType();
                action = this.makeTracer(caseOffset, this.parseTypeswitchReturnClause(varQName, outerLet), 2021, varQName);
                if (action instanceof TraceExpression) {
                    ((TraceExpression)action).setProperty("type", type.toString());
                }
            } else {
                type = this.parseSequenceType();
                this.t.treatCurrentAsOperator();
                this.expect(25);
                this.nextToken();
                action = this.makeTracer(caseOffset, this.parseExprSingle(), 2021, null);
                if (action instanceof TraceExpression) {
                    ((TraceExpression)action).setProperty("type", type.toString());
                }
            }
            types.add(type);
            actions.add(action);
        }
        if (types.isEmpty()) {
            this.grumble("At least one case clause is required in a typeswitch");
        }
        this.expect(112);
        int defaultOffset = this.t.currentTokenStartOffset;
        this.nextToken();
        if (this.t.currentToken == 21) {
            this.nextToken();
            this.expect(101);
            String var = this.t.currentTokenValue;
            StructuredQName varQName = this.makeStructuredQName(var, false);
            this.nextToken();
            defaultAction = this.makeTracer(defaultOffset, this.parseTypeswitchReturnClause(varQName, outerLet), 2022, varQName);
        } else {
            this.t.treatCurrentAsOperator();
            this.expect(25);
            this.nextToken();
            defaultAction = this.makeTracer(defaultOffset, this.parseExprSingle(), 2022, null);
        }
        Expression lastAction = defaultAction;
        for (int i = types.size() - 1; i >= 0; --i) {
            LocalVariableReference var = new LocalVariableReference(outerLet);
            this.setLocation(var);
            InstanceOfExpression ioe = new InstanceOfExpression(var, (SequenceType)types.get(i));
            this.setLocation(ioe);
            Expression ife = Choose.makeConditional(ioe, (Expression)actions.get(i), lastAction);
            this.setLocation(ife);
            lastAction = ife;
        }
        outerLet.setAction(lastAction);
        return this.makeTracer(offset, outerLet, 2020, null);
    }

    private Expression parseTypeswitchReturnClause(StructuredQName varQName, LetExpression outerLet) throws XPathException {
        this.t.treatCurrentAsOperator();
        this.expect(25);
        this.nextToken();
        LetExpression innerLet = this.makeLetExpression();
        innerLet.setRequiredType(SequenceType.ANY_SEQUENCE);
        innerLet.setVariableQName(varQName);
        innerLet.setSequence(new LocalVariableReference(outerLet));
        this.declareRangeVariable(innerLet);
        Expression action = this.parseExprSingle();
        this.undeclareRangeVariable();
        innerLet.setAction(action);
        action = innerLet;
        return action;
    }

    protected Expression parseValidateExpression() throws XPathException {
        if (!this.env.getConfiguration().isSchemaAware(51)) {
            this.grumble("To use a validate expression, you need the schema-aware processor from http://www.saxonica.com/");
        }
        int offset = this.t.currentTokenStartOffset;
        int mode = 1;
        boolean foundCurly = false;
        switch (this.t.currentToken) {
            case 82: {
                mode = 1;
                this.nextToken();
                break;
            }
            case 83: {
                mode = 2;
                this.nextToken();
                break;
            }
            case 54: {
                if (!this.t.currentTokenValue.equals("validate")) {
                    throw new AssertionError((Object)"shouldn't be parsing a validate expression");
                }
                mode = 1;
                foundCurly = true;
            }
        }
        if (!foundCurly) {
            this.expect(53);
        }
        this.nextToken();
        Expression exp = this.parseExpression();
        if (exp instanceof ElementCreator) {
            ((ElementCreator)exp).setValidationMode(mode);
        } else if (exp instanceof DocumentInstr) {
            ((DocumentInstr)exp).setValidationAction(mode);
        } else {
            try {
                RoleLocator role = new RoleLocator(2, "validate", 0, null);
                role.setSourceLocator(this.makeLocator());
                exp = TypeChecker.staticTypeCheck(exp, SequenceType.SINGLE_NODE, false, role, ExpressionVisitor.make(this.env));
            }
            catch (XPathException err) {
                this.grumble(err.getMessage());
            }
            exp = new CopyOf(exp, true, mode, null, true);
            this.setLocation(exp);
            ((CopyOf)exp).setRequireDocumentOrElement(true);
        }
        this.expect(115);
        this.t.lookAhead();
        this.nextToken();
        return this.makeTracer(offset, exp, 2023, null);
    }

    protected Expression parseExtensionExpression() throws XPathException {
        Expression expr;
        int c;
        SchemaType requiredType = null;
        CharSequence trimmed = Whitespace.removeLeadingWhitespace(this.t.currentTokenValue);
        int len = trimmed.length();
        for (c = 0; c < len && " \t\r\n".indexOf(trimmed.charAt(c)) < 0; ++c) {
        }
        String qname = trimmed.subSequence(0, c).toString();
        String pragmaContents = "";
        while (c < len && " \t\r\n".indexOf(trimmed.charAt(c)) >= 0) {
            ++c;
        }
        if (c < len) {
            pragmaContents = trimmed.subSequence(c, len).toString();
        }
        if (!this.nameChecker.isQName(qname)) {
            this.grumble("First token in pragma must be a valid QName, terminated by whitespace");
        } else {
            int nameCode = this.makeNameCode(qname, false);
            String uri = this.env.getNamePool().getURI(nameCode);
            if ((nameCode & 0xFFFFF) == 264) {
                String typeName;
                if (!this.env.getConfiguration().isSchemaAware(51)) {
                    this.grumble("To use saxon:validate-type, you need the schema-aware processor from http://www.saxonica.com/");
                }
                if (!this.nameChecker.isQName(typeName = Whitespace.trim(pragmaContents))) {
                    this.grumble("Schema type expected in saxon:validate-type pragma");
                }
                int typeCode = this.makeNameCode(typeName, true);
                requiredType = this.env.getConfiguration().getSchemaType(typeCode & 0xFFFFF);
                if (requiredType == null) {
                    this.grumble("Unknown schema type " + typeName);
                }
            } else if (uri.equals("http://saxon.sf.net/")) {
                this.grumble("Unrecognized Saxon pragma " + qname);
            } else if (uri.length() == 0) {
                this.grumble("The QName identifying an option declaration must be prefixed", "XPST0081");
            }
        }
        this.nextToken();
        if (this.t.currentToken == 118) {
            expr = this.parseExtensionExpression();
        } else {
            this.expect(53);
            this.nextToken();
            if (this.t.currentToken == 115) {
                this.t.lookAhead();
                this.nextToken();
                this.grumble("Unrecognized pragma, with no fallback expression", "XQST0079");
            }
            expr = this.parseExpression();
            this.expect(115);
            this.t.lookAhead();
            this.nextToken();
        }
        if (requiredType == null) {
            return expr;
        }
        if (expr instanceof ElementCreator) {
            ((ElementCreator)expr).setSchemaType(requiredType);
            ((ElementCreator)expr).setValidationMode(8);
            return expr;
        }
        if (expr instanceof DocumentInstr) {
            ((DocumentInstr)expr).setSchemaType(requiredType);
            ((DocumentInstr)expr).setValidationMode(8);
            return expr;
        }
        CopyOf copy = new CopyOf(expr, true, 8, requiredType, true);
        copy.setLocationId(this.env.getLocationMap().allocateLocationId(this.env.getSystemId(), this.t.getLineNumber()));
        return copy;
    }

    protected Expression parseConstructor() throws XPathException {
        int offset = this.t.currentTokenStartOffset;
        switch (this.t.currentToken) {
            case 117: {
                Expression tag = this.parsePseudoXML(false);
                this.lookAhead();
                this.t.setState(3);
                this.nextToken();
                return tag;
            }
            case 54: {
                String nodeKind = this.t.currentTokenValue;
                if (nodeKind.equals("validate")) {
                    return this.parseValidateExpression();
                }
                if (nodeKind.equals("ordered") || nodeKind.equals("unordered")) {
                    this.nextToken();
                    Expression content = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    return content;
                }
                if (nodeKind.equals("document")) {
                    this.nextToken();
                    Expression content = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    DocumentInstr doc = new DocumentInstr(false, null, this.env.getBaseURI());
                    if (!((QueryModule)this.env).isPreserveNamespaces()) {
                        content = new CopyOf(content, false, 3, null, true);
                    }
                    doc.setValidationAction(((QueryModule)this.env).getConstructionMode());
                    doc.setContentExpression(content);
                    this.setLocation(doc, offset);
                    return doc;
                }
                if ("element".equals(nodeKind)) {
                    this.nextToken();
                    Expression name = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    this.expect(53);
                    this.t.setState(0);
                    this.nextToken();
                    Expression content = null;
                    if (this.t.currentToken != 115) {
                        content = this.parseExpression();
                        if (content instanceof ElementCreator) {
                            ((ElementCreator)content).setValidationMode(3);
                        }
                        this.expect(115);
                    }
                    this.lookAhead();
                    this.nextToken();
                    if (name instanceof Literal) {
                        int nameCode;
                        Value vName = ((Literal)name).getValue();
                        if (vName instanceof StringValue && !(vName instanceof AnyURIValue)) {
                            String lex = vName.getStringValue();
                            try {
                                nameCode = this.makeNameCodeSilently(lex, true);
                            }
                            catch (XPathException staticError) {
                                String code = staticError.getErrorCodeLocalPart();
                                if ("XPST0008".equals(code) || "XPST0081".equals(code)) {
                                    staticError.setErrorCode("XQDY0074");
                                }
                                staticError.setLocator(this.makeLocator());
                                throw staticError;
                            }
                            catch (QNameException qerr) {
                                XPathException e = new XPathException("Invalid QName in element constructor: " + lex);
                                e.setErrorCode("XQDY0074");
                                e.setLocator(this.makeLocator());
                                throw e;
                            }
                        } else if (vName instanceof QualifiedNameValue) {
                            String uri = ((QualifiedNameValue)vName).getNamespaceURI();
                            nameCode = this.env.getNamePool().allocate("", uri == null ? "" : uri, ((QualifiedNameValue)vName).getLocalName());
                        } else {
                            this.grumble("Element name must be either a string or a QName", "XPTY0004");
                            return null;
                        }
                        FixedElement inst = new FixedElement(nameCode, ((QueryModule)this.env).getActiveNamespaceCodes(), ((QueryModule)this.env).isInheritNamespaces(), null, ((QueryModule)this.env).getConstructionMode());
                        inst.setBaseURI(this.env.getBaseURI());
                        if (content == null) {
                            content = new Literal(EmptySequence.getInstance());
                        }
                        inst.setContentExpression(content);
                        this.setLocation(inst, offset);
                        return this.makeTracer(offset, inst, 2006, new StructuredQName(this.env.getNamePool(), nameCode));
                    }
                    ComputedElement inst = new ComputedElement(name, null, this.env.getNamespaceResolver(), this.env.getDefaultElementNamespace(), null, ((QueryModule)this.env).getConstructionMode(), ((QueryModule)this.env).isInheritNamespaces(), true);
                    this.setLocation(inst);
                    if (content == null) {
                        content = new Literal(EmptySequence.getInstance());
                    }
                    inst.setContentExpression(content);
                    this.setLocation(inst, offset);
                    return this.makeTracer(offset, inst, 143, null);
                }
                if ("attribute".equals(nodeKind)) {
                    this.nextToken();
                    Expression name = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    this.expect(53);
                    this.t.setState(0);
                    this.nextToken();
                    Expression content = null;
                    if (this.t.currentToken != 115) {
                        content = this.parseExpression();
                        this.expect(115);
                    }
                    this.lookAhead();
                    this.nextToken();
                    if (name instanceof Literal) {
                        Value vName = ((Literal)name).getValue();
                        if (vName instanceof StringValue && !(vName instanceof AnyURIValue)) {
                            int nameCode;
                            String lex = vName.getStringValue();
                            if (lex.equals("xmlns") || lex.startsWith("xmlns:")) {
                                this.grumble("Cannot create a namespace using an attribute constructor", "XQDY0044");
                            }
                            try {
                                nameCode = this.makeNameCodeSilently(lex, false);
                            }
                            catch (XPathException staticError) {
                                String code = staticError.getErrorCodeLocalPart();
                                staticError.setLocator(this.makeLocator());
                                if ("XPST0008".equals(code) || "XPST0081".equals(code)) {
                                    staticError.setErrorCode("XQDY0074");
                                }
                                throw staticError;
                            }
                            catch (QNameException err) {
                                XPathException e = new XPathException("Invalid QName in attribute constructor: " + lex);
                                e.setErrorCode("XQDY0074");
                                e.setLocator(this.makeLocator());
                                throw e;
                            }
                            FixedAttribute fatt = new FixedAttribute(nameCode, 4, null, 631);
                            fatt.setRejectDuplicates();
                            this.makeSimpleContent(content, fatt, offset);
                            return this.makeTracer(offset, fatt, 131, null);
                        }
                        if (vName instanceof QNameValue) {
                            QNameValue qnv = (QNameValue)vName;
                            int nameCode = this.env.getNamePool().allocate(qnv.getPrefix(), qnv.getNamespaceURI(), qnv.getLocalName());
                            FixedAttribute fatt = new FixedAttribute(nameCode, 4, null, 631);
                            fatt.setRejectDuplicates();
                            this.makeSimpleContent(content, fatt, offset);
                            return this.makeTracer(offset, fatt, 131, null);
                        }
                    }
                    ComputedAttribute att = new ComputedAttribute(name, null, this.env.getNamespaceResolver(), 4, null, -1, true);
                    att.setRejectDuplicates();
                    this.makeSimpleContent(content, att, offset);
                    return this.makeTracer(offset, att, 131, null);
                }
                if ("text".equals(nodeKind)) {
                    this.nextToken();
                    Expression value = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    Expression select = this.stringify(value, true);
                    ValueOf vof = new ValueOf(select, false, true);
                    this.setLocation(vof, offset);
                    return this.makeTracer(offset, vof, 182, null);
                }
                if ("comment".equals(nodeKind)) {
                    this.nextToken();
                    Expression value = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    Comment com = new Comment();
                    this.makeSimpleContent(value, com, offset);
                    return this.makeTracer(offset, com, 138, null);
                }
                if ("processing-instruction".equals(nodeKind)) {
                    this.nextToken();
                    Expression name = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    this.expect(53);
                    this.t.setState(0);
                    this.nextToken();
                    Expression content = null;
                    if (this.t.currentToken != 115) {
                        content = this.parseExpression();
                        this.expect(115);
                    }
                    this.lookAhead();
                    this.nextToken();
                    ProcessingInstruction pi = new ProcessingInstruction(name);
                    this.makeSimpleContent(content, pi, offset);
                    return this.makeTracer(offset, pi, 173, null);
                }
                this.grumble("Unrecognized node constructor " + this.t.currentTokenValue + "{}");
            }
            case 55: {
                int nameCode = this.makeNameCode(this.t.currentTokenValue, true);
                Expression content = null;
                this.nextToken();
                if (this.t.currentToken != 115) {
                    content = this.parseExpression();
                    this.expect(115);
                }
                this.lookAhead();
                this.nextToken();
                FixedElement el2 = new FixedElement(nameCode, ((QueryModule)this.env).getActiveNamespaceCodes(), ((QueryModule)this.env).isInheritNamespaces(), null, ((QueryModule)this.env).getConstructionMode());
                el2.setBaseURI(this.env.getBaseURI());
                this.setLocation(el2, offset);
                if (content == null) {
                    content = new Literal(EmptySequence.getInstance());
                }
                el2.setContentExpression(content);
                return this.makeTracer(offset, el2, 2006, new StructuredQName(this.env.getNamePool(), nameCode));
            }
            case 56: {
                if (this.t.currentTokenValue.equals("xmlns") || this.t.currentTokenValue.startsWith("xmlns:")) {
                    this.grumble("Cannot create a namespace using an attribute constructor", "XQDY0044");
                }
                int attNameCode = this.makeNameCode(this.t.currentTokenValue, false);
                Expression attContent = null;
                this.nextToken();
                if (this.t.currentToken != 115) {
                    attContent = this.parseExpression();
                    this.expect(115);
                }
                this.lookAhead();
                this.nextToken();
                FixedAttribute att2 = new FixedAttribute(attNameCode, 4, null, 631);
                att2.setRejectDuplicates();
                this.makeSimpleContent(attContent, att2, offset);
                return this.makeTracer(offset, att2, 2007, new StructuredQName(this.env.getNamePool(), attNameCode));
            }
            case 57: {
                String target = this.t.currentTokenValue;
                if (target.equalsIgnoreCase("xml")) {
                    this.grumble("A processing instruction must not be named 'xml' in any combination of upper and lower case");
                }
                StringLiteral piName = new StringLiteral(target);
                Expression piContent = null;
                this.nextToken();
                if (this.t.currentToken != 115) {
                    piContent = this.parseExpression();
                    this.expect(115);
                }
                this.lookAhead();
                this.nextToken();
                ProcessingInstruction pi2 = new ProcessingInstruction(piName);
                this.makeSimpleContent(piContent, pi2, offset);
                return this.makeTracer(offset, pi2, 173, null);
            }
        }
        return null;
    }

    private void makeSimpleContent(Expression content, SimpleNodeConstructor inst, int offset) throws XPathException {
        try {
            if (content == null) {
                inst.setSelect(new StringLiteral(StringValue.EMPTY_STRING), this.env.getConfiguration());
            } else {
                inst.setSelect(this.stringify(content, false), this.env.getConfiguration());
            }
            this.setLocation(inst, offset);
        }
        catch (XPathException e) {
            this.grumble(e.getMessage());
        }
    }

    private Expression parsePseudoXML(boolean allowEndTag) throws XPathException {
        try {
            Expression exp = null;
            int offset = this.t.inputOffset;
            char c = this.t.nextChar();
            switch (c) {
                case '!': {
                    c = this.t.nextChar();
                    if (c == '-') {
                        exp = this.parseCommentConstructor();
                        break;
                    }
                    if (c == '[') {
                        this.grumble("A CDATA section is allowed only in element content");
                        break;
                    }
                    this.grumble("Expected '--' or '[CDATA[' after '<!'");
                    break;
                }
                case '?': {
                    exp = this.parsePIConstructor();
                    break;
                }
                case '/': {
                    if (allowEndTag) {
                        FastStringBuffer sb = new FastStringBuffer(40);
                        while ((c = this.t.nextChar()) != '>') {
                            sb.append(c);
                        }
                        return new StringLiteral(new StringValue(sb));
                    }
                    this.grumble("Unmatched XML end tag");
                    break;
                }
                default: {
                    this.t.unreadChar();
                    exp = this.parseDirectElementConstructor();
                }
            }
            this.setLocation(exp, offset);
            return exp;
        }
        catch (StringIndexOutOfBoundsException e) {
            this.grumble("End of input encountered while parsing direct constructor");
            return null;
        }
    }

    private Expression parseDirectElementConstructor() throws XPathException, StringIndexOutOfBoundsException {
        char c;
        int offset = this.t.inputOffset - 1;
        FastStringBuffer buff = new FastStringBuffer(40);
        int namespaceCount = 0;
        while ((c = this.t.nextChar()) != ' ' && c != '\n' && c != '\r' && c != '\t' && c != '/' && c != '>') {
            buff.append(c);
        }
        String elname = buff.toString();
        HashMap<String, AttributeDetails> attributes = new HashMap<String, AttributeDetails>(10);
        while ((c = this.skipSpaces(c)) != '/' && c != '>') {
            int end;
            boolean isNamespace;
            int attOffset = this.t.inputOffset - 1;
            buff.setLength(0);
            do {
                buff.append(c);
            } while ((c = this.t.nextChar()) != ' ' && c != '\n' && c != '\r' && c != '\t' && c != '=');
            String attName = buff.toString();
            if (!this.nameChecker.isQName(attName)) {
                this.grumble("Invalid attribute name " + Err.wrap(attName, 2));
            }
            c = this.skipSpaces(c);
            this.expectChar(c, '=');
            c = this.t.nextChar();
            char delim = c = this.skipSpaces(c);
            boolean bl = isNamespace = "xmlns".equals(attName) || attName.startsWith("xmlns:");
            if (!isNamespace) {
                Expression avt;
                try {
                    avt = this.makeAttributeContent(this.t.input, this.t.inputOffset, delim, true);
                }
                catch (XPathException err) {
                    this.grumble(err.getMessage());
                    return null;
                }
                end = (int)((Int64Value)((Literal)avt).getValue()).longValue();
            } else {
                end = this.makeNamespaceContent(this.t.input, this.t.inputOffset, delim);
            }
            String val = this.t.input.substring(this.t.inputOffset - 1, end + 1);
            String rval = this.t.input.substring(this.t.inputOffset, end);
            this.t.inputOffset = end + 1;
            c = this.t.nextChar();
            if (c != ' ' && c != '\n' && c != '\r' && c != '\t' && c != '/' && c != '>') {
                this.grumble("There must be whitespace after every attribute except the last");
            }
            if ("xmlns".equals(attName) || attName.startsWith("xmlns:")) {
                String prefix;
                String uri;
                if (rval.indexOf(delim) >= 0) {
                    int d;
                    String doubleDelim = "" + delim + delim;
                    while ((d = rval.indexOf(doubleDelim)) >= 0) {
                        rval = rval.substring(0, d) + delim + rval.substring(d + 2);
                    }
                }
                if (!AnyURIValue.isValidURI(uri = this.URILiteral(rval))) {
                    this.grumble("Namespace must be a valid URI value", "XQST0022");
                }
                if ("xmlns".equals(attName)) {
                    prefix = "";
                    if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
                        this.grumble("Cannot have the XML namespace as the default namespace", "XQST0070");
                    }
                } else {
                    prefix = attName.substring(6);
                    if (prefix.equals("xml") && !uri.equals("http://www.w3.org/XML/1998/namespace")) {
                        this.grumble("Cannot bind the prefix 'xml' to a namespace other than the XML namespace", "XQST0070");
                    } else if (uri.equals("http://www.w3.org/XML/1998/namespace") && !prefix.equals("xml")) {
                        this.grumble("Cannot bind a prefix other than 'xml' to the XML namespace", "XQST0070");
                    } else if (prefix.equals("xmlns")) {
                        this.grumble("Cannot use xmlns as a namespace prefix", "XQST0070");
                    }
                    if (uri.length() == 0) {
                        this.grumble("Namespace URI must not be empty", "XQST0085");
                    }
                }
                ++namespaceCount;
                ((QueryModule)this.env).declareActiveNamespace(prefix, uri);
            }
            if (attributes.get(attName) != null) {
                if ("xmlns".equals(attName) || attName.startsWith("xmlns:")) {
                    this.grumble("Duplicate namespace declaration " + attName, "XQST0071");
                } else {
                    this.grumble("Duplicate attribute name " + attName, "XQST0040");
                }
            }
            AttributeDetails a = new AttributeDetails();
            a.value = val;
            a.startOffset = attOffset;
            attributes.put(attName, a);
        }
        int elNameCode = 0;
        try {
            String[] parts = this.nameChecker.getQNameParts(elname);
            String namespace = ((QueryModule)this.env).checkURIForPrefix(parts[0]);
            if (namespace == null) {
                this.grumble("Undeclared prefix in element name " + Err.wrap(elname, 1), "XPST0081");
            }
            elNameCode = this.env.getNamePool().allocate(parts[0], namespace, parts[1]);
        }
        catch (QNameException e) {
            this.grumble("Invalid element name " + Err.wrap(elname, 1));
        }
        int validationMode = ((QueryModule)this.env).getConstructionMode();
        FixedElement elInst = new FixedElement(elNameCode, ((QueryModule)this.env).getActiveNamespaceCodes(), ((QueryModule)this.env).isInheritNamespaces(), null, validationMode);
        elInst.setBaseURI(this.env.getBaseURI());
        this.setLocation(elInst, offset);
        ArrayList<Expression> contents = new ArrayList<Expression>(10);
        IntHashSet attFingerprints = new IntHashSet(attributes.size());
        for (String attName : attributes.keySet()) {
            Expression select;
            AttributeDetails a = (AttributeDetails)attributes.get(attName);
            String attValue = a.value;
            int attOffset = a.startOffset;
            if ("xmlns".equals(attName) || attName.startsWith("xmlns:") || this.scanOnly) continue;
            int attNameCode = 0;
            try {
                int key;
                String[] parts = this.nameChecker.getQNameParts(attName);
                String attNamespace = parts[0].length() == 0 ? "" : ((QueryModule)this.env).checkURIForPrefix(parts[0]);
                if (attNamespace == null) {
                    this.grumble("Undeclared prefix in attribute name " + Err.wrap(attName, 2), "XPST0081");
                }
                if (attFingerprints.contains(key = (attNameCode = this.env.getNamePool().allocate(parts[0], attNamespace, parts[1])) & 0xFFFFF)) {
                    this.grumble("Duplicate expanded attribute name " + attName, "XQST0040");
                }
                attFingerprints.add(key);
            }
            catch (QNameException e) {
                this.grumble("Invalid attribute name " + Err.wrap(attName, 2));
            }
            FixedAttribute attInst = new FixedAttribute(attNameCode, 4, null, 631);
            this.setLocation(attInst);
            try {
                select = this.makeAttributeContent(attValue, 1, attValue.charAt(0), false);
            }
            catch (XPathException err) {
                throw err.makeStatic();
            }
            attInst.setSelect(select, this.env.getConfiguration());
            attInst.setRejectDuplicates();
            this.setLocation(attInst);
            contents.add(this.makeTracer(attOffset, attInst, 2007, new StructuredQName(this.env.getNamePool(), attNameCode)));
        }
        if (c == '/') {
            this.expectChar(this.t.nextChar(), '>');
        } else {
            this.readElementContent(elname, contents);
        }
        Expression[] elk = new Expression[contents.size()];
        for (int i = 0; i < contents.size(); ++i) {
            if (validationMode != 4) {
                ((Expression)contents.get(i)).suppressValidation(validationMode);
            }
            elk[i] = (Expression)contents.get(i);
        }
        Block block = new Block();
        block.setChildren(elk);
        elInst.setContentExpression(block);
        for (int n = 0; n < namespaceCount; ++n) {
            ((QueryModule)this.env).undeclareNamespace();
        }
        return this.makeTracer(offset, elInst, 2006, new StructuredQName(this.env.getNamePool(), elNameCode));
    }

    private Expression makeAttributeContent(String avt, int start, char terminator, boolean scanOnly) throws XPathException {
        int lineNumber = this.t.getLineNumber();
        ArrayList<Expression> components = new ArrayList<Expression>(10);
        int last = start;
        int len = avt.length();
        while (last < len) {
            XPathException e;
            int i2 = avt.indexOf(terminator, last);
            if (i2 < 0) {
                e = new XPathException("Attribute constructor is not properly terminated");
                e.setIsStaticError(true);
                throw e;
            }
            int i0 = avt.indexOf("{", last);
            int i1 = avt.indexOf("{{", last);
            int i8 = avt.indexOf("}", last);
            int i9 = avt.indexOf("}}", last);
            if (!(i0 >= 0 && i2 >= i0 || i8 >= 0 && i2 >= i8)) {
                this.addStringComponent(components, avt, last, i2);
                if (i2 + 1 < avt.length() && avt.charAt(i2 + 1) == terminator) {
                    components.add(new StringLiteral(terminator + ""));
                    last = i2 + 2;
                    continue;
                }
                last = i2;
                break;
            }
            if (i8 >= 0 && (i0 < 0 || i8 < i0)) {
                if (i8 != i9) {
                    e = new XPathException("Closing curly brace in attribute value template \"" + avt + "\" must be doubled");
                    e.setIsStaticError(true);
                    throw e;
                }
                this.addStringComponent(components, avt, last, i8 + 1);
                last = i8 + 2;
                continue;
            }
            if (i1 >= 0 && i1 == i0) {
                this.addStringComponent(components, avt, last, i1 + 1);
                last = i1 + 2;
                continue;
            }
            if (i0 >= 0) {
                if (i0 > last) {
                    this.addStringComponent(components, avt, last, i0);
                }
                QueryParser parser = new QueryParser();
                parser.setScanOnly(scanOnly);
                if (this.rangeVariables != null) {
                    parser.setRangeVariableStack(this.rangeVariables);
                }
                Expression exp = parser.parse(avt, i0 + 1, 115, lineNumber, this.env);
                if (!scanOnly) {
                    exp = ExpressionVisitor.make(this.env).simplify(exp);
                }
                last = parser.getTokenizer().currentTokenStartOffset + 1;
                components.add(QueryParser.makeStringJoin(exp, this.env));
                continue;
            }
            throw new IllegalStateException("Internal error parsing direct attribute constructor");
        }
        if (scanOnly) {
            return new Literal(Int64Value.makeIntegerValue(last));
        }
        if (components.isEmpty()) {
            return new StringLiteral(StringValue.EMPTY_STRING);
        }
        if (components.size() == 1) {
            return ExpressionVisitor.make(this.env).simplify((Expression)components.get(0));
        }
        Expression[] args = new Expression[components.size()];
        components.toArray(args);
        Concat fn = (Concat)SystemFunction.makeSystemFunction("concat", args);
        fn.setLocationId(this.env.getLocationMap().allocateLocationId(this.env.getSystemId(), lineNumber));
        return ExpressionVisitor.make(this.env).simplify(fn);
    }

    private void addStringComponent(List components, String avt, int start, int end) throws XPathException {
        if (start < end) {
            FastStringBuffer sb = new FastStringBuffer(end - start);
            block6: for (int i = start; i < end; ++i) {
                char c = avt.charAt(i);
                switch (c) {
                    case '&': {
                        int semic = avt.indexOf(59, i);
                        if (semic < 0) {
                            this.grumble("No closing ';' found for entity or character reference");
                            continue block6;
                        }
                        String entity = avt.substring(i + 1, semic);
                        sb.append(this.analyzeEntityReference(entity));
                        i = semic;
                        continue block6;
                    }
                    case '<': {
                        this.grumble("The < character must not appear in attribute content");
                        continue block6;
                    }
                    case '\t': 
                    case '\n': {
                        sb.append(' ');
                        continue block6;
                    }
                    case '\r': {
                        sb.append(' ');
                        if (i + 1 >= end || avt.charAt(i + 1) != '\n') continue block6;
                        ++i;
                        continue block6;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            components.add(new StringLiteral(sb.toString()));
        }
    }

    private int makeNamespaceContent(String avt, int start, char terminator) throws XPathException {
        int last = start;
        int len = avt.length();
        while (last < len) {
            int i2 = avt.indexOf(terminator, last);
            if (i2 < 0) {
                XPathException e = new XPathException("Namespace declaration is not properly terminated");
                e.setIsStaticError(true);
                throw e;
            }
            if (i2 + 1 < avt.length() && avt.charAt(i2 + 1) == terminator) {
                last = i2 + 2;
                continue;
            }
            last = i2;
            break;
        }
        return last;
    }

    private void readElementContent(String startTag, List components) throws XPathException {
        TypeHierarchy th = this.env.getConfiguration().getTypeHierarchy();
        try {
            boolean afterEnclosedExpr = false;
            while (true) {
                Expression previousComponent;
                ItemType previousItemType;
                Expression exp;
                char c;
                FastStringBuffer text = new FastStringBuffer(256);
                boolean containsEntities = false;
                while (true) {
                    if ((c = this.t.nextChar()) == '<') {
                        if (this.t.nextChar() == '!') {
                            if (this.t.nextChar() == '[') {
                                this.readCDATASection(text);
                                containsEntities = true;
                                continue;
                            }
                            this.t.unreadChar();
                            this.t.unreadChar();
                            break;
                        }
                        this.t.unreadChar();
                        break;
                    }
                    if (c == '&') {
                        text.append(this.readEntityReference());
                        containsEntities = true;
                        continue;
                    }
                    if (c == '}') {
                        c = this.t.nextChar();
                        if (c != '}') {
                            this.grumble("'}' must be written as '}}' within element content");
                        }
                        text.append(c);
                        continue;
                    }
                    if (c == '{') {
                        c = this.t.nextChar();
                        if (c != '{') {
                            c = '{';
                            break;
                        }
                        text.append(c);
                        continue;
                    }
                    text.append(c);
                }
                if (text.length() > 0 && containsEntities | ((QueryModule)this.env).isPreserveBoundarySpace() | !Whitespace.isWhite(text)) {
                    ValueOf inst = new ValueOf(new StringLiteral(new StringValue(text.condense())), false, false);
                    this.setLocation(inst);
                    components.add(inst);
                    afterEnclosedExpr = false;
                }
                if (c == '<') {
                    exp = this.parsePseudoXML(true);
                    if (exp instanceof StringLiteral) {
                        String endTag = ((StringLiteral)exp).getStringValue();
                        if (Whitespace.isWhitespace(endTag.charAt(0))) {
                            this.grumble("End tag contains whitespace before the name");
                        }
                        if ((endTag = Whitespace.trim(endTag)).equals(startTag)) {
                            return;
                        }
                        this.grumble("End tag </" + endTag + "> does not match start tag <" + startTag + '>');
                        continue;
                    }
                    components.add(exp);
                    continue;
                }
                if (afterEnclosedExpr && !((previousItemType = (previousComponent = (Expression)components.get(components.size() - 1)).getItemType(th)) instanceof NodeTest)) {
                    ValueOf inst = new ValueOf(new StringLiteral(StringValue.EMPTY_STRING), false, false);
                    this.setLocation(inst);
                    components.add(inst);
                }
                this.t.unreadChar();
                this.t.setState(0);
                this.lookAhead();
                this.nextToken();
                exp = this.parseExpression();
                if (!((QueryModule)this.env).isPreserveNamespaces()) {
                    exp = new CopyOf(exp, false, 3, null, true);
                }
                components.add(exp);
                this.expect(115);
                afterEnclosedExpr = true;
            }
        }
        catch (StringIndexOutOfBoundsException err) {
            this.grumble("No closing end tag found for direct element constructor");
            return;
        }
    }

    private Expression parsePIConstructor() throws XPathException {
        try {
            String target;
            FastStringBuffer pi = new FastStringBuffer(120);
            int firstSpace = -1;
            while (!pi.toString().endsWith("?>")) {
                char c = this.t.nextChar();
                if (firstSpace < 0 && " \t\r\n".indexOf(c) >= 0) {
                    firstSpace = pi.length();
                }
                pi.append(c);
            }
            pi.setLength(pi.length() - 2);
            String data = "";
            if (firstSpace < 0) {
                target = pi.toString();
            } else {
                target = pi.toString().substring(0, firstSpace);
                ++firstSpace;
                while (firstSpace < pi.length() && " \t\r\n".indexOf(pi.charAt(firstSpace)) >= 0) {
                    ++firstSpace;
                }
                data = pi.toString().substring(firstSpace);
            }
            if (!this.nameChecker.isValidNCName(target)) {
                this.grumble("Invalid processing instruction name " + Err.wrap(target));
            }
            if (target.equalsIgnoreCase("xml")) {
                this.grumble("A processing instruction must not be named 'xml' in any combination of upper and lower case");
            }
            ProcessingInstruction instruction = new ProcessingInstruction(new StringLiteral(target));
            instruction.setSelect(new StringLiteral(data), this.env.getConfiguration());
            this.setLocation(instruction);
            return instruction;
        }
        catch (StringIndexOutOfBoundsException err) {
            this.grumble("No closing '?>' found for processing instruction");
            return null;
        }
    }

    private void readCDATASection(FastStringBuffer cdata) throws XPathException {
        try {
            char c = this.t.nextChar();
            this.expectChar(c, 'C');
            c = this.t.nextChar();
            this.expectChar(c, 'D');
            c = this.t.nextChar();
            this.expectChar(c, 'A');
            c = this.t.nextChar();
            this.expectChar(c, 'T');
            c = this.t.nextChar();
            this.expectChar(c, 'A');
            c = this.t.nextChar();
            this.expectChar(c, '[');
            while (!cdata.toString().endsWith("]]>")) {
                cdata.append(this.t.nextChar());
            }
            cdata.setLength(cdata.length() - 3);
        }
        catch (StringIndexOutOfBoundsException err) {
            this.grumble("No closing ']]>' found for CDATA section");
        }
    }

    private Expression parseCommentConstructor() throws XPathException {
        try {
            char c = this.t.nextChar();
            this.expectChar(c, '-');
            FastStringBuffer comment = new FastStringBuffer(240);
            while (!comment.toString().endsWith("--")) {
                comment.append(this.t.nextChar());
            }
            if (this.t.nextChar() != '>') {
                this.grumble("'--' is not permitted in an XML comment");
            }
            CharSequence commentText = comment.subSequence(0, comment.length() - 2);
            Comment instruction = new Comment();
            instruction.setSelect(new StringLiteral(new StringValue(commentText)), this.env.getConfiguration());
            this.setLocation(instruction);
            return instruction;
        }
        catch (StringIndexOutOfBoundsException err) {
            this.grumble("No closing '-->' found for comment constructor");
            return null;
        }
    }

    private Expression stringify(Expression exp, boolean noNodeIfEmpty) throws XPathException {
        return ExpressionVisitor.make(this.env).simplify(new QuerySimpleContentConstructor(exp, new StringLiteral(StringValue.SINGLE_SPACE), noNodeIfEmpty));
    }

    protected Literal makeStringLiteral(String token) throws XPathException {
        if (token.indexOf(38) == -1) {
            return new StringLiteral(token);
        }
        FastStringBuffer sb = this.unescape(token);
        return new StringLiteral(StringValue.makeStringValue(sb));
    }

    private FastStringBuffer unescape(String token) throws XPathException {
        FastStringBuffer sb = new FastStringBuffer(80);
        for (int i = 0; i < token.length(); ++i) {
            char c = token.charAt(i);
            if (c == '&') {
                int semic = token.indexOf(59, i);
                if (semic < 0) {
                    this.grumble("No closing ';' found for entity or character reference");
                    continue;
                }
                String entity = token.substring(i + 1, semic);
                sb.append(this.analyzeEntityReference(entity));
                i = semic;
                continue;
            }
            sb.append(c);
        }
        return sb;
    }

    private String readEntityReference() throws XPathException {
        try {
            char c;
            FastStringBuffer sb = new FastStringBuffer(40);
            while ((c = this.t.nextChar()) != ';') {
                sb.append(c);
            }
            String entity = sb.toString();
            return this.analyzeEntityReference(entity);
        }
        catch (StringIndexOutOfBoundsException err) {
            this.grumble("No closing ';' found for entity or character reference");
            return null;
        }
    }

    private String analyzeEntityReference(String entity) throws XPathException {
        if ("lt".equals(entity)) {
            return "<";
        }
        if ("gt".equals(entity)) {
            return ">";
        }
        if ("amp".equals(entity)) {
            return "&";
        }
        if ("quot".equals(entity)) {
            return "\"";
        }
        if ("apos".equals(entity)) {
            return "'";
        }
        if (entity.length() < 2 || entity.charAt(0) != '#') {
            this.grumble("invalid entity reference &" + entity + ';');
            return null;
        }
        return this.parseCharacterReference(entity);
    }

    private String parseCharacterReference(String entity) throws XPathException {
        NameChecker nc;
        int i;
        int value = 0;
        if (entity.charAt(1) == 'x') {
            entity = entity.toLowerCase();
            for (i = 2; i < entity.length(); ++i) {
                int digit = "0123456789abcdef".indexOf(entity.charAt(i));
                if (digit < 0) {
                    this.grumble("Invalid hex digit '" + entity.charAt(i) + "' in character reference");
                }
                if ((value = value * 16 + digit) <= 0x10FFFF) continue;
                this.grumble("Character reference exceeds Unicode codepoint limit", "XQST0090");
            }
        } else {
            for (i = 1; i < entity.length(); ++i) {
                int digit = "0123456789".indexOf(entity.charAt(i));
                if (digit < 0) {
                    this.grumble("Invalid digit '" + entity.charAt(i) + "' in decimal character reference");
                }
                if ((value = value * 10 + digit) <= 0x10FFFF) continue;
                this.grumble("Character reference exceeds Unicode codepoint limit", "XQST0090");
            }
        }
        if (!(nc = this.env.getConfiguration().getNameChecker()).isValidChar(value)) {
            this.grumble("Invalid XML character reference x" + Integer.toHexString(value), "XQST0090");
        }
        if (value <= 65535) {
            return "" + (char)value;
        }
        if (value <= 0x10FFFF) {
            return "" + (char)(0xD800 | (value -= 65536) >> 10) + (char)(0xDC00 | value & 0x3FF);
        }
        this.grumble("Character reference x" + Integer.toHexString(value) + " is too large", "XQST0090");
        return null;
    }

    private String URILiteral(String in) throws XPathException {
        return Whitespace.applyWhitespaceNormalization(2, this.unescape(in)).toString();
    }

    private void lookAhead() throws XPathException {
        try {
            this.t.lookAhead();
        }
        catch (XPathException err) {
            this.grumble(err.getMessage());
        }
    }

    private char skipSpaces(char c) throws StringIndexOutOfBoundsException {
        while (c == ' ' || c == '\n' || c == '\r' || c == '\t') {
            c = this.t.nextChar();
        }
        return c;
    }

    private void expectChar(char actual, char expected) throws XPathException {
        if (actual != expected) {
            this.grumble("Expected '" + expected + "', found '" + actual + '\'');
        }
    }

    protected String getLanguage() {
        return "XQuery";
    }

    private static class Import {
        String namespaceURI;
        List locationURIs;

        private Import() {
        }
    }

    private static class AttributeDetails {
        String value;
        int startOffset;

        private AttributeDetails() {
        }
    }

    private static class SortSpec {
        public Expression sortKey;
        public boolean ascending;
        public boolean emptyLeast;
        public String collation;

        private SortSpec() {
        }
    }

    private static class LetClause {
        public LetExpression variable;
        public int offset;

        private LetClause() {
        }
    }
}

