/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.image.Colorizer;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.image.PlanarImage;
import org.apache.sis.image.RecoloredImage;
import org.apache.sis.image.SourceAlignedImage;
import org.apache.sis.image.Transferer;
import org.apache.sis.image.WritableComputedImage;
import org.apache.sis.internal.coverage.SampleDimensions;
import org.apache.sis.internal.coverage.j2d.ColorModelBuilder;
import org.apache.sis.internal.coverage.j2d.ImageLayout;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.coverage.j2d.TileOpExecutor;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.logging.Logging;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

class BandedSampleConverter
extends WritableComputedImage {
    private static final String[] ADDED_PROPERTIES = new String[]{"org.apache.sis.SampleDimensions", "org.apache.sis.SampleResolutions"};
    private final MathTransform1D[] converters;
    private final ColorModel colorModel;
    private final SampleDimension[] sampleDimensions;
    private final double[] sampleResolutions;

    private BandedSampleConverter(RenderedImage source, BandedSampleModel sampleModel, ColorModel colorModel, NumberRange<?>[] ranges, MathTransform1D[] converters, SampleDimension[] sampleDimensions) {
        super(sampleModel, source);
        this.colorModel = colorModel;
        this.converters = converters;
        this.sampleDimensions = sampleDimensions;
        this.ensureCompatible(colorModel);
        boolean hasResolutions = false;
        double[] resolutions = new double[converters.length];
        Object sr = source.getProperty("org.apache.sis.SampleResolutions");
        int n = sr != null && Numbers.isNumber(sr.getClass().getComponentType()) ? Array.getLength(sr) : 0;
        for (int i = 0; i < resolutions.length; ++i) {
            Number v;
            double r;
            NumberRange<?> range;
            double middle = Double.NaN;
            if (ranges != null && i < ranges.length && (range = ranges[i]) != null) {
                middle = range.getMedian();
            }
            if (!Double.isFinite(middle)) {
                SampleModel sm = source.getSampleModel();
                middle = ImageUtilities.isUnsignedType(sm) ? Math.scalb(0.5, sm.getSampleSize(i)) : 0.0;
            }
            MathTransform1D c = converters[i];
            try {
                r = c.derivative(middle);
                if (!Double.isFinite(r)) {
                    r = c.derivative(1.0);
                }
            }
            catch (TransformException e) {
                r = Double.NaN;
            }
            if (i < n && (v = (Number)Array.get(sr, i)) != null) {
                r *= v instanceof Float ? DecimalFunctions.floatToDouble(v.floatValue()) : v.doubleValue();
            }
            resolutions[i] = r;
            hasResolutions |= Double.isFinite(r);
        }
        this.sampleResolutions = (double[])(hasResolutions ? resolutions : null);
    }

    static BandedSampleConverter create(RenderedImage source, ImageLayout layout, NumberRange<?>[] sourceRanges, MathTransform1D[] converters, int targetType, Colorizer colorizer) {
        if (source instanceof RecoloredImage) {
            source = ((RecoloredImage)source).source;
        }
        int numBands = converters.length;
        BandedSampleModel sampleModel = layout.createBandedSampleModel(targetType, numBands, source, null, 0);
        SampleDimension[] sampleDimensions = SampleDimensions.IMAGE_PROCESSOR_ARGUMENT.get();
        int visibleBand = ImageUtilities.getVisibleBand(source);
        ColorModel colorModel = ColorModelBuilder.NULL_COLOR_MODEL;
        if (colorizer != null) {
            Colorizer.Target target = new Colorizer.Target(sampleModel, UnmodifiableArrayList.wrap(sampleDimensions), visibleBand);
            colorModel = colorizer.apply(target).orElse(null);
        }
        if (colorModel == null) {
            ColorModelBuilder builder;
            SampleDimension sd = null;
            if (sampleDimensions != null && visibleBand >= 0 && visibleBand < sampleDimensions.length) {
                sd = sampleDimensions[visibleBand];
            }
            if ((builder = new ColorModelBuilder(ColorModelBuilder.GRAYSCALE, null, false)).initialize(source.getSampleModel(), sd) || builder.initialize(source.getColorModel())) {
                colorModel = builder.createColorModel(targetType, numBands, Math.max(visibleBand, 0));
            }
        }
        if (source instanceof WritableRenderedImage) {
            try {
                MathTransform1D[] inverses = new MathTransform1D[numBands];
                for (int i = 0; i < numBands; ++i) {
                    inverses[i] = converters[i].inverse();
                }
                return new Writable((WritableRenderedImage)source, sampleModel, colorModel, sourceRanges, converters, inverses, sampleDimensions);
            }
            catch (NoninvertibleTransformException e) {
                Logging.recoverableException(ImageUtilities.LOGGER, ImageProcessor.class, "convert", e);
            }
        }
        return new BandedSampleConverter(source, sampleModel, colorModel, sourceRanges, converters, sampleDimensions);
    }

    @Override
    public Object getProperty(String key) {
        switch (key) {
            case "org.apache.sis.SampleDimensions": {
                if (this.sampleDimensions == null) break;
                return this.sampleDimensions.clone();
            }
            case "org.apache.sis.SampleResolutions": {
                if (this.sampleResolutions == null) break;
                return this.sampleResolutions.clone();
            }
            default: {
                if (!SourceAlignedImage.POSITIONAL_PROPERTIES.contains(key)) break;
                return this.getSource().getProperty(key);
            }
        }
        return super.getProperty(key);
    }

    @Override
    public String[] getPropertyNames() {
        return SourceAlignedImage.filterPropertyNames(this.getSource().getPropertyNames(), SourceAlignedImage.POSITIONAL_PROPERTIES, (String[])(this.sampleResolutions != null ? ADDED_PROPERTIES : null));
    }

    @Override
    public ColorModel getColorModel() {
        return this.colorModel;
    }

    @Override
    public int getWidth() {
        return this.getSource().getWidth();
    }

    @Override
    public int getHeight() {
        return this.getSource().getHeight();
    }

    @Override
    public int getMinX() {
        return this.getSource().getMinX();
    }

    @Override
    public int getMinY() {
        return this.getSource().getMinY();
    }

    @Override
    public int getMinTileX() {
        return this.getSource().getMinTileX();
    }

    @Override
    public int getMinTileY() {
        return this.getSource().getMinTileY();
    }

    @Override
    protected Raster computeTile(int tileX, int tileY, WritableRaster target) throws TransformException {
        if (target == null) {
            target = this.createTile(tileX, tileY);
        }
        Transferer.create(this.getSource(), target).compute(this.converters);
        return target;
    }

    @Override
    protected Disposable prefetch(Rectangle tiles) {
        RenderedImage source = this.getSource();
        if (source instanceof PlanarImage) {
            Rectangle pixels = ImageUtilities.tilesToPixels(this, tiles);
            ImageUtilities.clipBounds(source, pixels);
            return ((PlanarImage)source).prefetch(ImageUtilities.pixelsToTiles(source, pixels));
        }
        return super.prefetch(tiles);
    }

    public int hashCode() {
        return this.hashCodeBase() + 37 * Arrays.hashCode(this.converters) + Objects.hashCode(this.colorModel);
    }

    public boolean equals(Object object) {
        if (this.equalsBase(object)) {
            BandedSampleConverter other = (BandedSampleConverter)object;
            return Arrays.equals(this.converters, other.converters) && Objects.equals(this.colorModel, other.colorModel) && Arrays.equals(this.sampleResolutions, other.sampleResolutions);
        }
        return false;
    }

    private static final class Writable
    extends BandedSampleConverter
    implements WritableRenderedImage {
        private final MathTransform1D[] inverses;

        Writable(WritableRenderedImage source, BandedSampleModel sampleModel, ColorModel colorModel, NumberRange<?>[] ranges, MathTransform1D[] converters, MathTransform1D[] inverses, SampleDimension[] sampleDimensions) {
            super(source, sampleModel, colorModel, ranges, converters, sampleDimensions);
            this.inverses = inverses;
        }

        @Override
        public void setData(final Raster data) {
            final Rectangle bounds = data.getBounds();
            WritableRenderedImage target = (WritableRenderedImage)this.getSource();
            ImageUtilities.clipBounds(target, bounds);
            if (!bounds.isEmpty()) {
                TileOpExecutor executor = new TileOpExecutor(target, bounds){

                    @Override
                    protected void writeTo(WritableRaster target) throws TransformException {
                        Rectangle aoi = target.getBounds().intersection(bounds);
                        Transferer.create(data, target, aoi).compute(inverses);
                    }
                };
                executor.writeTo(target);
                this.markDirtyTiles(executor.getTileIndices());
            }
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public boolean equals(Object object) {
            return object == this;
        }
    }
}

