/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Set;
import org.apache.sis.image.ResampledImage;
import org.apache.sis.image.SourceAlignedImage;
import org.apache.sis.internal.coverage.j2d.ColorModelFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

final class PositionalConsistencyImage
extends SourceAlignedImage {
    private static final Set<String> INHERITED_PROPERTIES = Set.of("org.apache.sis.GridGeometry", "org.apache.sis.PositionalAccuracy", "org.apache.sis.Mask");
    private static final String[] ADDED_PROPERTIES = new String[]{"org.apache.sis.SampleResolutions"};
    private final MathTransform toSource;
    private final MathTransform toTarget;

    PositionalConsistencyImage(ResampledImage image, MathTransform toSource) throws TransformException {
        super(image, ColorModelFactory.createGrayScale(4, 1, 0, 0.0, 1.0));
        this.toSource = toSource;
        this.toTarget = image.toSource.inverse();
    }

    @Override
    public Object getProperty(String key) {
        switch (key) {
            case "org.apache.sis.SampleResolutions": {
                return new double[]{0.015625};
            }
            case "org.apache.sis.PositionalAccuracy": 
            case "org.apache.sis.GridGeometry": 
            case "org.apache.sis.Mask": {
                return this.getSource().getProperty(key);
            }
        }
        return super.getProperty(key);
    }

    @Override
    public String[] getPropertyNames() {
        return PositionalConsistencyImage.filterPropertyNames(this.getSource().getPropertyNames(), INHERITED_PROPERTIES, ADDED_PROPERTIES);
    }

    @Override
    protected Raster computeTile(int tileX, int tileY, WritableRaster tile) throws TransformException {
        if (tile == null) {
            tile = this.createTile(tileX, tileY);
        }
        int scanline = tile.getWidth();
        int tileMinX = tile.getMinX();
        int tileMinY = tile.getMinY();
        int tileMaxX = Math.addExact(tileMinX, scanline);
        int tileMaxY = Math.addExact(tileMinY, tile.getHeight());
        double[] buffer = new double[scanline * Math.max(2, this.toSource.getSourceDimensions())];
        for (int y = tileMinY; y < tileMaxY; ++y) {
            int i = 0;
            for (int x = tileMinX; x < tileMaxX; ++x) {
                buffer[i++] = x;
                buffer[i++] = y;
            }
            this.toSource.transform(buffer, 0, buffer, 0, scanline);
            this.toTarget.transform(buffer, 0, buffer, 0, scanline);
            int t2 = 0;
            int i2 = 0;
            for (int x = tileMinX; x < tileMaxX; ++x) {
                buffer[t2++] = Math.hypot(buffer[i2++] - (double)x, buffer[i2++] - (double)y);
            }
            tile.setSamples(tileMinX, y, scanline, 1, 0, buffer);
        }
        return tile;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 67 * this.toSource.hashCode() + 97 * this.toTarget.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            PositionalConsistencyImage other = (PositionalConsistencyImage)object;
            return this.toSource.equals(other.toSource) && this.toTarget.equals(other.toTarget);
        }
        return false;
    }
}

