/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage.j2d;

import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.coverage.j2d.ScaledColorSpace;

public enum ColorModelType {
    DIRECT(false, false),
    INDEXED(true, false),
    SCALED(true, true),
    OTHER(false, true);

    public final boolean useColorRamp;
    public final boolean isSlow;

    private ColorModelType(boolean useColorRamp, boolean isSlow) {
        this.useColorRamp = useColorRamp;
        this.isSlow = isSlow;
    }

    public static ColorModelType find(ColorModel model) {
        if (model != null) {
            if (model instanceof DirectColorModel) {
                return DIRECT;
            }
            if (model instanceof IndexColorModel) {
                return INDEXED;
            }
            if (model.getColorSpace() instanceof ScaledColorSpace) {
                return SCALED;
            }
            if (model.getClass() == ComponentColorModel.class && model.getColorSpace().getType() == 5 && ImageUtilities.isIntegerType(model.getTransferType())) {
                return DIRECT;
            }
        }
        return OTHER;
    }
}

