/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import java.sql.SQLException;
import java.text.Format;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.metadata.Identifiers;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.metadata.Resources;
import org.apache.sis.internal.metadata.sql.Initializer;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.internal.util.MetadataServices;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.util.ControlledVocabulary;

public final class ServicesForUtility
extends MetadataServices {
    @Override
    public boolean isUnmarshalling() {
        Context context = Context.current();
        return context != null && !Context.isFlagSet(context, 1);
    }

    @Override
    public String getCodeTitle(ControlledVocabulary code, Locale locale) {
        return Types.getCodeTitle(code).toString(locale);
    }

    @Override
    public String getUnicodeIdentifier(Citation citation) {
        return Identifiers.getIdentifier(citation, true);
    }

    @Override
    public String getInformation(String key, Locale locale) {
        switch (key) {
            case "DataSource": {
                Object server = null;
                Object database = null;
                try {
                    DataSource ds = Initializer.getDataSource();
                    if (ds != null) {
                        Class<?> type = ds.getClass();
                        database = type.getMethod("getDatabaseName", null).invoke((Object)ds, (Object[])null);
                        server = type.getMethod("getServerName", null).invoke((Object)ds, (Object[])null);
                    }
                }
                catch (NoSuchMethodException e) {
                    Logging.recoverableException(SystemListener.LOGGER, MetadataServices.class, "getInformation", e);
                }
                catch (Exception e) {
                    Object message = Exceptions.getLocalizedMessage(e, locale);
                    if (message == null || ((String)message).indexOf(32) < 0) {
                        message = Classes.getShortClassName(e) + ": " + (String)message;
                    }
                    return message;
                }
                if (database != null) {
                    if (server != null) {
                        database = "//" + String.valueOf(server) + "/" + String.valueOf(database);
                    }
                    return database.toString();
                }
                return null;
            }
        }
        return ReferencingServices.getInstance().getInformation(key, locale);
    }

    @Override
    public Format createCoordinateFormat(Locale locale, TimeZone timezone) {
        return ReferencingServices.getInstance().createCoordinateFormat(locale, timezone);
    }

    @Override
    public DataSource getDataSource() throws SQLException {
        try {
            return Initializer.getDataSource();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(Errors.format((short)6, "SpatialMetadata"), e);
        }
    }

    @Override
    public void setDataSource(Supplier<DataSource> ds) {
        if (!Initializer.setDefault(ds)) {
            throw new IllegalStateException(Resources.format((short)6, "SpatialMetadata"));
        }
    }
}

