/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.image;

import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.Optional;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridCoverage2D;
import org.apache.sis.coverage.grid.GridDerivation;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.internal.coverage.RangeArgument;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.StoreResource;
import org.apache.sis.internal.storage.image.WorldFileStore;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.storage.AbstractGridCoverageResource;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.iso.Names;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

class WorldFileResource
extends AbstractGridCoverageResource
implements StoreResource {
    static final int X_DIMENSION = 0;
    static final int Y_DIMENSION = 1;
    private volatile WorldFileStore store;
    private int imageIndex;
    private GenericName identifier;
    private GridGeometry gridGeometry;
    private List<SampleDimension> sampleDimensions;
    private SoftReference<GridCoverage> fullCoverage;

    WorldFileResource(WorldFileStore store, StoreListeners parent, int imageIndex, GridGeometry gridGeometry) {
        super(parent, store.isComponentHidden());
        this.store = store;
        this.imageIndex = imageIndex;
        this.gridGeometry = gridGeometry;
    }

    @Override
    public final DataStore getOriginator() {
        return this.store;
    }

    final WorldFileStore store() throws DataStoreException {
        WorldFileStore store = this.store;
        if (store != null) {
            return store;
        }
        throw new DataStoreException(Resources.format((short)73));
    }

    final int getImageIndex() {
        return this.imageIndex;
    }

    final void decrementImageIndex() throws DataStoreException {
        this.getIdentifier();
        --this.imageIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Optional<GenericName> getIdentifier() throws DataStoreException {
        WorldFileStore store;
        WorldFileStore worldFileStore = store = this.store();
        synchronized (worldFileStore) {
            if (this.identifier == null) {
                String base = String.valueOf(this.getImageIndex() + 1);
                Object id = base;
                int n = 0;
                while (store.identifiers.putIfAbsent((String)id, Boolean.TRUE) != null) {
                    if (--n >= 0) {
                        throw new ArithmeticException();
                    }
                    id = base + n;
                }
                String filename = store.getDisplayName();
                if (store.suffix != null) {
                    filename = IOUtilities.filenameWithoutExtension(filename);
                }
                this.identifier = Names.createLocalName(filename, null, (CharSequence)id).toFullyQualifiedName();
            }
            return Optional.of(this.identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GridGeometry getGridGeometry() throws DataStoreException {
        WorldFileStore worldFileStore = this.store();
        synchronized (worldFileStore) {
            return this.gridGeometry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<SampleDimension> getSampleDimensions() throws DataStoreException {
        WorldFileStore store;
        WorldFileStore worldFileStore = store = this.store();
        synchronized (worldFileStore) {
            if (this.sampleDimensions == null) {
                try {
                    ImageReader reader = store.reader();
                    ImageTypeSpecifier type = reader.getRawImageType(this.getImageIndex());
                    SampleDimension[] bands = new SampleDimension[type.getNumBands()];
                    SampleDimension.Builder b = new SampleDimension.Builder();
                    short[] names = ImageUtilities.bandNames(type.getColorModel(), type.getSampleModel());
                    for (int i = 0; i < bands.length; ++i) {
                        short k;
                        InternationalString name = i < names.length && (k = names[i]) != 0 ? Vocabulary.formatInternational(k) : Vocabulary.formatInternational((short)15, (Object)(i + 1));
                        bands[i] = b.setName(name).build();
                        b.clear();
                    }
                    this.sampleDimensions = UnmodifiableArrayList.wrap(bands);
                }
                catch (IOException e) {
                    throw new DataStoreException(e);
                }
            }
            return this.sampleDimensions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GridCoverage read(GridGeometry domain, int ... ranges) throws DataStoreException {
        boolean isFullCoverage = domain == null && ranges == null;
        WorldFileStore store = this.store();
        try {
            WorldFileStore worldFileStore = store;
            synchronized (worldFileStore) {
                if (isFullCoverage && this.fullCoverage != null) {
                    GridCoverage coverage = this.fullCoverage.get();
                    if (coverage != null) {
                        return coverage;
                    }
                    this.fullCoverage = null;
                }
                ImageReader reader = store.reader();
                ImageReadParam param = reader.getDefaultReadParam();
                if (domain == null) {
                    domain = this.gridGeometry;
                } else {
                    GridDerivation gd = this.gridGeometry.derive().rounding(GridRoundingMode.ENCLOSING).subgrid(domain);
                    GridExtent extent = gd.getIntersection();
                    int[] subsampling = gd.getSubsampling();
                    int[] offsets = gd.getSubsamplingOffsets();
                    int subX = subsampling[0];
                    int subY = subsampling[1];
                    Rectangle region = new Rectangle(Math.toIntExact(extent.getLow(0)), Math.toIntExact(extent.getLow(1)), Math.toIntExact(extent.getSize(0)), Math.toIntExact(extent.getSize(1)));
                    domain = gd.build();
                    GridExtent subExtent = domain.getExtent();
                    param.setSourceRegion(region);
                    param.setSourceSubsampling(subX, subY, Math.toIntExact(subExtent.getLow(0) * (long)subX + (long)offsets[0] - (long)region.x), Math.toIntExact(subExtent.getLow(1) * (long)subY + (long)offsets[1] - (long)region.y));
                }
                List<SampleDimension> bands = this.getSampleDimensions();
                if (ranges != null) {
                    ImageTypeSpecifier type = reader.getRawImageType(this.getImageIndex());
                    RangeArgument args = RangeArgument.validate(type.getNumBands(), ranges, this.listeners);
                    if (args.isIdentity()) {
                        ranges = null;
                    } else {
                        bands = UnmodifiableArrayList.wrap(args.select(bands));
                        if (args.hasAllBands || type.getSampleModel() instanceof BandedSampleModel) {
                            ranges = args.getSelectedBands();
                            param.setSourceBands(ranges);
                            param.setDestinationBands(ArraysExt.range(0, ranges.length));
                            ranges = null;
                        }
                    }
                }
                RenderedImage image = reader.readAsRenderedImage(this.getImageIndex(), param);
                if (ranges != null) {
                    image = new ImageProcessor().selectBands(image, ranges);
                }
                GridCoverage2D coverage = new GridCoverage2D(domain, bands, image);
                if (isFullCoverage) {
                    this.fullCoverage = new SoftReference<GridCoverage2D>(coverage);
                }
                return coverage;
            }
        }
        catch (IOException | RuntimeException e) {
            throw this.canNotRead(store.getDisplayName(), domain, e);
        }
    }

    final void setGridCoverage(GridCoverage coverage) {
        this.sampleDimensions = coverage.getSampleDimensions();
        this.gridGeometry = coverage.getGridGeometry();
        this.fullCoverage = new SoftReference<GridCoverage>(coverage);
    }

    final void dispose() {
        if (this.identifier != null) {
            this.store.identifiers.put(this.identifier.tip().toString(), Boolean.FALSE);
        }
        this.store = null;
        this.identifier = null;
        this.sampleDimensions = null;
        this.gridGeometry = null;
        this.fullCoverage = null;
    }
}

