/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Collection;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.code.CI_RoleCode;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.citation.DefaultResponsibleParty;
import org.opengis.metadata.citation.Party;
import org.opengis.metadata.citation.Responsibility;
import org.opengis.metadata.citation.Role;
import org.opengis.metadata.extent.Extent;

@XmlType(name="CI_Responsibility_Type", propOrder={"role", "extent", "party"})
@XmlRootElement(name="CI_Responsibility")
@XmlSeeAlso(value={DefaultResponsibleParty.class})
public class DefaultResponsibility
extends ISOMetadata
implements Responsibility {
    private static final long serialVersionUID = -8290895980682233572L;
    private Role role;
    private Collection<Extent> extents;
    private Collection<Party> parties;

    public DefaultResponsibility() {
    }

    public DefaultResponsibility(Role role, Extent extent, Party party) {
        this.role = role;
        this.extents = this.singleton(extent, Extent.class);
        this.parties = this.singleton(party, Party.class);
    }

    public DefaultResponsibility(Responsibility object) {
        super(object);
        if (object != null) {
            this.role = object.getRole();
            this.extents = this.copyCollection(object.getExtents(), Extent.class);
            this.parties = this.copyCollection(object.getParties(), Party.class);
        }
    }

    public static DefaultResponsibility castOrCopy(Responsibility object) {
        if (object == null || object instanceof DefaultResponsibility) {
            return (DefaultResponsibility)object;
        }
        return new DefaultResponsibility(object);
    }

    @Override
    @XmlElement(name="role", required=true)
    @XmlJavaTypeAdapter(value=CI_RoleCode.Since2014.class)
    public Role getRole() {
        return this.role;
    }

    public void setRole(Role newValue) {
        this.checkWritePermission(this.role);
        this.role = newValue;
    }

    public Collection<Extent> getExtents() {
        this.extents = this.nonNullCollection(this.extents, Extent.class);
        return this.extents;
    }

    public void setExtents(Collection<? extends Extent> newValues) {
        this.extents = this.writeCollection(newValues, this.extents, Extent.class);
    }

    public Collection<Party> getParties() {
        this.parties = this.nonNullCollection(this.parties, Party.class);
        return this.parties;
    }

    public void setParties(Collection<? extends Party> newValues) {
        this.parties = this.writeCollection(newValues, this.parties, Party.class);
    }

    @XmlElement(name="extent")
    private Collection<Extent> getExtent() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getExtents() : null;
    }

    @XmlElement(name="party", required=true)
    private Collection<Party> getParty() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getParties() : null;
    }
}

