/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.lan.LocaleAndCharset;
import org.apache.sis.internal.jaxb.lan.OtherLocales;
import org.apache.sis.internal.jaxb.lan.PT_Locale;
import org.apache.sis.internal.metadata.Dependencies;
import org.apache.sis.metadata.iso.identification.AbstractIdentification;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.util.InternationalString;

@XmlType(name="MD_DataIdentification_Type", propOrder={"languages", "characterSets", "defaultLocale", "otherLocales", "environmentDescription", "supplementalInformation"})
@XmlRootElement(name="MD_DataIdentification")
public class DefaultDataIdentification
extends AbstractIdentification
implements DataIdentification {
    private static final long serialVersionUID = 7302901752833238436L;
    private Map<Locale, Charset> locales;
    private InternationalString environmentDescription;
    private InternationalString supplementalInformation;

    public DefaultDataIdentification() {
    }

    public DefaultDataIdentification(Citation citation, CharSequence abstracts, Locale language, TopicCategory topicCategory) {
        super(citation, abstracts);
        if (language != null) {
            this.locales = this.writeMap(Collections.singletonMap(language, null), null, Locale.class);
        }
        super.setTopicCategories(this.singleton(topicCategory, TopicCategory.class));
    }

    public DefaultDataIdentification(DataIdentification object) {
        super(object);
        if (object != null) {
            this.locales = this.copyMap(object.getLocalesAndCharsets(), Locale.class);
            this.environmentDescription = object.getEnvironmentDescription();
            this.supplementalInformation = object.getSupplementalInformation();
        }
    }

    public static DefaultDataIdentification castOrCopy(DataIdentification object) {
        if (object == null || object instanceof DefaultDataIdentification) {
            return (DefaultDataIdentification)object;
        }
        return new DefaultDataIdentification(object);
    }

    @Override
    public Map<Locale, Charset> getLocalesAndCharsets() {
        this.locales = this.nonNullMap(this.locales, Locale.class);
        return this.locales;
    }

    public void setLocalesAndCharsets(Map<? extends Locale, ? extends Charset> newValues) {
        this.locales = this.writeMap(newValues, this.locales, Locale.class);
    }

    @Override
    @Deprecated(since="1.0")
    @Dependencies(value={"getLocalesAndCharsets"})
    @XmlElement(name="language", namespace="http://www.isotc211.org/2005/gmd")
    public Collection<Locale> getLanguages() {
        return FilterByVersion.LEGACY_METADATA.accept() ? LocaleAndCharset.getLanguages(this.getLocalesAndCharsets()) : null;
    }

    @Deprecated(since="1.0")
    public void setLanguages(Collection<? extends Locale> newValues) {
        this.setLocalesAndCharsets(LocaleAndCharset.setLanguages(this.getLocalesAndCharsets(), newValues));
    }

    @Override
    @Deprecated(since="1.0")
    @Dependencies(value={"getLocalesAndCharsets"})
    @XmlElement(name="characterSet", namespace="http://www.isotc211.org/2005/gmd")
    public Collection<Charset> getCharacterSets() {
        return FilterByVersion.LEGACY_METADATA.accept() ? LocaleAndCharset.getCharacterSets(this.getLocalesAndCharsets()) : null;
    }

    @Deprecated(since="1.0")
    public void setCharacterSets(Collection<? extends Charset> newValues) {
        this.setLocalesAndCharsets(LocaleAndCharset.setCharacterSets(this.getLocalesAndCharsets(), newValues));
    }

    @Override
    @XmlElement(name="environmentDescription")
    public InternationalString getEnvironmentDescription() {
        return this.environmentDescription;
    }

    public void setEnvironmentDescription(InternationalString newValue) {
        this.checkWritePermission(this.environmentDescription);
        this.environmentDescription = newValue;
    }

    @Override
    @XmlElement(name="supplementalInformation")
    public InternationalString getSupplementalInformation() {
        return this.supplementalInformation;
    }

    public void setSupplementalInformation(InternationalString newValue) {
        this.checkWritePermission(this.supplementalInformation);
        this.supplementalInformation = newValue;
    }

    @XmlElement(name="defaultLocale")
    private PT_Locale getDefaultLocale() {
        return FilterByVersion.CURRENT_METADATA.accept() ? PT_Locale.first(this.getLocalesAndCharsets()) : null;
    }

    private void setDefaultLocale(PT_Locale newValue) {
        this.setLocalesAndCharsets(OtherLocales.setFirst(this.locales, newValue));
    }

    @XmlElement(name="otherLocale")
    private Collection<PT_Locale> getOtherLocales() {
        return FilterByVersion.CURRENT_METADATA.accept() ? OtherLocales.filter(this.getLocalesAndCharsets()) : null;
    }
}

