/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v311;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.geotoolkit.gml.xml.v311.AbstractRingPropertyType;
import org.geotoolkit.gml.xml.v311.AbstractRingType;
import org.geotoolkit.gml.xml.v311.AbstractSurfacePatchType;
import org.geotoolkit.gml.xml.v311.ObjectFactory;
import org.geotoolkit.gml.xml.v311.SurfaceInterpolationType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="PolygonPatchType", propOrder={"exterior", "interior"})
public class PolygonPatchType
extends AbstractSurfacePatchType {
    @XmlElementRef(name="exterior", namespace="http://www.opengis.net/gml", type=JAXBElement.class)
    private JAXBElement<AbstractRingPropertyType> exterior;
    @XmlElementRef(name="interior", namespace="http://www.opengis.net/gml", type=JAXBElement.class)
    private List<JAXBElement<AbstractRingPropertyType>> interior;
    @XmlAttribute
    private SurfaceInterpolationType interpolation;

    PolygonPatchType() {
    }

    public PolygonPatchType(SurfaceInterpolationType interpolation, AbstractRingType exterior, List<? extends AbstractRingType> interiors) {
        this.interpolation = interpolation;
        ObjectFactory factory = new ObjectFactory();
        if (exterior != null) {
            this.exterior = factory.createExterior(new AbstractRingPropertyType(exterior));
        }
        if (interiors != null) {
            this.interior = new ArrayList<JAXBElement<AbstractRingPropertyType>>();
            for (AbstractRingType abstractRingType : interiors) {
                this.interior.add(factory.createInterior(new AbstractRingPropertyType(abstractRingType)));
            }
        }
    }

    public JAXBElement<AbstractRingPropertyType> getJbExterior() {
        return this.exterior;
    }

    public void setJbExterior(JAXBElement<AbstractRingPropertyType> value) {
        this.exterior = value;
    }

    public AbstractRingPropertyType getExterior() {
        if (this.exterior != null) {
            return this.exterior.getValue();
        }
        return null;
    }

    public void setExterior(AbstractRingPropertyType value) {
        ObjectFactory factory = new ObjectFactory();
        this.exterior = factory.createExterior(value);
    }

    public List<JAXBElement<AbstractRingPropertyType>> getJbInterior() {
        if (this.interior == null) {
            this.interior = new ArrayList<JAXBElement<AbstractRingPropertyType>>();
        }
        return this.interior;
    }

    public void setJbInterior(List<JAXBElement<AbstractRingPropertyType>> interior) {
        this.interior = interior;
    }

    public List<AbstractRingPropertyType> getInterior() {
        if (this.interior == null) {
            this.interior = new ArrayList<JAXBElement<AbstractRingPropertyType>>();
        }
        ArrayList<AbstractRingPropertyType> result = new ArrayList<AbstractRingPropertyType>();
        for (JAXBElement<AbstractRingPropertyType> jb : this.interior) {
            result.add(jb.getValue());
        }
        return result;
    }

    public void setInterior(List<AbstractRingPropertyType> interior) {
        if (interior != null) {
            if (this.interior == null) {
                this.interior = new ArrayList<JAXBElement<AbstractRingPropertyType>>();
            }
            ObjectFactory factory = new ObjectFactory();
            for (AbstractRingPropertyType jb : interior) {
                this.interior.add(factory.createInterior(jb));
            }
        } else {
            this.interior = null;
        }
    }

    public void setInterior(AbstractRingPropertyType interior) {
        if (interior != null) {
            if (this.interior == null) {
                this.interior = new ArrayList<JAXBElement<AbstractRingPropertyType>>();
            }
            ObjectFactory factory = new ObjectFactory();
            this.interior.add(factory.createInterior(interior));
        }
    }

    public SurfaceInterpolationType getInterpolation() {
        return this.interpolation;
    }

    public void setInterpolation(SurfaceInterpolationType value) {
        this.interpolation = value;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof PolygonPatchType) {
            PolygonPatchType that = (PolygonPatchType)object;
            return Objects.equals(this.getExterior(), that.getExterior()) && Objects.equals(this.getInterior(), that.getInterior()) && Objects.equals((Object)this.interpolation, (Object)that.interpolation);
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.getExterior() != null ? this.getExterior().hashCode() : 0);
        hash = 37 * hash + (this.getInterior() != null ? this.getInterior().hashCode() : 0);
        hash = 37 * hash + (this.interpolation != null ? this.interpolation.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[PolygonPatchType]").append("\n");
        if (this.interpolation != null) {
            sb.append("interpolation:").append((Object)this.interpolation).append('\n');
        }
        if (this.interior != null) {
            sb.append("interior:").append('\n');
            for (JAXBElement<AbstractRingPropertyType> inte : this.interior) {
                sb.append(inte.getValue()).append('\n');
            }
        }
        if (this.exterior != null) {
            sb.append("exterior:").append(this.exterior.getValue()).append('\n');
        }
        return sb.toString();
    }
}

