/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.io;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInput;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.sis.util.CharSequences;
import org.geotoolkit.io.LineReader;
import org.geotoolkit.lang.Static;

public final class LineReaders
extends Static {
    private LineReaders() {
    }

    public static LineReader wrap(String text) {
        return LineReaders.wrap(Arrays.asList(CharSequences.splitOnEOL(text)));
    }

    public static LineReader wrap(Iterable<?> collection) {
        final Iterator<?> it = collection.iterator();
        return new LineReader(){

            @Override
            public String readLine() throws IOException {
                try {
                    return it.hasNext() ? it.next().toString() : null;
                }
                catch (RuntimeException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    throw e;
                }
            }

            @Override
            public void close() throws IOException {
                if (it instanceof Closeable) {
                    ((Closeable)((Object)it)).close();
                }
            }
        };
    }

    public static LineReader wrap(final DataInput input) {
        if (input instanceof LineReader) {
            return (LineReader)((Object)input);
        }
        return new LineReader(){

            @Override
            public String readLine() throws IOException {
                return input.readLine();
            }

            @Override
            public void close() throws IOException {
                if (input instanceof Closeable) {
                    ((Closeable)((Object)input)).close();
                }
            }
        };
    }

    public static LineReader wrap(Reader reader) {
        if (reader instanceof LineReader) {
            return (LineReader)((Object)reader);
        }
        if (reader instanceof BufferedReader) {
            final BufferedReader input = (BufferedReader)reader;
            return new LineReader(){

                @Override
                public String readLine() throws IOException {
                    return input.readLine();
                }

                @Override
                public void close() throws IOException {
                    input.close();
                }
            };
        }
        return new Buffered(reader);
    }

    private static final class Buffered
    extends BufferedReader
    implements LineReader {
        Buffered(Reader in) {
            super(in);
        }
    }
}

