/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.math;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Classes;

public class Polynom
implements Serializable {
    private static final long serialVersionUID = 6825019711186108990L;
    private final double[] c;
    private transient double[] roots;

    public Polynom(double[] c) {
        int n = c.length;
        while (n != 0 && c[--n] == 0.0) {
        }
        if (n == 0) {
            this.c = ArraysExt.EMPTY_DOUBLE;
        } else {
            this.c = new double[n];
            System.arraycopy(c, 0, this.c, 0, n);
        }
    }

    public final double y(double x) {
        double sum = 0.0;
        int i = this.c.length;
        while (--i >= 0) {
            sum = sum * x + this.c[i];
        }
        return sum;
    }

    private static double[] quadraticRoots(double c0, double c1, double c2) {
        double d = c1 * c1 - 4.0 * c2 * c0;
        if (d > 0.0) {
            d = Math.sqrt(d);
            if (c1 < 0.0) {
                d = -d;
            }
            double q = 0.5 * (d - c1);
            return new double[]{q / c2, q != 0.0 ? c0 / q : -0.5 * (d + c1) / c2};
        }
        if (d == 0.0) {
            return new double[]{-c1 / (2.0 * c2)};
        }
        return ArraysExt.EMPTY_DOUBLE;
    }

    private static double[] cubicRoots(double c0, double c1, double c2, double c3) {
        double Q = ((c2 /= c3) * c2 - 3.0 * (c1 /= c3)) / 9.0;
        double R = (2.0 * c2 * c2 * c2 - 9.0 * c2 * c1 + 27.0 * (c0 /= c3)) / 54.0;
        double Qcubed = Q * Q * Q;
        double d = Qcubed - R * R;
        c2 /= 3.0;
        if (d >= 0.0) {
            double theta = Math.acos(R / Math.sqrt(Qcubed)) / 3.0;
            double scale = -2.0 * Math.sqrt(Q);
            double[] roots = new double[]{scale * Math.cos(theta) - c2, scale * Math.cos(theta + 2.0943951023931953) - c2, scale * Math.cos(theta + 4.1887902047863905) - c2};
            assert (Math.abs(roots[0] * roots[1] * roots[2] + c0) < 1.0E-6);
            assert (Math.abs(roots[0] + roots[1] + roots[2] + c2 * 3.0) < 1.0E-6);
            assert (Math.abs(roots[0] * roots[1] + roots[0] * roots[2] + roots[1] * roots[2] - c1) < 1.0E-6);
            return roots;
        }
        double e = Math.cbrt(Math.sqrt(-d) + Math.abs(R));
        if (R > 0.0) {
            e = -e;
        }
        return new double[]{e + Q / e - c2};
    }

    public double[] roots() {
        if (this.roots == null) {
            this.roots = Polynom.roots(this.c);
        }
        return (double[])this.roots.clone();
    }

    public static double[] roots(double[] c) {
        int n = c.length;
        while (n != 0 && c[--n] == 0.0) {
        }
        switch (n) {
            case 0: {
                return ArraysExt.EMPTY_DOUBLE;
            }
            case 1: {
                return new double[]{-c[0] / c[1]};
            }
            case 2: {
                return Polynom.quadraticRoots(c[0], c[1], c[2]);
            }
            case 3: {
                return Polynom.cubicRoots(c[0], c[1], c[2], c[3]);
            }
        }
        throw new UnsupportedOperationException(String.valueOf(n));
    }

    public int hashCode() {
        return Arrays.hashCode(this.c) ^ 0x4E49823E;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            Polynom that = (Polynom)object;
            return Arrays.equals(this.c, that.c);
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(Classes.getShortClassName(this));
        buffer.append('[');
        for (int i = 0; i < this.c.length; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.c[i]);
        }
        return buffer.append(']').toString();
    }
}

