/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.temporal.reference;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.SimpleInternationalString;
import org.geotoolkit.temporal.object.DefaultCalendarDate;
import org.geotoolkit.temporal.object.DefaultDateAndTime;
import org.geotoolkit.temporal.object.DefaultJulianDate;
import org.geotoolkit.temporal.reference.DefaultTemporalCoordinateSystem;
import org.geotoolkit.temporal.reference.DefaultTemporalReferenceSystem;
import org.opengis.temporal.Calendar;
import org.opengis.temporal.CalendarDate;
import org.opengis.temporal.CalendarEra;
import org.opengis.temporal.Clock;
import org.opengis.temporal.ClockTime;
import org.opengis.temporal.DateAndTime;
import org.opengis.temporal.JulianDate;

@XmlType(name="TimeCalendar_Type", propOrder={"referenceFrame"})
@XmlRootElement(name="TimeCalendar")
public class DefaultCalendar
extends DefaultTemporalReferenceSystem
implements Calendar {
    private Collection<CalendarEra> referenceFrame;
    private Clock timeBasis;

    public DefaultCalendar(Map<String, ?> properties, Collection<CalendarEra> referenceFrame, Clock timeBasis) {
        super(properties);
        ArgumentChecks.ensureNonNull("referenceFrame", referenceFrame);
        this.referenceFrame = referenceFrame;
        this.timeBasis = timeBasis;
    }

    private DefaultCalendar() {
    }

    private DefaultCalendar(Calendar object) {
        super(object);
        if (object != null) {
            this.referenceFrame = object.getReferenceFrame();
            ArgumentChecks.ensureNonNull("referenceFrame", this.referenceFrame);
            this.timeBasis = object.getTimeBasis();
        }
    }

    public static DefaultCalendar castOrCopy(Calendar object) {
        if (object == null || object instanceof DefaultCalendar) {
            return (DefaultCalendar)object;
        }
        return new DefaultCalendar(object);
    }

    @Override
    public JulianDate dateTrans(CalendarDate calDate, ClockTime time) {
        if (calDate != null && time != null) {
            DefaultDateAndTime dateAndTime = new DefaultDateAndTime(this, calDate.getIndeterminatePosition(), calDate.getCalendarEraName(), calDate.getCalendarDate(), time.getClockTime());
            return this.dateTrans(dateAndTime);
        }
        GregorianCalendar gc = new GregorianCalendar(-4713, 1, 1);
        gc.set(0, 0);
        int julianGre = 588829;
        Number coordinateValue = 0;
        HashMap<String, NamedIdentifier> properties = new HashMap<String, NamedIdentifier>();
        NamedIdentifier name = new NamedIdentifier(null, new SimpleInternationalString("Julian calendar"));
        Unit<Time> interval = Units.DAY;
        properties.put("name", name);
        DefaultTemporalCoordinateSystem refSystem = new DefaultTemporalCoordinateSystem(properties, interval, gc.getTime());
        if (calDate != null) {
            int[] cal = calDate.getCalendarDate();
            int year = 0;
            int month = 0;
            int day = 0;
            if (cal.length > 3) {
                throw new IllegalArgumentException("The CalendarDate integer array is malformed ! see ISO 8601 format.");
            }
            year = cal[0];
            if (cal.length > 0) {
                month = cal[1];
            }
            if (cal.length > 1) {
                day = cal[2];
            }
            int julianYear = year;
            if (year < 0) {
                ++julianYear;
            }
            int julianMonth = month;
            if (month > 2) {
                ++julianMonth;
            } else {
                --julianYear;
                julianMonth += 13;
            }
            double julian = Math.floor(365.25 * (double)julianYear) + Math.floor(30.6001 * (double)julianMonth) + (double)day + 1720995.0;
            if (day + 31 * (month + 12 * year) >= 588829) {
                int ja = (int)(0.01 * (double)julianYear);
                julian += (double)(2 - ja) + 0.25 * (double)ja;
            }
            coordinateValue = Math.floor(julian);
            DefaultJulianDate response = new DefaultJulianDate(refSystem, null, coordinateValue);
            return response;
        }
        if (time != null) {
            Number[] clk = time.getClockTime();
            Number hour = 0;
            Number minute = 0;
            Number second = 0;
            if (clk.length > 3) {
                throw new IllegalArgumentException("The ClockTime Number array is malformed ! see ISO 8601 format.");
            }
            hour = clk[0];
            if (clk.length > 0) {
                minute = clk[1];
            }
            if (clk.length > 1) {
                second = clk[2];
            }
            double julian = (hour.doubleValue() - 12.0) / 24.0 + minute.doubleValue() / 1440.0 + second.doubleValue() / 86400.0;
            coordinateValue = julian;
            DefaultJulianDate response = new DefaultJulianDate(refSystem, null, coordinateValue);
            return response;
        }
        throw new IllegalArgumentException("the both CalendarDate and ClockTime cannot be null !");
    }

    public JulianDate dateTrans(DateAndTime dateAndTime) {
        GregorianCalendar gc = new GregorianCalendar(-4713, 1, 1);
        gc.set(0, 0);
        int julianGre = 588829;
        HashMap<String, NamedIdentifier> properties = new HashMap<String, NamedIdentifier>();
        NamedIdentifier name = new NamedIdentifier(null, new SimpleInternationalString("Julian calendar"));
        properties.put("name", name);
        DefaultTemporalCoordinateSystem refSystem = new DefaultTemporalCoordinateSystem(properties, Units.DAY, gc.getTime());
        Number coordinateValue = 0;
        int year = 0;
        int month = 0;
        int day = 0;
        Number hour = 0;
        Number minute = 0;
        Number second = 0;
        if (dateAndTime == null) {
            throw new IllegalArgumentException("The DateAndTime cannot be null ! ");
        }
        if (dateAndTime.getCalendarDate() != null) {
            int[] cal = dateAndTime.getCalendarDate();
            if (cal.length > 3) {
                throw new IllegalArgumentException("The CalendarDate integer array is malformed ! see ISO 8601 format.");
            }
            year = cal[0];
            if (cal.length > 0) {
                month = cal[1];
            }
            if (cal.length > 1) {
                day = cal[2];
            }
            int julianYear = year;
            if (year < 0) {
                ++julianYear;
            }
            int julianMonth = month;
            if (month > 2) {
                ++julianMonth;
            } else {
                --julianYear;
                julianMonth += 13;
            }
            double julian = Math.floor(365.25 * (double)julianYear) + Math.floor(30.6001 * (double)julianMonth) + (double)day + 1720995.0;
            if (day + 31 * (month + 12 * year) >= 588829) {
                int ja = (int)(0.01 * (double)julianYear);
                julian += (double)(2 - ja) + 0.25 * (double)ja;
            }
            coordinateValue = Math.floor(julian);
        }
        if (dateAndTime.getClockTime() != null) {
            Number[] clk = dateAndTime.getClockTime();
            if (clk.length > 3) {
                throw new IllegalArgumentException("The ClockTime Number array is malformed ! see ISO 8601 format.");
            }
            hour = clk[0];
            if (clk.length > 0) {
                minute = clk[1];
            }
            if (clk.length > 1) {
                second = clk[2];
            }
            double julian = (hour.doubleValue() - 12.0) / 24.0 + minute.doubleValue() / 1440.0 + second.doubleValue() / 86400.0;
            coordinateValue = ((Number)coordinateValue).doubleValue() + julian;
        }
        DefaultJulianDate response = new DefaultJulianDate(refSystem, null, coordinateValue);
        return response;
    }

    @Override
    public CalendarDate julTrans(JulianDate jdt) {
        if (jdt == null) {
            return null;
        }
        DefaultCalendarDate response = null;
        int JGREG = 588829;
        int ja = jdt.getCoordinateValue().intValue();
        if (ja >= JGREG) {
            int jalpha = (int)(((double)(ja - 1867216) - 0.25) / 36524.25);
            ja = ja + 1 + jalpha - jalpha / 4;
        }
        int jb = ja + 1524;
        int jc = (int)(6680.0 + ((double)(jb - 2439870) - 122.1) / 365.25);
        int jd = 365 * jc + jc / 4;
        int je = (int)((double)(jb - jd) / 30.6001);
        int day = jb - jd - (int)(30.6001 * (double)je);
        int month = je - 1;
        if (month > 12) {
            month -= 12;
        }
        int year = jc - 4715;
        if (month > 2) {
            --year;
        }
        if (year <= 0) {
            // empty if block
        }
        int[] calendarDate = new int[]{--year, month, day};
        response = new DefaultCalendarDate(this, null, null, calendarDate);
        return response;
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object instanceof Calendar) {
            Calendar that = (Calendar)object;
            return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getDomainOfValidity(), that.getDomainOfValidity()) && Objects.equals(this.referenceFrame, that.getReferenceFrame()) && Objects.equals(this.timeBasis, that.getTimeBasis());
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        int hash = this.getName().hashCode() + this.getDomainOfValidity().hashCode();
        hash = 42 * hash + (this.timeBasis != null ? this.timeBasis.hashCode() : 0);
        hash = 37 * hash + (this.referenceFrame != null ? this.referenceFrame.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder(super.toString()).append('\n').append("Calendar : ").append('\n');
        if (this.timeBasis != null) {
            s2.append("clock:").append(this.timeBasis).append('\n');
        }
        if (this.referenceFrame != null) {
            s2.append("basis:").append(this.referenceFrame).append('\n');
        }
        return super.toString().concat("\n").concat(s2.toString());
    }

    @Override
    @XmlElement(name="referenceFrame", required=true)
    public Collection<CalendarEra> getReferenceFrame() {
        return this.referenceFrame;
    }

    @Override
    public Clock getTimeBasis() {
        return this.timeBasis;
    }
}

