/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.geomatics.gml;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.net.URI;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.referencing.CRS;
import org.apache.sis.xml.MarshallerPool;
import org.geotoolkit.geometry.jts.JTS;
import org.geotoolkit.gml.xml.AbstractCurveSegment;
import org.geotoolkit.gml.xml.AbstractGeometry;
import org.geotoolkit.gml.xml.Curve;
import org.geotoolkit.gml.xml.GMLMarshallerPool;
import org.geotoolkit.gml.xml.v321.AngleType;
import org.geotoolkit.gml.xml.v321.ArcByCenterPointType;
import org.geotoolkit.gml.xml.v321.LengthType;
import org.geotoolkit.temporal.factory.DefaultTemporalFactory;
import org.locationtech.jts.algorithm.ConvexHull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.opengis.cite.geomatics.GeodesyUtils;
import org.opengis.cite.geomatics.gml.CurveCoordinateListFactory;
import org.opengis.cite.geomatics.gml.GeometryCoordinateList;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Period;
import org.opengis.temporal.TemporalGeometricPrimitive;
import org.opengis.util.FactoryException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GmlUtils {
    public static final String SRS_NAME = "srsName";
    public static final String GML_NS = "http://www.opengis.net/gml/3.2";
    static final int TOTAL_ARC_POINTS = 5;
    private static final Unmarshaller GML_UNMARSHALLER = GmlUtils.initGmlUnmarshaller();

    private static Unmarshaller initGmlUnmarshaller() {
        Unmarshaller unmarshaller = null;
        try {
            MarshallerPool pool = GMLMarshallerPool.getInstance();
            unmarshaller = pool.acquireUnmarshaller();
        }
        catch (JAXBException je) {
            throw new RuntimeException(je);
        }
        return unmarshaller;
    }

    public static void inferPointsOnArc(AbstractCurveSegment segment, CoordinateReferenceSystem crs, List<Coordinate> coordList) {
        ArcByCenterPointType arc = (ArcByCenterPointType)segment;
        List<Double> centerCoords = null != arc.getPos() ? arc.getPos().getValue() : arc.getPosList().getValue();
        GeneralDirectPosition center = new GeneralDirectPosition(crs);
        center.setCoordinate(centerCoords.get(0), centerCoords.get(1));
        AngleType startAngle = arc.getStartAngle();
        AngleType endAngle = arc.getEndAngle();
        if (null == startAngle) {
            startAngle = new AngleType();
            startAngle.setValue(0.0);
            endAngle = new AngleType();
            endAngle.setValue(360.0);
        }
        if (endAngle.getValue() == 0.0f) {
            endAngle.setValue(360.0);
        }
        LengthType radius = arc.getRadius();
        double radiusInMeters = GmlUtils.lengthInMeters(radius);
        DirectPosition startPos = GeodesyUtils.calculateDestination(center, startAngle.getValue(), radiusInMeters);
        coordList.add(new Coordinate(startPos.getOrdinate(0), startPos.getOrdinate(1)));
        double delta = (endAngle.getValue() - startAngle.getValue()) / 4.0f;
        for (int i = 1; i < 4; ++i) {
            double angle = (double)startAngle.getValue() + delta * (double)i;
            DirectPosition arcPos = GeodesyUtils.calculateDestination(center, angle, radiusInMeters);
            coordList.add(new Coordinate(arcPos.getOrdinate(0), arcPos.getOrdinate(1)));
        }
        DirectPosition endPos = GeodesyUtils.calculateDestination(center, endAngle.getValue(), radiusInMeters);
        coordList.add(new Coordinate(endPos.getOrdinate(0), endPos.getOrdinate(1)));
    }

    public static Geometry computeConvexHull(AbstractGeometry gmlGeom) {
        GeometryCoordinateList coordSet = new GeometryCoordinateList();
        Coordinate[] pointSet = coordSet.getCoordinateList(gmlGeom);
        ConvexHull hull = new ConvexHull(pointSet, new GeometryFactory());
        return hull.getConvexHull();
    }

    public static void setSrsNameOnCollectionMembers(Node ... geometryNodes) {
        for (Node geomNode : geometryNodes) {
            NodeList members;
            Element geom = (Element)geomNode;
            String geomType = geom.getLocalName();
            String srsName = geom.getAttribute(SRS_NAME);
            if (!geomType.startsWith("Multi") || srsName.isEmpty()) continue;
            String memberType = geomType.substring(5).toLowerCase();
            String expr = String.format("gml:%sMember/* | gml:%<sMembers/*", memberType);
            XPath xpath = XPathFactory.newInstance().newXPath();
            xpath.setNamespaceContext(new GmlNamespaceContext());
            try {
                members = (NodeList)xpath.evaluate(expr, geom, XPathConstants.NODESET);
            }
            catch (XPathExpressionException xpe) {
                throw new RuntimeException(xpe);
            }
            for (int i = 0; i < members.getLength(); ++i) {
                Element member = (Element)members.item(i);
                if (!member.getAttribute(SRS_NAME).isEmpty()) continue;
                member.setAttribute(SRS_NAME, srsName);
            }
        }
    }

    public static double lengthInMeters(LengthType length) {
        double lengthInMeters;
        String symbol;
        String uom = length.getUomStr();
        String string = symbol = uom.indexOf(35) >= 0 ? uom.substring(uom.indexOf(35) + 1) : uom;
        if (symbol.equals("m")) {
            lengthInMeters = length.getValue();
        } else if (symbol.equals("km")) {
            lengthInMeters = length.getValue() * 1000.0f;
        } else if (symbol.equals("M") | symbol.equals("NM") | symbol.equals("[nmi_i]")) {
            lengthInMeters = (double)length.getValue() * 1852.0;
        } else if (symbol.equals("mi")) {
            lengthInMeters = (double)length.getValue() * 1609.34;
        } else {
            throw new RuntimeException("Unrecognized unit of length: " + uom);
        }
        return lengthInMeters;
    }

    public static void extractCoordinatesFromPosList(List<Double> tupleList, int crsDim, List<Coordinate> coords) {
        if (null == tupleList || tupleList.isEmpty()) {
            return;
        }
        Double[] values = tupleList.toArray(new Double[0]);
        for (int i = 0; i < values.length; i += crsDim) {
            coords.add(new Coordinate(values[i], values[i + 1]));
        }
    }

    public static int minCurveSegmentLength(String segmentTypeName) {
        int minLength = 2;
        if (segmentTypeName.endsWith("ByCenterPoint")) {
            minLength = 1;
        } else if (segmentTypeName.equals("ArcString") || segmentTypeName.equals("Arc") || segmentTypeName.equals("Circle")) {
            minLength = 3;
        }
        return minLength;
    }

    public static String findCRSReference(Element geom) {
        String srsName;
        String expr = "./ancestor-or-self::*[@srsName][1]/@srsName";
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            srsName = (String)xpath.evaluate(expr, geom, XPathConstants.STRING);
            if (srsName.isEmpty()) {
                NodeNamespaceContext nsContext = new NodeNamespaceContext(geom);
                String gmlPrefix = nsContext.getPrefix(GML_NS);
                expr = String.format("./ancestor::*[%s:boundedBy][1]/%1$s:boundedBy/%1$s:Envelope/@srsName", gmlPrefix);
                xpath.setNamespaceContext(nsContext);
                srsName = (String)xpath.evaluate(expr, geom, XPathConstants.STRING);
                if (srsName.isEmpty()) {
                    expr = String.format("(./%s:posList | ./%1$s:pos)[1]/@srsName", gmlPrefix);
                    srsName = (String)xpath.evaluate(expr, geom, XPathConstants.STRING);
                }
            }
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        if (!srsName.isEmpty()) {
            geom.setAttribute(SRS_NAME, srsName);
        }
        return srsName;
    }

    public static boolean hasChildElement(Element elem, String namespace, String localName) {
        return elem.getElementsByTagNameNS(namespace, localName).getLength() > 0;
    }

    public static AbstractGeometry unmarshalGMLGeometry(URI uriRef) throws JAXBException {
        if (!uriRef.isAbsolute()) {
            throw new IllegalArgumentException("Not an absolute URI: " + uriRef);
        }
        StreamSource source = new StreamSource(uriRef.toString());
        return GmlUtils.unmarshalGMLGeometry(source);
    }

    public static AbstractGeometry unmarshalGMLGeometry(Source source) throws JAXBException {
        JAXBElement gmlGeom = (JAXBElement)GML_UNMARSHALLER.unmarshal(source);
        return (AbstractGeometry)gmlGeom.getValue();
    }

    public static LineString buildLineString(Curve gmlCurve) {
        CurveCoordinateListFactory coordFactory = new CurveCoordinateListFactory();
        List<Coordinate> coordList = coordFactory.createCoordinateList(gmlCurve);
        GeodesyUtils.removeConsecutiveDuplicates(coordList, 1.0);
        Coordinate[] coords = coordList.toArray(new Coordinate[coordList.size()]);
        GeometryFactory jtsFactory = new GeometryFactory();
        LineString line = jtsFactory.createLineString(coords);
        CoordinateReferenceSystem crs = null;
        try {
            crs = CRS.forCode(GeodesyUtils.convertSRSNameToURN(gmlCurve.getSrsName()));
            JTS.setCRS(line, crs);
        }
        catch (FactoryException e) {
            throw new RuntimeException(e.getMessage());
        }
        return line;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TemporalGeometricPrimitive gmlToTemporalGeometricPrimitive(Element gmlTime) {
        void var4_11;
        ArrayList<ZonedDateTime> instants = new ArrayList<ZonedDateTime>();
        String frame = gmlTime.getAttribute("frame");
        if (gmlTime.getLocalName().equals("TimeInstant")) {
            Element timePosition = (Element)gmlTime.getElementsByTagNameNS(GML_NS, "timePosition").item(0);
            if (!timePosition.getAttribute("frame").isEmpty()) {
                frame = timePosition.getAttribute("frame");
            }
            if (!frame.isEmpty() && !frame.contains("8601")) throw new RuntimeException("Unsupported temporal reference frame: " + frame);
            try {
                ZonedDateTime zonedDateTime = ZonedDateTime.parse(timePosition.getTextContent(), DateTimeFormatter.ISO_DATE_TIME);
                instants.add(zonedDateTime);
            }
            catch (DateTimeParseException dateTimeParseException) {
                throw new RuntimeException("Not an ISO instant: " + timePosition.getTextContent());
            }
        } else {
            Element beginPosition = (Element)gmlTime.getElementsByTagNameNS(GML_NS, "beginPosition").item(0);
            instants.add(ZonedDateTime.parse(beginPosition.getTextContent(), DateTimeFormatter.ISO_DATE_TIME));
            Element element = (Element)gmlTime.getElementsByTagNameNS(GML_NS, "endPosition").item(0);
            instants.add(ZonedDateTime.parse(element.getTextContent(), DateTimeFormatter.ISO_DATE_TIME));
        }
        DefaultTemporalFactory tmFactory = new DefaultTemporalFactory();
        Object var4_8 = null;
        if (instants.size() == 1) {
            Instant instant = tmFactory.createInstant(Date.from(((ZonedDateTime)instants.get(0)).toInstant()));
            return var4_11;
        } else {
            Instant beginInstant = tmFactory.createInstant(Date.from(((ZonedDateTime)instants.get(0)).toInstant()));
            Instant endInstant = tmFactory.createInstant(Date.from(((ZonedDateTime)instants.get(1)).toInstant()));
            Period period = tmFactory.createPeriod(beginInstant, endInstant);
        }
        return var4_11;
    }

    public static Element convertToMultiType(Node geomNode) {
        String typeName = "Multi" + geomNode.getLocalName();
        return GmlUtils.convertGeomNode(typeName, geomNode);
    }

    public static Element handleAbstractSurfacePatch(Node geomNode) {
        String typeName = geomNode.getLocalName();
        return GmlUtils.convertGeomNode(typeName, geomNode);
    }

    public static boolean checkForAbstractSurfacePatchTypes(Node node) {
        boolean result = false;
        if (node.getLocalName().contains("Multi")) {
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                result = result || GmlUtils.checkForAbstractSurfacePatchTypesRecursively(childNode);
            }
        }
        return result;
    }

    private static Element convertGeomNode(String typeName, Node geomNode) {
        String geomMemberType = geomNode.getLocalName().equalsIgnoreCase("Curve") ? "curveMember" : "surfaceMember";
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e.getMessage());
        }
        Document document = db.newDocument();
        Element multiGeom = document.createElementNS(geomNode.getNamespaceURI(), typeName);
        Element memberType = document.createElementNS(geomNode.getNamespaceURI(), geomMemberType);
        Node importNode = document.importNode(geomNode, true);
        NamedNodeMap attributes = geomNode.getAttributes();
        String srsName = null;
        Integer i = 0;
        while (i < attributes.getLength()) {
            Object attributeNamespace = attributes.item(i).getNamespaceURI();
            String attributeName = attributes.item(i).getLocalName();
            String attributeValue = attributes.item(i).getNodeValue();
            multiGeom.setAttributeNS((String)attributeNamespace, attributeName, attributeValue);
            if (attributeName.equalsIgnoreCase(SRS_NAME)) {
                srsName = GeodesyUtils.convertSRSNameToURN(attributeValue);
            }
            attributeNamespace = i;
            i = i + 1;
        }
        Element newGeomNode = null;
        newGeomNode = typeName.equalsIgnoreCase("MultiCurve") ? document.createElementNS(geomNode.getNamespaceURI(), "LineString") : document.createElementNS(geomNode.getNamespaceURI(), "Polygon");
        newGeomNode.setAttribute(SRS_NAME, srsName);
        NodeList nodeList = importNode.getChildNodes();
        Integer i2 = 0;
        while (i2 < nodeList.getLength()) {
            Node currentNode = nodeList.item(i2);
            if (currentNode.getNodeType() == 1) {
                if (typeName.equalsIgnoreCase("MultiCurve")) {
                    if (currentNode.getLocalName().equalsIgnoreCase("posList")) {
                        importNode = currentNode;
                        break;
                    }
                } else if (currentNode.getLocalName().equalsIgnoreCase("exterior")) {
                    importNode = currentNode;
                    break;
                }
                nodeList = currentNode.getChildNodes();
                i2 = -1;
            }
            Integer n = i2;
            i2 = i2 + 1;
        }
        newGeomNode.appendChild(importNode);
        memberType.appendChild(newGeomNode);
        multiGeom.appendChild(memberType);
        return multiGeom;
    }

    private static boolean checkForAbstractSurfacePatchTypesRecursively(Node node) {
        boolean result = false;
        if (node.getNodeType() == 3) {
            return false;
        }
        if (node.getLocalName().contains("patch")) {
            return true;
        }
        if (!node.hasChildNodes()) {
            return false;
        }
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            result = result || GmlUtils.checkForAbstractSurfacePatchTypesRecursively(childNode);
        }
        return result;
    }

    public static class GmlNamespaceContext
    implements NamespaceContext {
        @Override
        public String getNamespaceURI(String prefix) {
            String nsName = prefix.equals("gml") ? GmlUtils.GML_NS : "";
            return nsName;
        }

        @Override
        public String getPrefix(String namespaceURI) {
            String prefix = null;
            if (namespaceURI.equals(GmlUtils.GML_NS)) {
                prefix = "gml";
            }
            return prefix;
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceURI) {
            return null;
        }
    }

    public static class NodeNamespaceContext
    implements NamespaceContext {
        private Node sourceNode;

        public NodeNamespaceContext(Node node) {
            this.sourceNode = node;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix.equals("")) {
                return this.sourceNode.lookupNamespaceURI(null);
            }
            return this.sourceNode.lookupNamespaceURI(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return this.sourceNode.lookupPrefix(namespaceURI);
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceURI) {
            return null;
        }
    }
}

