/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.metadata.quality;

import java.time.Instant;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import org.opengis.annotation.Classifier;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.Stereotype;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.quality.EvaluationMethod;
import org.opengis.metadata.quality.EvaluationMethodType;
import org.opengis.metadata.quality.Measure;
import org.opengis.metadata.quality.MeasureInstanceReference;
import org.opengis.metadata.quality.MeasureReference;
import org.opengis.metadata.quality.Result;
import org.opengis.util.InternationalString;

@Classifier(value=Stereotype.ABSTRACT)
@UML(identifier="DQ_Element", specification=Specification.ISO_19157)
public interface Element {
    @UML(identifier="standaloneQualityReportDetails", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19157)
    default public InternationalString getStandaloneQualityReportDetails() {
        return null;
    }

    default public Measure getMeasure() {
        return null;
    }

    @UML(identifier="measure", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19157)
    default public MeasureReference getMeasureReference() {
        Measure measure = this.getMeasure();
        return measure == null ? null : new MeasureInstanceReference(measure);
    }

    @Deprecated
    @UML(identifier="nameOfMeasure", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115, version=2003)
    default public Collection<? extends InternationalString> getNamesOfMeasure() {
        MeasureReference measureReference = this.getMeasureReference();
        return measureReference != null ? measureReference.getNamesOfMeasure() : Collections.emptyList();
    }

    @Deprecated
    @UML(identifier="measureIdentification", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115, version=2003)
    default public Identifier getMeasureIdentification() {
        MeasureReference measureReference = this.getMeasureReference();
        return measureReference != null ? measureReference.getMeasureIdentification() : null;
    }

    @Deprecated
    @UML(identifier="measureDescription", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115, version=2003)
    default public InternationalString getMeasureDescription() {
        MeasureReference measureReference = this.getMeasureReference();
        return measureReference != null ? measureReference.getMeasureDescription() : null;
    }

    @UML(identifier="evaluationMethod", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19157)
    default public EvaluationMethod getEvaluationMethod() {
        return null;
    }

    @Deprecated
    @UML(identifier="evaluationMethodType", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115, version=2003)
    default public EvaluationMethodType getEvaluationMethodType() {
        EvaluationMethod evaluationMethod = this.getEvaluationMethod();
        return evaluationMethod != null ? evaluationMethod.getEvaluationMethodType() : null;
    }

    @Deprecated
    @UML(identifier="evaluationMethodDescription", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115, version=2003)
    default public InternationalString getEvaluationMethodDescription() {
        EvaluationMethod evaluationMethod = this.getEvaluationMethod();
        return evaluationMethod != null ? evaluationMethod.getEvaluationMethodDescription() : null;
    }

    @Deprecated
    @UML(identifier="evaluationProcedure", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115, version=2003)
    default public Citation getEvaluationProcedure() {
        EvaluationMethod evaluationMethod = this.getEvaluationMethod();
        return evaluationMethod != null ? evaluationMethod.getEvaluationProcedure() : null;
    }

    @Deprecated
    @UML(identifier="dateTime", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115, version=2003)
    default public Collection<? extends Date> getDates() {
        return new AbstractCollection<Date>(){

            @Override
            public int size() {
                EvaluationMethod evaluationMethod = Element.this.getEvaluationMethod();
                return evaluationMethod != null ? evaluationMethod.getDates().size() : 0;
            }

            @Override
            public Iterator<Date> iterator() {
                EvaluationMethod evaluationMethod = Element.this.getEvaluationMethod();
                if (evaluationMethod == null) {
                    return Collections.emptyIterator();
                }
                final Iterator<? extends Temporal> iterator = evaluationMethod.getDates().iterator();
                return new Iterator<Date>(){

                    @Override
                    public void remove() {
                        iterator.remove();
                    }

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Date next() {
                        Temporal temporal = (Temporal)iterator.next();
                        if (temporal == null) {
                            return null;
                        }
                        if (temporal instanceof Instant) {
                            return Date.from((Instant)temporal);
                        }
                        return new Date(Math.multiplyExact(temporal.getLong(ChronoField.INSTANT_SECONDS), 1000));
                    }
                };
            }
        };
    }

    @UML(identifier="result", obligation=Obligation.MANDATORY, specification=Specification.ISO_19157)
    public Collection<? extends Result> getResults();

    @UML(identifier="derivedElement", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19157)
    default public Collection<? extends Element> getDerivedElements() {
        return Collections.emptyList();
    }
}

