/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.Locale;
import java.util.Optional;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.NilReason;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.GenericName;

public abstract class AbstractResource
implements Resource {
    protected final StoreListeners listeners;
    private volatile Metadata metadata;

    protected AbstractResource(Resource parent) {
        StoreListeners parentListeners = null;
        if (parent instanceof AbstractResource) {
            parentListeners = ((AbstractResource)parent).listeners;
        } else if (parent instanceof DataStore) {
            parentListeners = ((DataStore)parent).listeners;
        }
        this.listeners = new StoreListeners(parentListeners, this);
    }

    protected AbstractResource(StoreListeners parentListeners, boolean hidden) {
        this.listeners = hidden && parentListeners != null ? parentListeners : new StoreListeners(parentListeners, this);
    }

    @Override
    public Optional<GenericName> getIdentifier() throws DataStoreException {
        return Optional.empty();
    }

    public Optional<Envelope> getEnvelope() throws DataStoreException {
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Metadata getMetadata() throws DataStoreException {
        Metadata md = this.metadata;
        if (md == null) {
            Object object = this.getSynchronizationLock();
            synchronized (object) {
                md = this.metadata;
                if (md == null) {
                    md = this.createMetadata();
                    if (md == null) {
                        md = (Metadata)NilReason.UNKNOWN.createNilObject(Metadata.class);
                    } else if (md instanceof DefaultMetadata) {
                        ((DefaultMetadata)md).transitionTo(ModifiableMetadata.State.FINAL);
                    }
                    this.metadata = md;
                }
            }
        }
        return md;
    }

    protected Metadata createMetadata() throws DataStoreException {
        MetadataBuilder builder = new MetadataBuilder();
        builder.addDefaultMetadata(this, this.listeners);
        return builder.build();
    }

    protected void clearCache() {
        this.metadata = null;
    }

    protected Object getSynchronizationLock() {
        return this;
    }

    @Override
    public <T extends StoreEvent> void addListener(Class<T> eventType, StoreListener<? super T> listener) {
        this.listeners.addListener(eventType, listener);
    }

    @Override
    public <T extends StoreEvent> void removeListener(Class<T> eventType, StoreListener<? super T> listener) {
        this.listeners.removeListener(eventType, listener);
    }

    final String createExceptionMessage(String filename, Envelope request) {
        Locale locale = this.listeners.getLocale();
        String message = Errors.getResources(locale).getString((short)12, filename);
        if (request != null) {
            try {
                Envelope envelope = this.getEnvelope().orElse(null);
                if (envelope != null) {
                    CoordinateReferenceSystem crs = CRS.suggestCommonTarget(null, (CoordinateReferenceSystem[])new CoordinateReferenceSystem[]{envelope.getCoordinateReferenceSystem(), request.getCoordinateReferenceSystem()});
                    request = Envelopes.transform((Envelope)request, (CoordinateReferenceSystem)crs);
                    envelope = Envelopes.transform((Envelope)envelope, (CoordinateReferenceSystem)crs);
                    int dimension = request.getDimension();
                    StringBuilder buffer = null;
                    for (int i = 0; i < dimension; ++i) {
                        double rmin = request.getMinimum(i);
                        double rmax = request.getMaximum(i);
                        double vmin = envelope.getMinimum(i);
                        double vmax = envelope.getMaximum(i);
                        if (!(rmax < vmin) && !(rmin > vmax)) continue;
                        Object axis = crs != null ? IdentifiedObjects.getDisplayName((IdentifiedObject)crs.getCoordinateSystem().getAxis(i), (Locale)locale) : (i < 3 ? String.valueOf((char)(120 + i)) : "#" + (i + 1));
                        if (buffer == null) {
                            buffer = new StringBuilder(message);
                        }
                        buffer.append(System.lineSeparator()).append(" \u2022 ").append(Resources.forLocale(locale).getString((short)64, axis, vmin, vmax, rmin, rmax));
                    }
                    if (buffer != null) {
                        message = buffer.toString();
                    }
                }
            }
            catch (DataStoreException | TransformException e) {
                Logging.ignorableException(this.listeners.getLogger(), AbstractResource.class, "createExceptionMessage", e);
            }
        }
        return message;
    }
}

