/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.sql;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.sis.internal.metadata.sql.ScriptRunner;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.StringBuilders;

final class Installer
extends ScriptRunner {
    private final String[] enumTypes;

    Installer(Connection connection) throws SQLException {
        super(connection, 100);
        if (this.isEnumTypeSupported) {
            this.enumTypes = null;
        } else {
            this.enumTypes = new String[]{"RoleCode", "DateTypeCode", "PresentationFormCode", "OnLineFunctionCode", "TransferFunctionTypeCode", "AxisDirection"};
            for (int i = 0; i < this.enumTypes.length; ++i) {
                this.enumTypes[i] = "metadata.\"" + this.enumTypes[i] + "\"";
            }
        }
    }

    public void run() throws IOException, SQLException {
        this.run(Installer.class, "Citations.sql");
        this.run(Installer.class, "Contents.sql");
        this.run(Installer.class, "Metadata.sql");
        this.run(Installer.class, "Referencing.sql");
    }

    @Override
    protected int execute(StringBuilder sql) throws SQLException, IOException {
        if (!this.isEnumTypeSupported && CharSequences.startsWith(sql, "CREATE TABLE", true)) {
            for (String type : this.enumTypes) {
                StringBuilders.replace(sql, type, "VARCHAR(25)");
            }
        }
        return super.execute(sql);
    }
}

