/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.sql;

import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.sql.DataSource;
import org.apache.sis.internal.metadata.sql.SQLBuilder;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.TypeValuePolicy;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.sql.IdentifierGenerator;
import org.apache.sis.metadata.sql.MetadataSource;
import org.apache.sis.metadata.sql.MetadataStoreException;
import org.apache.sis.metadata.sql.TableHierarchy;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.apache.sis.xml.IdentifiedObject;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.util.ControlledVocabulary;
import org.opengis.util.FactoryException;

public class MetadataWriter
extends MetadataSource {
    private static final String CODE_COLUMN = "CODE";
    private static final int MINIMAL_LIMIT = 5;
    private final int maximumIdentifierLength;
    private final int maximumValueLength;
    private final ValueExistencePolicy columnCreationPolicy;

    public MetadataWriter(MetadataStandard standard, DataSource dataSource, String schema, Map<String, ?> properties) {
        super(standard, dataSource, schema, properties);
        Integer maximumIdentifierLength = Containers.property(properties, "maximumIdentifierLength", Integer.class);
        Integer maximumValueLength = Containers.property(properties, "maximumValueLength", Integer.class);
        ValueExistencePolicy columnCreationPolicy = Containers.property(properties, "columnCreationPolicy", ValueExistencePolicy.class);
        if (maximumIdentifierLength != null) {
            ArgumentChecks.ensureBetween("maximumIdentifierLength", 5, 100, maximumIdentifierLength);
            this.maximumIdentifierLength = maximumIdentifierLength;
        } else {
            this.maximumIdentifierLength = 24;
        }
        if (maximumValueLength != null) {
            ArgumentChecks.ensureBetween("maximumValueLength", 5, Short.MAX_VALUE, maximumValueLength);
            this.maximumValueLength = maximumValueLength;
        } else {
            this.maximumValueLength = 1000;
        }
        this.columnCreationPolicy = columnCreationPolicy != null ? columnCreationPolicy : ValueExistencePolicy.NON_EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String add(Object metadata) throws MetadataStoreException {
        String identifier = this.proxy(metadata);
        if (identifier == null) {
            try {
                MetadataWriter metadataWriter = this;
                synchronized (metadataWriter) {
                    Connection connection = this.connection();
                    connection.setAutoCommit(false);
                    boolean success = false;
                    try {
                        try (Statement stmt = connection.createStatement();){
                            identifier = metadata instanceof ControlledVocabulary ? this.addCode(stmt, (ControlledVocabulary)metadata) : this.add(stmt, metadata, new IdentityHashMap<Object, String>(), null);
                        }
                        success = true;
                    }
                    finally {
                        if (success) {
                            connection.commit();
                        } else {
                            connection.rollback();
                        }
                        connection.setAutoCommit(true);
                    }
                }
            }
            catch (ClassCastException e) {
                throw new MetadataStoreException(Errors.format((short)42, "metadata", metadata.getClass()));
            }
            catch (SQLException e) {
                throw new MetadataStoreException(e.getLocalizedMessage(), Exceptions.unwrap(e));
            }
            catch (FactoryException e) {
                throw new MetadataStoreException(e.getLocalizedMessage(), (Exception)((Object)e));
            }
        }
        return identifier;
    }

    private String add(Statement stmt, Object metadata, Map<Object, String> done, String parent) throws ClassCastException, SQLException, FactoryException {
        int minimalIdentifierLength;
        int maxLength;
        Boolean isChildTable;
        Set<String> columns;
        SQLBuilder helper = this.helper();
        Map<String, Object> asValueMap = this.asValueMap(metadata);
        LinkedHashMap<String, Object> asSingletons = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : asValueMap.entrySet()) {
            asSingletons.put(entry.getKey(), MetadataWriter.extractFromCollection(entry.getValue()));
        }
        Class<?> implementationType = metadata.getClass();
        Class<?> interfaceType = this.standard.getInterface(implementationType);
        String table = MetadataWriter.getTableName(interfaceType);
        String identifier = this.search(table, columns = this.getExistingColumns(table), asSingletons, stmt, helper);
        if (identifier != null) {
            if (done.put(metadata, identifier) != null) {
                throw new AssertionError(metadata);
            }
            return identifier;
        }
        if (this.columnCreationPolicy != ValueExistencePolicy.ALL) {
            Iterator it = asSingletons.values().iterator();
            while (it.hasNext()) {
                if (it.next() != null) continue;
                it.remove();
            }
        }
        if ((isChildTable = this.createTable(stmt, interfaceType, table, columns)) == null) {
            isChildTable = this.isChildTable(interfaceType);
        }
        Map<String, Class<?>> colTypes = null;
        Map<String, Class<?>> colTables = null;
        LinkedHashMap<String, FKey> foreigners = new LinkedHashMap<String, FKey>();
        for (String column : asSingletons.keySet()) {
            Class declaring;
            if (columns.contains(column)) continue;
            if (colTypes == null) {
                colTypes = this.standard.asTypeMap(implementationType, NAME_POLICY, TypeValuePolicy.ELEMENT_TYPE);
                colTables = this.standard.asTypeMap(implementationType, NAME_POLICY, TypeValuePolicy.DECLARING_INTERFACE);
            }
            String addTo = table;
            if (helper.dialect.supportsTableInheritance && !interfaceType.isAssignableFrom(declaring = (Class)colTables.get(column))) {
                addTo = MetadataWriter.getTableName(declaring);
            }
            maxLength = this.maximumValueLength;
            Class<?> rt = colTypes.get(column);
            boolean isCodeList = ControlledVocabulary.class.isAssignableFrom(rt);
            if (isCodeList || this.standard.isMetadata(rt)) {
                if (!(isCodeList && Modifier.isAbstract(rt.getModifiers()) || foreigners.put(column, new FKey(addTo, rt, null)) == null)) {
                    throw new AssertionError((Object)column);
                }
                rt = null;
                maxLength = this.maximumIdentifierLength;
            } else if (rt.isEnum()) {
                maxLength = this.maximumIdentifierLength;
            }
            stmt.executeUpdate(helper.createColumn(this.schema(), addTo, column, rt, maxLength));
            columns.add(column);
        }
        identifier = Strings.trimOrNull(MetadataWriter.removeReservedChars(this.suggestIdentifier(metadata, asValueMap), null));
        if (identifier == null && (identifier = parent) == null) {
            identifier = "unknown";
            for (Object value : asSingletons.values()) {
                if (value == null || this.standard.isMetadata(value.getClass())) continue;
                identifier = MetadataWriter.abbreviation(value.toString());
                break;
            }
        }
        if (isChildTable.booleanValue()) {
            identifier = TableHierarchy.encode(table, identifier);
            minimalIdentifierLength = table.length() + 2;
        } else {
            minimalIdentifierLength = 0;
        }
        try (IdentifierGenerator idCheck = new IdentifierGenerator(this, this.schema(), table, "ID", helper);){
            for (int i = 0; i < 4; ++i) {
                maxLength = this.maximumIdentifierLength - i;
                if (maxLength < minimalIdentifierLength) {
                } else {
                    if (identifier.length() > maxLength) {
                        identifier = identifier.substring(0, maxLength);
                    }
                    if ((identifier = idCheck.identifier(identifier)).length() > this.maximumIdentifierLength) continue;
                }
                break;
            }
        }
        if (done.put(metadata, identifier) != null) {
            throw new AssertionError(metadata);
        }
        HashMap<String, FKey> referencedTables = null;
        for (Map.Entry entry : asSingletons.entrySet()) {
            Object value = entry.getValue();
            Class<?> type = value.getClass();
            if (ControlledVocabulary.class.isAssignableFrom(type)) {
                value = this.addCode(stmt, (ControlledVocabulary)value);
            } else if (type.isEnum()) {
                value = ((Enum)value).name();
            } else if (this.standard.isMetadata(type)) {
                String dependency = this.proxy(value);
                if (dependency == null && (dependency = done.get(value)) == null) {
                    dependency = this.add(stmt, value, done, identifier);
                    assert (done.get(value) == dependency);
                    Objects.requireNonNull(helper.dialect);
                    String column = (String)entry.getKey();
                    Class<?> targetType = this.standard.getInterface(value.getClass());
                    FKey fkey = (FKey)foreigners.get(column);
                    if (fkey != null && !targetType.isAssignableFrom(fkey.tableType)) {
                        fkey.tableType = targetType;
                    }
                    if (fkey == null) {
                        if (referencedTables == null) {
                            referencedTables = new HashMap<String, FKey>();
                            try (ResultSet rs = stmt.getConnection().getMetaData().getImportedKeys(this.catalog, this.schema(), table);){
                                while (rs.next()) {
                                    if (this.schema() != null && !this.schema().equals(rs.getString("PKTABLE_SCHEM")) || this.catalog != null && !this.catalog.equals(rs.getString("PKTABLE_CAT"))) continue;
                                    referencedTables.put(rs.getString("FKCOLUMN_NAME"), new FKey(rs.getString("PKTABLE_NAME"), null, rs.getString("FK_NAME")));
                                }
                            }
                        }
                        if ((fkey = (FKey)referencedTables.remove(column)) != null && !fkey.tableName.equals(MetadataWriter.getTableName(targetType))) {
                            stmt.executeUpdate(helper.clear().append("ALTER TABLE ").appendIdentifier(this.schema(), table).append(" DROP CONSTRAINT ").appendIdentifier(fkey.keyName).toString());
                            this.warning(MetadataWriter.class, "add", Messages.getResources(null).getLogRecord(Level.WARNING, (short)32, table + "." + column + " \u21d2 " + fkey.tableName + ".ID"));
                        }
                    }
                }
                value = dependency;
            }
            entry.setValue(value);
        }
        if (!foreigners.isEmpty()) {
            for (Map.Entry entry : foreigners.entrySet()) {
                String primaryKey;
                FKey fkey = (FKey)entry.getValue();
                Class<?> rt = fkey.tableType;
                boolean isCodeList = ControlledVocabulary.class.isAssignableFrom(rt);
                if (isCodeList) {
                    primaryKey = CODE_COLUMN;
                } else {
                    primaryKey = "ID";
                    rt = this.standard.getInterface(rt);
                }
                String column = (String)entry.getKey();
                String target = MetadataWriter.getTableName(rt);
                stmt.executeUpdate(helper.createForeignKey(this.schema(), fkey.tableName, column, target, primaryKey, !isCodeList));
                Objects.requireNonNull(helper.dialect);
                if (table.equals(fkey.tableName)) continue;
                stmt.executeUpdate(helper.createForeignKey(this.schema(), table, column, target, primaryKey, !isCodeList));
            }
        }
        helper.clear().append("INSERT INTO ").appendIdentifier(this.schema(), table).append(" (").appendIdentifier("ID");
        for (String column : asSingletons.keySet()) {
            helper.append(", ").appendIdentifier(column);
        }
        helper.append(") VALUES (").appendValue(identifier);
        for (Map.Entry value : asSingletons.values()) {
            helper.append(", ").appendValue(MetadataWriter.toStorableValue(value));
        }
        String sql = helper.append(')').toString();
        if (stmt.executeUpdate(sql) != 1) {
            throw new SQLException(Errors.format((short)174, 0, table, identifier));
        }
        return identifier;
    }

    private static Class<?>[] getParentTypes(Class<?> type) {
        Class<?>[] classArray;
        if (type.isInterface()) {
            classArray = type.getInterfaces();
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = type.getSuperclass();
        }
        return classArray;
    }

    private Boolean isChildTable(Class<?> type) {
        for (Class<?> candidate : MetadataWriter.getParentTypes(type)) {
            if (!this.standard.isMetadata(candidate)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Boolean createTable(Statement stmt, Class<?> type, String table, Set<String> columns) throws SQLException {
        Boolean isChildTable = null;
        if (columns.isEmpty()) {
            isChildTable = Boolean.FALSE;
            StringBuilder inherits = null;
            for (Class<?> candidate : MetadataWriter.getParentTypes(type)) {
                if (!this.standard.isMetadata(candidate)) continue;
                isChildTable = Boolean.TRUE;
                SQLBuilder helper = this.helper();
                if (!helper.dialect.supportsTableInheritance) continue;
                String parent = MetadataWriter.getTableName(candidate);
                this.createTable(stmt, candidate, parent, this.getExistingColumns(parent));
                if (inherits == null) {
                    helper.clear().append("CREATE TABLE ").appendIdentifier(this.schema(), table);
                    Objects.requireNonNull(helper.dialect);
                    helper.append("(CONSTRAINT ").appendIdentifier(table + "_pkey").append(" PRIMARY KEY (").appendIdentifier("ID").append(")) ");
                    inherits = new StringBuilder(helper.append(" INHERITS (").toString());
                } else {
                    inherits.append(", ");
                }
                inherits.append(helper.clear().appendIdentifier(this.schema(), parent));
            }
            String sql = inherits != null ? inherits.append(')').toString() : this.createTable(table, "ID");
            stmt.executeUpdate(sql);
            columns.add("ID");
        }
        return isChildTable;
    }

    private String createTable(String table, String primaryKey) throws SQLException {
        return this.helper().clear().append("CREATE TABLE ").appendIdentifier(this.schema(), table).append(" (").appendIdentifier(primaryKey).append(" VARCHAR(").append(this.maximumIdentifierLength).append(") NOT NULL PRIMARY KEY)").toString();
    }

    private String addCode(Statement stmt, ControlledVocabulary code) throws SQLException {
        String sql;
        boolean exists;
        assert (Thread.holdsLock(this));
        String table = MetadataWriter.getTableName(code.getClass());
        Set<String> columns = this.getExistingColumns(table);
        if (columns.isEmpty()) {
            stmt.executeUpdate(this.createTable(table, CODE_COLUMN));
            columns.add(CODE_COLUMN);
        }
        String identifier = Types.getCodeName(code);
        String query = this.helper().clear().append("SELECT ").appendIdentifier(CODE_COLUMN).append(" FROM ").appendIdentifier(this.schema(), table).append(" WHERE ").appendIdentifier(CODE_COLUMN).appendEqualsValue(identifier).toString();
        try (ResultSet rs = stmt.executeQuery(query);){
            exists = rs.next();
        }
        if (!exists && stmt.executeUpdate(sql = this.helper().clear().append("INSERT INTO ").appendIdentifier(this.schema(), table).append(" (").appendIdentifier(CODE_COLUMN).append(") VALUES (").appendValue(identifier).append(')').toString()) != 1) {
            throw new SQLException(Errors.format((short)174, 0, table, identifier));
        }
        return identifier;
    }

    protected String suggestIdentifier(Object metadata, Map<String, Object> asValueMap) throws SQLException {
        Object value;
        TitleProperty tp;
        Object identifier = null;
        Collection<Object> identifiers = metadata instanceof Identifier ? Set.of((Identifier)metadata) : (metadata instanceof IdentifiedObject ? ((IdentifiedObject)metadata).getIdentifiers() : Set.of());
        for (Identifier id : identifiers) {
            identifier = Strings.trimOrNull(id.getCode());
            if (identifier == null) continue;
            String cs = Strings.trimOrNull(id.getCodeSpace());
            if (cs == null) break;
            identifier = cs + ":" + (String)identifier;
            break;
        }
        if (identifier == null && metadata instanceof Citation) {
            identifier = Strings.trimOrNull(Citations.toCodeSpace((Citation)metadata));
        }
        if (identifier == null && (tp = metadata.getClass().getAnnotation(TitleProperty.class)) != null && (value = asValueMap.get(Strings.trimOrNull(tp.name()))) != null) {
            identifier = Strings.trimOrNull(value.toString());
        }
        if (identifier != null && ((String)identifier).length() >= 8) {
            identifier = MetadataWriter.abbreviation((String)identifier);
        }
        return identifier;
    }

    private static String abbreviation(String identifier) {
        StringBuilder buffer = new StringBuilder();
        StringTokenizer tokens = new StringTokenizer(identifier);
        while (tokens.hasMoreTokens()) {
            int c = tokens.nextToken().codePointAt(0);
            if (MetadataWriter.isReservedChar(c)) continue;
            buffer.appendCodePoint(c);
        }
        if (buffer.length() >= 3) {
            return buffer.toString();
        }
        buffer.setLength(0);
        return MetadataWriter.removeReservedChars(identifier, buffer.append(identifier));
    }

    private static String removeReservedChars(String identifier, StringBuilder buffer) {
        if (identifier != null) {
            boolean modified = false;
            int i = identifier.length();
            while (--i >= 0) {
                char c = identifier.charAt(i);
                if (!MetadataWriter.isReservedChar(c)) continue;
                if (buffer == null) {
                    buffer = new StringBuilder(identifier);
                }
                buffer.deleteCharAt(i);
                modified = true;
            }
            if (modified) {
                return buffer.toString();
            }
        }
        return identifier;
    }

    private static boolean isReservedChar(int c) {
        return c == 123 || c == 125;
    }

    private static final class FKey {
        final String tableName;
        Class<?> tableType;
        final String keyName;

        FKey(String tableName, Class<?> tableType, String keyName) {
            this.tableName = tableName;
            this.tableType = tableType;
            this.keyName = keyName;
        }
    }
}

