/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.temporal.object;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import java.util.Map;
import org.geotoolkit.temporal.object.DefaultInstant;
import org.geotoolkit.temporal.object.DefaultPeriodDuration;
import org.geotoolkit.temporal.object.DefaultTemporalPrimitive;
import org.opengis.temporal.Duration;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Period;
import org.opengis.temporal.RelativePosition;
import org.opengis.temporal.Separation;
import org.opengis.temporal.TemporalGeometricPrimitive;
import org.opengis.temporal.TemporalPrimitive;

@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class DefaultTemporalGeometricPrimitive
extends DefaultTemporalPrimitive
implements TemporalGeometricPrimitive,
Separation {
    public DefaultTemporalGeometricPrimitive(Map<String, ?> properties) throws IllegalArgumentException {
        super(properties);
    }

    protected DefaultTemporalGeometricPrimitive() {
    }

    protected DefaultTemporalGeometricPrimitive(TemporalGeometricPrimitive object) {
        super((TemporalPrimitive)object);
    }

    public Duration distance(TemporalGeometricPrimitive other) {
        DefaultPeriodDuration response = null;
        long diff = 0L;
        if (this.relativePosition((TemporalPrimitive)other).equals(RelativePosition.BEFORE) || this.relativePosition((TemporalPrimitive)other).equals(RelativePosition.AFTER)) {
            if (this instanceof Instant && other instanceof Instant) {
                diff = Math.min(Math.abs(((Instant)other).getDate().getTime() - ((Instant)this).getDate().getTime()), Math.abs(((Instant)this).getDate().getTime() - ((Instant)other).getDate().getTime()));
            } else if (this instanceof Instant && other instanceof Period) {
                diff = Math.min(Math.abs(((Period)other).getBeginning().getDate().getTime() - ((Instant)this).getDate().getTime()), Math.abs(((Period)other).getEnding().getDate().getTime() - ((Instant)this).getDate().getTime()));
            } else if (this instanceof Period && other instanceof Instant) {
                diff = Math.min(Math.abs(((Instant)other).getDate().getTime() - ((Period)this).getEnding().getDate().getTime()), Math.abs(((Instant)other).getDate().getTime() - ((Period)this).getBeginning().getDate().getTime()));
            } else if (this instanceof Period && other instanceof Period) {
                diff = Math.min(Math.abs(((Period)other).getEnding().getDate().getTime() - ((Period)this).getBeginning().getDate().getTime()), Math.abs(((Period)other).getBeginning().getDate().getTime() - ((Period)this).getEnding().getDate().getTime()));
            }
        } else if (this.relativePosition((TemporalPrimitive)other).equals(RelativePosition.BEGINS) || this.relativePosition((TemporalPrimitive)other).equals(RelativePosition.BEGUN_BY) || this.relativePosition((TemporalPrimitive)other).equals(RelativePosition.CONTAINS) || this.relativePosition((TemporalPrimitive)other).equals(RelativePosition.DURING) || this.relativePosition((TemporalPrimitive)other).equals(RelativePosition.ENDED_BY) || this.relativePosition((TemporalPrimitive)other).equals(RelativePosition.ENDS) || this.relativePosition((TemporalPrimitive)other).equals(RelativePosition.EQUALS) || this.relativePosition((TemporalPrimitive)other).equals(RelativePosition.MEETS) || this.relativePosition((TemporalPrimitive)other).equals(RelativePosition.MET_BY) || this.relativePosition((TemporalPrimitive)other).equals(RelativePosition.OVERLAPPED_BY) || this.relativePosition((TemporalPrimitive)other).equals(RelativePosition.OVERLAPS)) {
            diff = 0L;
        }
        response = new DefaultPeriodDuration(Math.abs(diff));
        return response;
    }

    public Duration length() {
        DefaultPeriodDuration response = null;
        long diff = 0L;
        if (this instanceof Instant) {
            response = new DefaultPeriodDuration(Math.abs(diff));
            return response;
        }
        if (this instanceof Period && ((Period)this).getBeginning() != null && ((Period)this).getEnding() != null) {
            response = ((DefaultInstant)((Period)this).getBeginning()).distance((DefaultInstant)((Period)this).getEnding());
            return response;
        }
        return null;
    }
}

