/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.image.RenderedImage;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.grid.FractionalGridCoordinates;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.WraparoundAxesFinder;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.logging.Logging;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.PointOutsideCoverageException;
import org.opengis.geometry.DirectPosition;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

class DefaultEvaluator
implements GridCoverage.Evaluator {
    private final GridCoverage coverage;
    private CoordinateReferenceSystem inputCRS;
    private MathTransform inputToGrid;
    private FractionalGridCoordinates.Position position;
    double[] values;
    private boolean nullIfOutside;
    private long wraparoundAxes;
    private double[] wraparoundExtent;
    private MathTransform gridToWraparound;
    private double[] periods;
    private Map<Integer, Long> slice;

    protected DefaultEvaluator(GridCoverage coverage) {
        ArgumentChecks.ensureNonNull("coverage", coverage);
        this.coverage = coverage;
    }

    @Override
    public final GridCoverage getCoverage() {
        return this.coverage;
    }

    @Override
    public final Map<Integer, Long> getDefaultSlice() {
        if (this.slice == null) {
            GridExtent extent = this.coverage.getGridGeometry().getExtent();
            this.slice = CollectionsExt.unmodifiableOrCopy(extent.getSliceCoordinates());
        }
        return this.slice;
    }

    @Override
    public void setDefaultSlice(Map<Integer, Long> slice) {
        if (!Objects.equals(this.slice, slice)) {
            if (slice != null) {
                slice = CollectionsExt.unmodifiableOrCopy(new TreeMap<Integer, Long>(slice));
                GridExtent extent = this.coverage.getGridGeometry().getExtent();
                int max = extent.getDimension() - 1;
                for (Map.Entry<Integer, Long> entry : slice.entrySet()) {
                    int dim = entry.getKey();
                    ArgumentChecks.ensureBetween("slice.key", 0, max, dim);
                    ArgumentChecks.ensureBetween(extent.getAxisIdentification(dim, dim).toString(), extent.getLow(dim), extent.getHigh(dim), entry.getValue());
                }
            }
            this.slice = slice;
            this.inputCRS = null;
            this.inputToGrid = null;
        }
    }

    @Override
    public boolean isWraparoundEnabled() {
        return this.wraparoundAxes != 0L;
    }

    @Override
    public void setWraparoundEnabled(boolean allow) {
        this.wraparoundAxes = 0L;
        if (allow) {
            try {
                WraparoundAxesFinder f = new WraparoundAxesFinder(this.coverage.getCoordinateReferenceSystem());
                this.periods = f.periods();
                if (this.periods != null) {
                    int i;
                    GridGeometry gridGeometry = this.coverage.getGridGeometry();
                    GridExtent extent = gridGeometry.getExtent();
                    MathTransform gridToCRS = gridGeometry.getGridToCRS(PixelInCell.CELL_CENTER);
                    this.gridToWraparound = MathTransforms.concatenate((MathTransform)gridToCRS, (MathTransform)f.preferredToSpecified.inverse());
                    Matrix m = this.gridToWraparound.derivative((DirectPosition)new DirectPositionView.Double(extent.getPointOfInterest(PixelInCell.CELL_CENTER)));
                    int j = this.periods.length;
                    while (--j >= 0) {
                        if (!(this.periods[j] > 0.0)) continue;
                        int i2 = Math.min(m.getNumCol(), 64);
                        while (--i2 >= 0) {
                            if (m.getElement(j, i2) == 0.0) continue;
                            this.wraparoundAxes |= 1L << i2;
                        }
                    }
                    this.wraparoundExtent = new double[Long.bitCount(this.wraparoundAxes) << 1];
                    long axes = this.wraparoundAxes;
                    int j2 = 0;
                    do {
                        i = Long.numberOfTrailingZeros(axes);
                        this.wraparoundExtent[j2++] = extent.getLow(i);
                        this.wraparoundExtent[j2++] = extent.getHigh(i);
                    } while ((axes &= 1L << i ^ 0xFFFFFFFFFFFFFFFFL) != 0L);
                    assert (this.wraparoundExtent.length == j2) : j2;
                }
            }
            catch (TransformException e) {
                DefaultEvaluator.recoverableException("setWraparoundEnabled", e);
            }
        }
    }

    @Override
    public boolean isNullIfOutside() {
        return this.nullIfOutside;
    }

    @Override
    public void setNullIfOutside(boolean flag) {
        this.nullIfOutside = flag;
    }

    @Override
    public double[] apply(DirectPosition point) throws CannotEvaluateException {
        GridGeometry gridGeometry = this.coverage.gridGeometry;
        long[] size = new long[gridGeometry.getDimension()];
        Arrays.fill(size, 1L);
        try {
            FractionalGridCoordinates.Position gc = this.toGridPosition(point);
            try {
                GridExtent subExtent = gc.toExtent(gridGeometry.extent, size, this.nullIfOutside);
                if (subExtent != null) {
                    return this.evaluate(this.coverage.render(subExtent), 0, 0);
                }
            }
            catch (ArithmeticException | IndexOutOfBoundsException | DisjointExtentException ex) {
                if (!this.nullIfOutside) {
                    throw (PointOutsideCoverageException)new PointOutsideCoverageException(gc.pointOutsideCoverage(gridGeometry.extent), point).initCause((Throwable)ex);
                }
            }
        }
        catch (PointOutsideCoverageException ex) {
            ex.setOffendingLocation(point);
            throw ex;
        }
        catch (RuntimeException | TransformException | FactoryException ex) {
            throw new CannotEvaluateException(ex.getMessage(), ex);
        }
        return null;
    }

    final double[] evaluate(RenderedImage data, int x, int y) {
        int tx = ImageUtilities.pixelToTileX(data, x);
        int ty = ImageUtilities.pixelToTileY(data, y);
        this.values = data.getTile(tx, ty).getPixel(x, y, this.values);
        return this.values;
    }

    @Override
    public FractionalGridCoordinates toGridCoordinates(DirectPosition point) throws TransformException {
        ArgumentChecks.ensureNonNull("point", point);
        try {
            return new FractionalGridCoordinates(this.toGridPosition(point));
        }
        catch (FactoryException e) {
            throw new TransformException(e.getMessage(), (Throwable)e);
        }
    }

    final FractionalGridCoordinates.Position toGridPosition(DirectPosition point) throws FactoryException, TransformException {
        block13: {
            int i;
            long axes;
            DirectPosition result;
            CoordinateReferenceSystem crs = point.getCoordinateReferenceSystem();
            if (crs != this.inputCRS || this.inputToGrid == null) {
                this.setInputCRS(crs);
            }
            if ((result = this.inputToGrid.transform(point, (DirectPosition)this.position)) != this.position) {
                double[] coordinates = this.position.coordinates;
                System.arraycopy(result.getCoordinate(), 0, coordinates, 0, coordinates.length);
            }
            if ((axes = this.wraparoundAxes) == 0L) break block13;
            double[] coordinates = this.position.coordinates;
            long outsideAxes = 0L;
            int j = 0;
            do {
                block15: {
                    double border;
                    block14: {
                        double d;
                        double c;
                        if ((c = coordinates[i = Long.numberOfTrailingZeros(axes)]) < (border = this.wraparoundExtent[j++])) break block14;
                        border = this.wraparoundExtent[j];
                        if (!(c > d)) break block15;
                    }
                    if (outsideAxes == 0L) {
                        int n = coordinates.length;
                        coordinates = Arrays.copyOf(coordinates, 2 * Math.max(n, this.gridToWraparound.getTargetDimensions()));
                        System.arraycopy(coordinates, 0, coordinates, n, n);
                    }
                    coordinates[i] = border;
                    outsideAxes |= 1L << i;
                }
                ++j;
            } while ((axes &= 1L << i ^ 0xFFFFFFFFFFFFFFFFL) != 0L);
            assert (this.wraparoundExtent.length == j) : j;
            if (outsideAxes != 0L) {
                this.gridToWraparound.transform(coordinates, 0, coordinates, 0, 2);
                int s = this.gridToWraparound.getTargetDimensions();
                int i2 = this.periods.length;
                while (--i2 >= 0) {
                    double period = this.periods[i2];
                    if (!(period > 0.0)) continue;
                    int oi = i2 + s;
                    double shift = coordinates[i2] - coordinates[oi];
                    shift = Math.copySign(Math.ceil(Math.abs(shift) / period), shift) * period;
                    int n = oi;
                    coordinates[n] = coordinates[n] + shift;
                }
                this.gridToWraparound.inverse().transform(coordinates, s, coordinates, 0, 1);
                j = 0;
                do {
                    double c;
                    if (!((c = coordinates[i2 = Long.numberOfTrailingZeros(outsideAxes)]) < this.wraparoundExtent[j++])) {
                        int n = j++;
                        if (!(c > this.wraparoundExtent[n])) continue;
                    }
                    return this.position;
                } while ((outsideAxes &= 1L << i2 ^ 0xFFFFFFFFFFFFFFFFL) != 0L);
                double[] target = this.position.coordinates;
                int i3 = target.length;
                while (--i3 >= 0) {
                    double value = coordinates[i3];
                    if (Double.isNaN(value)) continue;
                    target[i3] = value;
                }
            }
        }
        return this.position;
    }

    private void setInputCRS(CoordinateReferenceSystem crs) throws FactoryException, NoninvertibleTransformException {
        GridGeometry gridGeometry = this.coverage.getGridGeometry();
        MathTransform gridToCRS = gridGeometry.getGridToCRS(PixelInCell.CELL_CENTER);
        MathTransform crsToGrid = gridToCRS.inverse();
        if (crs != null) {
            CoordinateReferenceSystem stepCRS = this.coverage.getCoordinateReferenceSystem();
            GeographicBoundingBox areaOfInterest = gridGeometry.geographicBBox();
            try {
                CoordinateOperation op = CRS.findOperation((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)stepCRS, (GeographicBoundingBox)areaOfInterest);
                crsToGrid = MathTransforms.concatenate((MathTransform)op.getMathTransform(), (MathTransform)crsToGrid);
            }
            catch (FactoryException main) {
                Map<Integer, Long> slice = this.getDefaultSlice();
                try {
                    CoordinateOperation op = CRS.findOperation((CoordinateReferenceSystem)stepCRS, (CoordinateReferenceSystem)crs, (GeographicBoundingBox)areaOfInterest);
                    gridToCRS = MathTransforms.concatenate((MathTransform)gridToCRS, (MathTransform)op.getMathTransform());
                    TransformSeparator ts = new TransformSeparator(gridToCRS);
                    int crsDim = gridToCRS.getTargetDimensions();
                    int gridDim = gridToCRS.getSourceDimensions();
                    int[] mandatory = new int[gridDim];
                    int n = 0;
                    for (int i = 0; i < gridDim; ++i) {
                        if (slice.containsKey(i)) continue;
                        mandatory[n++] = i;
                    }
                    mandatory = ArraysExt.resize(mandatory, n);
                    ts.addSourceDimensions(mandatory);
                    ts.setSourceExpandable(true);
                    ts.addTargetDimensionRange(0, crsDim);
                    gridToCRS = ts.separate();
                    crsToGrid = gridToCRS.inverse();
                    mandatory = ts.getSourceDimensions();
                    int valueColumn = mandatory.length;
                    MatrixSIS m = Matrices.createZero((int)(gridDim + 1), (int)(valueColumn + 1));
                    m.setElement(gridDim, valueColumn, 1.0);
                    n = 0;
                    for (int j = 0; j < gridDim; ++j) {
                        if (Arrays.binarySearch(mandatory, j) >= 0) {
                            m.setElement(j, n++, 1.0);
                            continue;
                        }
                        Long value = slice.get(j);
                        if (value == null) {
                            GridExtent extent = gridGeometry.extent;
                            throw new FactoryException(Resources.format((short)50, crsDim, extent.getAxisIdentification(j, j), extent.getSize(j)));
                        }
                        m.setElement(j, valueColumn, (double)value.longValue());
                    }
                    crsToGrid = MathTransforms.concatenate((MathTransform)crsToGrid, (MathTransform)MathTransforms.linear((Matrix)m));
                }
                catch (RuntimeException | NoninvertibleTransformException | FactoryException ex) {
                    main.addSuppressed(ex);
                    throw main;
                }
            }
        }
        this.position = new FractionalGridCoordinates.Position(crsToGrid.getTargetDimensions());
        this.inputCRS = crs;
        this.inputToGrid = crsToGrid;
    }

    private static void recoverableException(String caller, TransformException exception) {
        Logging.recoverableException(GridExtent.LOGGER, DefaultEvaluator.class, caller, exception);
    }
}

