/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Collection;
import java.util.Iterator;
import org.apache.sis.feature.PropertySingleton;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.resources.Errors;
import org.opengis.feature.InvalidPropertyValueException;
import org.opengis.feature.MultiValuedPropertyException;
import org.opengis.feature.Property;
import org.opengis.feature.PropertyType;

abstract class Field<V>
implements Property {
    Field() {
    }

    static boolean isSingleton(int maximumOccurs) {
        return maximumOccurs <= 1;
    }

    public abstract V getValue() throws MultiValuedPropertyException;

    public Collection<V> getValues() {
        return new PropertySingleton(this);
    }

    public abstract void setValue(V var1);

    public void setValues(Collection<? extends V> values) throws InvalidPropertyValueException {
        V value = null;
        ArgumentChecks.ensureNonNull("values", values);
        Iterator<V> it = values.iterator();
        if (it.hasNext()) {
            value = it.next();
            if (it.hasNext()) {
                throw new InvalidPropertyValueException(Errors.format((short)130, 1, this.getName()));
            }
        }
        this.setValue(value);
    }

    static boolean isDeprecated(PropertyType type) {
        return type instanceof Deprecable && ((Deprecable)type).isDeprecated();
    }
}

