/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.display.shape;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.sis.internal.referencing.j2d.IntervalRectangle;
import org.geotoolkit.display.shape.InfiniteRectangle2D;

public class XRectangle2D
extends IntervalRectangle
implements Serializable {
    private static final double EPS = 1.0E-6;
    public static final Rectangle2D INFINITY = new InfiniteRectangle2D();

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeDouble(this.xmin);
        out.writeDouble(this.xmax);
        out.writeDouble(this.ymin);
        out.writeDouble(this.ymax);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.xmin = in.readDouble();
        this.xmax = in.readDouble();
        this.ymin = in.readDouble();
        this.ymax = in.readDouble();
    }

    public XRectangle2D() {
    }

    public XRectangle2D(double x, double y, double width, double height) {
        this.xmin = x;
        this.ymin = y;
        this.xmax = x + width;
        this.ymax = y + height;
    }

    public XRectangle2D(Rectangle2D rect) {
        if (rect != null) {
            this.setRect(rect);
        }
    }

    public static XRectangle2D createFromExtremums(double xmin, double ymin, double xmax, double ymax) {
        XRectangle2D rect = new XRectangle2D();
        rect.xmin = xmin;
        rect.ymin = ymin;
        rect.xmax = xmax;
        rect.ymax = ymax;
        return rect;
    }

    public static boolean intersectInclusive(Rectangle2D rect1, Rectangle2D rect2) {
        double xmin1 = rect1.getMinX();
        double xmax1 = rect1.getMaxX();
        if (!(xmax1 >= xmin1)) {
            return false;
        }
        double ymin1 = rect1.getMinY();
        double ymax1 = rect1.getMaxY();
        if (!(ymax1 >= ymin1)) {
            return false;
        }
        double xmin2 = rect2.getMinX();
        double xmax2 = rect2.getMaxX();
        if (!(xmax2 >= xmin2)) {
            return false;
        }
        double ymin2 = rect2.getMinY();
        double ymax2 = rect2.getMaxY();
        if (!(ymax2 >= ymin2)) {
            return false;
        }
        return xmax2 >= xmin1 && ymax2 >= ymin1 && xmin2 <= xmax1 && ymin2 <= ymax1;
    }

    public static boolean intersectInclusive(Shape shape, Rectangle2D rect) {
        double x = rect.getX();
        double y = rect.getY();
        double width = rect.getWidth();
        double height = rect.getHeight();
        if (width == 0.0 && height == 0.0) {
            width = 1.0E-6;
            height = 1.0E-6;
        } else if (width == 0.0) {
            width = height * 1.0E-6;
            x -= 0.5 * width;
        } else if (height == 0.0) {
            height = width * 1.0E-6;
            y -= 0.5 * height;
        }
        return shape.intersects(x, y, width, height);
    }

    public static boolean containsInclusive(Rectangle2D outter, Rectangle2D inner) {
        return outter.getMinX() <= inner.getMinX() && outter.getMaxX() >= inner.getMaxX() && outter.getMinY() <= inner.getMinY() && outter.getMaxY() >= inner.getMaxY();
    }
}

