/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gui.swing.tree;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Classes;
import org.geotoolkit.gui.swing.tree.DefaultMutableTreeNode;
import org.geotoolkit.gui.swing.tree.MutableTreeNode;
import org.geotoolkit.gui.swing.tree.NamedTreeNode;
import org.geotoolkit.gui.swing.tree.TreeFormat;
import org.geotoolkit.gui.swing.tree.TreeNode;
import org.geotoolkit.lang.Static;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Deprecated
public final class Trees
extends Static {
    private Trees() {
    }

    public static Object getUserObject(javax.swing.tree.TreeNode node) {
        if (node instanceof TreeNode) {
            return ((TreeNode)node).getUserObject();
        }
        if (node instanceof javax.swing.tree.DefaultMutableTreeNode) {
            return ((javax.swing.tree.DefaultMutableTreeNode)node).getUserObject();
        }
        return null;
    }

    public static TreePath[] getPathsToUserObject(TreeModel model, Object value) {
        ArrayList<TreePath> paths = new ArrayList<TreePath>(8);
        Object[] path = new Object[8];
        path[0] = model.getRoot();
        Trees.getPathsToUserObject(model, value, path, 1, paths);
        return paths.toArray(new TreePath[paths.size()]);
    }

    private static Object[] getPathsToUserObject(TreeModel model, Object value, Object[] path, int length, List<TreePath> list) {
        Object nodeValue;
        Object parent = path[length - 1];
        if (parent instanceof TreeNode && ((nodeValue = ((TreeNode)parent).getUserObject()) == value || value != null && value.equals(nodeValue))) {
            list.add(new TreePath(ArraysExt.resize((Object[])path, (int)length)));
        }
        int count = model.getChildCount(parent);
        for (int i = 0; i < count; ++i) {
            if (length >= path.length) {
                path = Arrays.copyOf(path, length << 1);
            }
            path[length] = model.getChild(parent, i);
            path = Trees.getPathsToUserObject(model, value, path, length + 1, list);
        }
        return path;
    }

    public static MutableTreeNode objectToSwing(Object object) {
        DefaultMutableTreeNode node;
        Iterator<Object> iterator = null;
        Class baseInterface = null;
        if (object instanceof Iterable) {
            baseInterface = Iterable.class;
            iterator = ((Iterable)object).iterator();
        } else if (object instanceof Map) {
            baseInterface = Map.class;
            iterator = ((Map)object).entrySet().iterator();
        }
        if (iterator != null) {
            Class[] types = Classes.getLeafInterfaces(object.getClass(), baseInterface);
            node = new DefaultMutableTreeNode(Classes.getShortName(types.length != 0 ? types[0] : null));
            while (iterator.hasNext()) {
                node.add(Trees.objectToSwing(iterator.next()));
            }
        } else if (object.getClass().isArray()) {
            node = new DefaultMutableTreeNode("Array");
            int length = Array.getLength(object);
            for (int i = 0; i < length; ++i) {
                node.add(Trees.objectToSwing(Array.get(object, i)));
            }
        } else {
            if (object instanceof Node) {
                return Trees.xmlToSwing((Node)object);
            }
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                node = new NamedTreeNode(String.valueOf(entry.getKey()), entry.getValue());
            } else {
                node = new DefaultMutableTreeNode(object);
            }
            node.setAllowsChildren(false);
        }
        return node;
    }

    public static MutableTreeNode xmlToSwing(Node node) {
        Object label = node.getNodeName();
        String value = node.getNodeValue();
        if (value != null) {
            label = (String)label + "=\"" + value + "\"";
        }
        NamedTreeNode root = new NamedTreeNode((CharSequence)label, node);
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            int length = attributes.getLength();
            for (int i = 0; i < length; ++i) {
                Node attribute = attributes.item(i);
                if (attribute == null) continue;
                label = attribute.getNodeName() + "=\"" + attribute.getNodeValue() + "\"";
                root.add(new NamedTreeNode((CharSequence)label, attribute, false));
            }
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            root.add(Trees.xmlToSwing(child));
        }
        return root;
    }

    public static MutableTreeNode copy(javax.swing.tree.TreeNode node) {
        if (node == null) {
            return null;
        }
        String label = node.toString();
        Object userObject = Trees.getUserObject(node);
        boolean allowsChildren = node.getAllowsChildren();
        DefaultMutableTreeNode target = userObject == null || userObject == label ? new DefaultMutableTreeNode(label, allowsChildren) : new NamedTreeNode(label, userObject, allowsChildren);
        Enumeration<? extends javax.swing.tree.TreeNode> children = node.children();
        if (children != null) {
            while (children.hasMoreElements()) {
                MutableTreeNode child = Trees.copy(children.nextElement());
                if (child == null) continue;
                target.add(child);
            }
        }
        return target;
    }

    public static String toString(TreeModel tree) {
        TreeFormat tf = new TreeFormat();
        tf.setTableFormatEnabled(true);
        StringBuilder buffer = new StringBuilder();
        tf.format(tree, buffer);
        return buffer.toString();
    }

    public static String toString(javax.swing.tree.TreeNode node) {
        TreeFormat tf = new TreeFormat();
        tf.setTableFormatEnabled(true);
        StringBuilder buffer = new StringBuilder();
        tf.format(node, buffer);
        return buffer.toString();
    }
}

