/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.parameter;

import java.net.URI;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.geotoolkit.parameter.AbstractParameterValue;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Utilities;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;

@Deprecated
public class FloatParameter
extends AbstractParameterValue<Double> {
    private static final long serialVersionUID = 9027797654033417816L;
    private double value;
    private Unit<?> unit;

    public FloatParameter(ParameterDescriptor<Double> descriptor) {
        super(descriptor);
        Class type = descriptor.getValueClass();
        Class<Double> expected = Double.class;
        if (!expected.equals((Object)type) && !Double.TYPE.equals(type)) {
            throw new IllegalArgumentException(Errors.format((short)55, type, expected));
        }
        this.value = FloatParameter.defaultValue(descriptor);
        this.unit = descriptor.getUnit();
    }

    private static double defaultValue(ParameterDescriptor<Double> descriptor) {
        Number value = (Number)descriptor.getDefaultValue();
        return value != null ? value.doubleValue() : Double.NaN;
    }

    public FloatParameter(ParameterDescriptor<Double> descriptor, double value) {
        this(descriptor);
        this.setValue(value);
    }

    public Unit<?> getUnit() {
        return this.unit;
    }

    public double doubleValue(Unit<?> unit) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull((String)"unit", unit);
        Unit<?> thisUnit = this.getUnit();
        if (thisUnit == null) {
            throw FloatParameter.unitlessParameter(this.descriptor);
        }
        short expectedID = FloatParameter.getUnitMessageID(thisUnit);
        if (FloatParameter.getUnitMessageID(unit) != expectedID) {
            throw new IllegalArgumentException(Errors.format(expectedID, unit));
        }
        try {
            return thisUnit.getConverterToAny(unit).convert(this.doubleValue());
        }
        catch (IncommensurableException e) {
            throw new IllegalArgumentException(Errors.format((short)77, unit), e);
        }
    }

    public double doubleValue() {
        return this.value;
    }

    public int intValue() throws IllegalStateException {
        double value = this.doubleValue();
        int integer = (int)value;
        if ((double)integer == value) {
            return integer;
        }
        String name = FloatParameter.getName(this.descriptor);
        if (Double.isNaN(value)) {
            throw new IllegalStateException(Errors.format((short)115, name));
        }
        throw new InvalidParameterTypeException(FloatParameter.getClassTypeError(), name);
    }

    public boolean booleanValue() throws IllegalStateException {
        double value = this.doubleValue();
        if (Double.isNaN(value)) {
            throw new IllegalStateException(Errors.format((short)115, FloatParameter.getName(this.descriptor)));
        }
        return value != 0.0;
    }

    public String stringValue() throws IllegalStateException {
        double value = this.doubleValue();
        if (Double.isNaN(value)) {
            throw new IllegalStateException(Errors.format((short)115, FloatParameter.getName(this.descriptor)));
        }
        return String.valueOf(value);
    }

    public double[] doubleValueList(Unit<?> unit) throws IllegalArgumentException {
        double[] dArray;
        double value = this.doubleValue(unit);
        if (Double.isNaN(value)) {
            dArray = ArraysExt.EMPTY_DOUBLE;
        } else {
            double[] dArray2 = new double[1];
            dArray = dArray2;
            dArray2[0] = value;
        }
        return dArray;
    }

    public double[] doubleValueList() {
        double[] dArray;
        double value = this.doubleValue();
        if (Double.isNaN(value)) {
            dArray = ArraysExt.EMPTY_DOUBLE;
        } else {
            double[] dArray2 = new double[1];
            dArray = dArray2;
            dArray2[0] = value;
        }
        return dArray;
    }

    public int[] intValueList() throws InvalidParameterTypeException {
        return new int[]{this.intValue()};
    }

    public URI valueFile() throws InvalidParameterTypeException {
        throw new InvalidParameterTypeException(FloatParameter.getClassTypeError(), FloatParameter.getName(this.descriptor));
    }

    private static String getClassTypeError() {
        return Errors.format((short)69, Double.class);
    }

    public Double getValue() {
        double value = this.doubleValue();
        return Double.isNaN(value) ? null : Double.valueOf(value);
    }

    public void setValue(double value, Unit<?> unit) throws InvalidParameterValueException {
        double converted = value;
        ParameterDescriptor descriptor = (ParameterDescriptor)this.descriptor;
        Unit targetUnit = descriptor.getUnit();
        if (targetUnit != unit) {
            if (targetUnit == null) {
                throw FloatParameter.unitlessParameter((GeneralParameterDescriptor)descriptor);
            }
            ArgumentChecks.ensureNonNull((String)"unit", unit);
            short expectedID = FloatParameter.getUnitMessageID(targetUnit);
            if (FloatParameter.getUnitMessageID(unit) != expectedID) {
                throw new InvalidParameterValueException(Errors.format(expectedID, unit), descriptor.getName().getCode(), value);
            }
            try {
                converted = unit.getConverterToAny(targetUnit).convert(value);
            }
            catch (IncommensurableException e) {
                throw new IllegalArgumentException(Errors.format((short)77, unit), e);
            }
        }
        if (Double.isNaN(value)) {
            this.value = FloatParameter.defaultValue((ParameterDescriptor<Double>)descriptor);
        } else {
            FloatParameter.ensureValidValue(descriptor, converted);
            this.value = value;
        }
        this.unit = unit;
        this.fireValueChanged();
    }

    public void setValue(double value) throws InvalidParameterValueException {
        this.setValue(value, this.unit);
    }

    public void setValue(int value) throws InvalidParameterValueException {
        this.setValue((double)value);
    }

    public void setValue(boolean value) throws InvalidParameterValueException {
        this.setValue(value ? 1.0 : 0.0);
    }

    public void setValue(Object value) throws InvalidParameterValueException {
        double number;
        if (value == null) {
            number = Double.NaN;
        } else if (value instanceof Number) {
            number = ((Number)value).doubleValue();
        } else {
            throw new InvalidParameterValueException(FloatParameter.getClassTypeError(), FloatParameter.getName(this.descriptor), value);
        }
        this.setValue(number);
    }

    public void setValue(double[] values, Unit<?> unit) throws InvalidParameterValueException {
        ArgumentChecks.ensureNonNull((String)"values", (Object)values);
        if (values.length != 1) {
            throw new InvalidParameterValueException(FloatParameter.getClassTypeError(), FloatParameter.getName(this.descriptor), (Object)values);
        }
        this.setValue(values[0], unit);
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            FloatParameter that = (FloatParameter)object;
            return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(that.value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Utilities.hash(this.value, super.hashCode());
    }

    @Override
    public FloatParameter clone() {
        return (FloatParameter)super.clone();
    }
}

