/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.parameter;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.Containers;
import org.geotoolkit.parameter.AbstractParameter;
import org.geotoolkit.parameter.ParameterValueList;
import org.geotoolkit.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterCardinalityException;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;

@Deprecated
public class ParameterGroup
extends AbstractParameter
implements ParameterValueGroup {
    private static final long serialVersionUID = -1985309386356545126L;
    public static final ParameterValueGroup EMPTY = new ParameterGroup(Collections.singletonMap("name", "Void"), new GeneralParameterValue[0]);
    private final ArrayList<GeneralParameterValue> values;
    private transient List<GeneralParameterValue> asList;

    public ParameterGroup(ParameterDescriptorGroup descriptor) {
        super((GeneralParameterDescriptor)descriptor);
        List parameters = descriptor.descriptors();
        this.values = new ArrayList(parameters.size());
        for (GeneralParameterDescriptor element : parameters) {
            int count = element.getMinimumOccurs();
            while (--count >= 0) {
                GeneralParameterValue value = element.createValue();
                ArgumentChecks.ensureNonNull((String)"createValue", (Object)value);
                this.values.add(value);
            }
        }
    }

    public ParameterGroup(ParameterDescriptorGroup descriptor, GeneralParameterValue ... values) {
        super((GeneralParameterDescriptor)descriptor);
        ArgumentChecks.ensureNonNull((String)"values", (Object)values);
        this.values = new ArrayList<GeneralParameterValue>(Arrays.asList(values));
        List parameters = descriptor.descriptors();
        LinkedHashMap<GeneralParameterDescriptor, Integer> occurrences = new LinkedHashMap<GeneralParameterDescriptor, Integer>(Containers.hashMapCapacity((int)parameters.size()));
        for (GeneralParameterDescriptor param : parameters) {
            ArgumentChecks.ensureNonNull((String)"parameters", (Object)param);
            occurrences.put(param, 0);
        }
        ParameterGroup.ensureValidOccurs(values, occurrences);
    }

    public ParameterGroup(Map<String, ?> properties, GeneralParameterValue ... values) {
        super((GeneralParameterDescriptor)ParameterGroup.createDescriptor(properties, values));
        this.values = new ArrayList<GeneralParameterValue>(Arrays.asList(values));
    }

    private static ParameterDescriptorGroup createDescriptor(Map<String, ?> properties, GeneralParameterValue[] values) {
        ArgumentChecks.ensureNonNull((String)"values", (Object)values);
        LinkedHashMap<GeneralParameterDescriptor, Integer> occurrences = new LinkedHashMap<GeneralParameterDescriptor, Integer>(Containers.hashMapCapacity((int)values.length));
        for (int i = 0; i < values.length; ++i) {
            ArgumentChecks.ensureNonNullElement((String)"values", (int)i, (Object)values);
            occurrences.put(values[i].getDescriptor(), 0);
        }
        ParameterGroup.ensureValidOccurs(values, occurrences);
        Set descriptors = occurrences.keySet();
        return new DefaultParameterDescriptorGroup(properties, 1, 1, descriptors.toArray(new GeneralParameterDescriptor[descriptors.size()]));
    }

    private static void ensureValidOccurs(GeneralParameterValue[] values, Map<GeneralParameterDescriptor, Integer> occurrences) {
        for (int i = 0; i < values.length; ++i) {
            ArgumentChecks.ensureNonNullElement((String)"values", (int)i, (Object)values);
            GeneralParameterDescriptor descriptor = values[i].getDescriptor();
            Integer count = occurrences.put(descriptor, 1);
            if (count == null) {
                String name = ParameterGroup.getName(descriptor);
                throw new InvalidParameterTypeException(Errors.format((short)60, name), name);
            }
            if (count == 0) continue;
            occurrences.put(descriptor, count + 1);
        }
        for (Map.Entry<GeneralParameterDescriptor, Integer> entry : occurrences.entrySet()) {
            GeneralParameterDescriptor descriptor = entry.getKey();
            int count = entry.getValue();
            int min = descriptor.getMinimumOccurs();
            int max = descriptor.getMaximumOccurs();
            if (count >= min && count <= max) continue;
            String name = ParameterGroup.getName(descriptor);
            throw new InvalidParameterCardinalityException(Errors.format((short)68, name, count, min, max), name);
        }
    }

    public ParameterDescriptorGroup getDescriptor() {
        return (ParameterDescriptorGroup)super.getDescriptor();
    }

    public List<GeneralParameterValue> values() {
        if (this.asList == null) {
            this.asList = new ParameterValueList((ParameterDescriptorGroup)this.descriptor, this.values);
        }
        return this.asList;
    }

    final GeneralParameterValue parameter(int index) throws IndexOutOfBoundsException {
        return this.values.get(index);
    }

    public ParameterValue<?> parameter(String name) throws ParameterNotFoundException {
        ArgumentChecks.ensureNonNull((String)"name", (Object)name);
        name = name.trim();
        for (GeneralParameterValue value : this.values) {
            if (!(value instanceof ParameterValue) || !IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)value.getDescriptor(), (String)name)) continue;
            return (ParameterValue)value;
        }
        for (GeneralParameterDescriptor descriptor : this.getDescriptor().descriptors()) {
            if (!(descriptor instanceof ParameterDescriptor) || !IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)descriptor, (String)name)) continue;
            ParameterValue value = ((ParameterDescriptor)descriptor).createValue();
            this.values.add((GeneralParameterValue)value);
            return value;
        }
        throw new ParameterNotFoundException(Errors.format((short)188, name), name);
    }

    public List<ParameterValueGroup> groups(String name) throws ParameterNotFoundException {
        GeneralParameterDescriptor check;
        ArgumentChecks.ensureNonNull((String)"name", (Object)name);
        name = name.trim();
        ArrayList<ParameterValueGroup> groups = new ArrayList<ParameterValueGroup>(Math.min(this.values.size(), 10));
        for (GeneralParameterValue value : this.values) {
            if (!(value instanceof ParameterValueGroup) || !IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)value.getDescriptor(), (String)name)) continue;
            groups.add((ParameterValueGroup)value);
        }
        if (groups.isEmpty() && !((check = ((ParameterDescriptorGroup)this.descriptor).descriptor(name)) instanceof ParameterDescriptorGroup)) {
            throw new ParameterNotFoundException(Errors.format((short)188, name), name);
        }
        return groups;
    }

    public ParameterValueGroup addGroup(String name) throws ParameterNotFoundException, InvalidParameterCardinalityException {
        GeneralParameterDescriptor check = ((ParameterDescriptorGroup)this.descriptor).descriptor(name);
        if (!(check instanceof ParameterDescriptorGroup)) {
            throw new ParameterNotFoundException(Errors.format((short)188, name), name);
        }
        int count = 0;
        for (GeneralParameterValue value : this.values) {
            if (!IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)value.getDescriptor(), (String)name)) continue;
            ++count;
        }
        if (count >= check.getMaximumOccurs()) {
            throw new InvalidParameterCardinalityException(Errors.format((short)165, name, count), name);
        }
        ParameterValueGroup value = ((ParameterDescriptorGroup)check).createValue();
        this.values.add((GeneralParameterValue)value);
        return value;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            ParameterGroup that = (ParameterGroup)object;
            return Objects.equals(this.values, that.values);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.values.hashCode();
    }

    @Override
    public ParameterGroup clone() {
        ParameterGroup copy = (ParameterGroup)super.clone();
        try {
            Field field = ParameterGroup.class.getDeclaredField("values");
            field.setAccessible(true);
            field.set(copy, this.values.clone());
        }
        catch (ReflectiveOperationException cause) {
            throw new AssertionError((Object)cause);
        }
        int i = copy.values.size();
        while (--i >= 0) {
            copy.values.set(i, copy.values.get(i).clone());
        }
        copy.asList = null;
        return copy;
    }
}

