/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.util.iso.Names;
import org.geotoolkit.lang.Static;
import org.opengis.metadata.Identifier;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;
import org.opengis.util.NameFactory;
import org.opengis.util.ScopedName;

public final class NamesExt
extends Static {
    public static LocalName createRandomUUID() {
        String uuid = UUID.randomUUID().toString();
        return Names.createLocalName(null, null, (CharSequence)uuid);
    }

    public static GenericName create(QName qname) {
        return NamesExt.create(qname.getNamespaceURI(), qname.getLocalPart());
    }

    public static GenericName create(String local) {
        return NamesExt.create(null, local);
    }

    public static GenericName create(String namespace, String local) {
        if (namespace == null || namespace.isEmpty()) {
            return ((NameFactory)DefaultFactories.forBuildin(NameFactory.class)).createGenericName(null, new CharSequence[]{local});
        }
        return ((NameFactory)DefaultFactories.forBuildin(NameFactory.class)).createGenericName(null, new CharSequence[]{namespace, local});
    }

    public static GenericName valueOf(String candidate) {
        if (candidate.startsWith("{")) {
            return NamesExt.toSessionNamespaceFromExtended(candidate);
        }
        int index = candidate.lastIndexOf(58);
        if (index <= 0) {
            return NamesExt.create(null, candidate);
        }
        String uri = candidate.substring(0, index);
        String name = candidate.substring(index + 1, candidate.length());
        return NamesExt.create(uri, name);
    }

    private static GenericName toSessionNamespaceFromExtended(String candidate) {
        int index = candidate.indexOf(125);
        if (index == -1) {
            throw new IllegalArgumentException("Invalide extended form : " + candidate);
        }
        String uri = candidate.substring(1, index);
        String name = candidate.substring(index + 1, candidate.length());
        return NamesExt.create(uri, name);
    }

    public static String toExtendedForm(GenericName name) {
        String ns = NamesExt.getNamespace(name);
        if (ns == null || ns.isEmpty()) {
            return name.toString();
        }
        return ns + ':' + name.tip();
    }

    public static String toExpandedString(GenericName name) {
        String ns = NamesExt.getNamespace(name);
        if (ns == null) {
            return name.tip().toString();
        }
        return "{" + ns + '}' + name.tip();
    }

    public static boolean match(GenericName name, String candidate) {
        if (candidate.startsWith("{")) {
            return candidate.equals(NamesExt.toExpandedString(name));
        }
        int index = candidate.lastIndexOf(58);
        if (index <= 0) {
            return candidate.equals(name.tip().toString());
        }
        String uri = candidate.substring(0, index);
        String local = candidate.substring(index + 1, candidate.length());
        return uri.equals(NamesExt.getNamespace(name)) && local.equals(name.tip().toString());
    }

    public static boolean match(GenericName name, GenericName candidate) {
        String ns1 = NamesExt.getNamespace(name);
        String ns2 = NamesExt.getNamespace(candidate);
        if (ns1 == null || ns2 == null) {
            return name.tip().toString().equals(candidate.tip().toString());
        }
        return name.toString().equals(candidate.toString());
    }

    public static String getNamespace(GenericName name) {
        LocalName ln;
        if (name instanceof ScopedName) {
            return ((ScopedName)name).path().toString();
        }
        if (name instanceof Identifier) {
            return ((Identifier)name).getCodeSpace();
        }
        if (name instanceof LocalName && !(ln = (LocalName)name).scope().isGlobal()) {
            return ln.scope().name().toString();
        }
        return null;
    }
}

