/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Disposable;
import org.geotoolkit.internal.ReferenceQueueConsumer;

public class WeakPropertyChangeListener
extends WeakReference<PropertyChangeListener>
implements PropertyChangeListener,
Disposable {
    private Object source = null;

    public WeakPropertyChangeListener(Object source, PropertyChangeListener ref) {
        super(ref, ReferenceQueueConsumer.DEFAULT.queue);
        ArgumentChecks.ensureNonNull((String)"source", (Object)source);
        this.registerSource(source);
    }

    public synchronized void registerSource(Object source) {
        this.source = source;
        try {
            Method method = source.getClass().getMethod("addPropertyChangeListener", PropertyChangeListener.class);
            method.invoke(source, this);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("Object do not have property listener methods.", ex);
        }
        catch (SecurityException ex) {
            throw new RuntimeException("Object do not have property listener methods.", ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Object do not have property listener methods.", ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("Object do not have property listener methods.", ex);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        PropertyChangeListener listener = (PropertyChangeListener)this.get();
        if (listener != null) {
            listener.propertyChange(evt);
        }
    }

    public void dispose() {
        if (this.source != null) {
            try {
                Method method = this.source.getClass().getMethod("removePropertyChangeListener", PropertyChangeListener.class);
                method.invoke(this.source, this);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException("Object do not have property listener methods.", ex);
            }
            catch (SecurityException ex) {
                throw new RuntimeException("Object do not have property listener methods.", ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Object do not have property listener methods.", ex);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException("Object do not have property listener methods.", ex);
            }
        }
        this.source = null;
    }
}

