/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.RandomAccess;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.parameter.UninitializedParameter;
import org.apache.sis.parameter.Verifier;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterCardinalityException;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.IdentifiedObject;

final class ParameterValueList
extends AbstractList<GeneralParameterValue>
implements RandomAccess,
Serializable {
    private static final long serialVersionUID = -7446077551686135264L;
    final ParameterDescriptorGroup descriptor;
    private GeneralParameterValue[] values;
    private int size;

    ParameterValueList(ParameterDescriptorGroup descriptor) {
        this.descriptor = descriptor;
        List elements = descriptor.descriptors();
        this.values = new GeneralParameterValue[elements.size()];
        this.initialize(elements);
    }

    ParameterValueList(ParameterValueList other) {
        this.descriptor = other.descriptor;
        this.size = other.size;
        this.values = new GeneralParameterValue[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.values[i] = other.values[i].clone();
        }
    }

    private void initialize(List<GeneralParameterDescriptor> elements) {
        for (GeneralParameterDescriptor child : elements) {
            int count = child.getMinimumOccurs();
            while (--count >= 0) {
                this.addUnchecked(new UninitializedParameter(child));
            }
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, 0, this.size, null);
        this.size = 0;
        this.initialize(this.descriptor.descriptors());
    }

    @Override
    public int size() {
        return this.size;
    }

    final GeneralParameterDescriptor descriptor(int index) {
        return this.values[index].getDescriptor();
    }

    @Override
    public GeneralParameterValue get(int index) {
        ArgumentChecks.ensureValidIndex(this.size, index);
        GeneralParameterValue value = this.values[index];
        if (value instanceof UninitializedParameter) {
            this.values[index] = value = value.getDescriptor().createValue();
        }
        return value;
    }

    @Override
    public GeneralParameterValue set(int index, GeneralParameterValue parameter) {
        ArgumentChecks.ensureValidIndex(this.size, index);
        GeneralParameterValue value = this.values[index];
        ArgumentChecks.ensureNonNull("parameter", parameter);
        GeneralParameterDescriptor desc = parameter.getDescriptor();
        if (!value.getDescriptor().equals((Object)desc)) {
            this.ensureDescriptorExists(desc);
            this.ensureCanRemove(desc);
            this.ensureCanAdd(desc);
        }
        this.values[index] = parameter;
        return value;
    }

    @Override
    public boolean add(GeneralParameterValue parameter) {
        ArgumentChecks.ensureNonNull("parameter", parameter);
        GeneralParameterDescriptor desc = parameter.getDescriptor();
        this.ensureDescriptorExists(desc);
        Identifier name = desc.getName();
        int count = 0;
        for (int i = 0; i < this.size; ++i) {
            GeneralParameterValue value = this.values[i];
            if (!name.equals((Object)value.getDescriptor().getName())) continue;
            if (value instanceof UninitializedParameter) {
                this.values[i] = parameter;
                return true;
            }
            ++count;
        }
        int max = desc.getMaximumOccurs();
        if (count >= max) {
            throw new InvalidParameterCardinalityException(Errors.format((short)130, max, name), name.getCode());
        }
        this.addUnchecked(parameter);
        ++this.modCount;
        return true;
    }

    final void addUnchecked(GeneralParameterValue parameter) {
        if (this.size == this.values.length) {
            this.values = Arrays.copyOf(this.values, this.size * 2);
        }
        this.values[this.size++] = parameter;
    }

    final void ensureDescriptorExists(GeneralParameterDescriptor desc) {
        List descriptors = this.descriptor.descriptors();
        if (!descriptors.contains(desc)) {
            Identifier name = desc.getName();
            String code = name.getCode();
            for (GeneralParameterDescriptor descriptor : descriptors) {
                if (!IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)descriptor, code)) continue;
                throw new IllegalArgumentException(Resources.format((short)35, name));
            }
            throw new InvalidParameterNameException(Resources.format((short)61, Verifier.getDisplayName((GeneralParameterDescriptor)this.descriptor), name), code);
        }
    }

    private void ensureCanAdd(GeneralParameterDescriptor desc) {
        Identifier name = desc.getName();
        int count = 0;
        for (int i = 0; i < this.size; ++i) {
            if (!name.equals((Object)this.values[i].getDescriptor().getName())) continue;
            ++count;
        }
        int max = desc.getMaximumOccurs();
        if (count >= max) {
            throw new InvalidParameterCardinalityException(Errors.format((short)130, max, name), name.getCode());
        }
    }

    private void ensureCanRemove(GeneralParameterDescriptor desc) {
        int min = desc.getMinimumOccurs();
        if (min != 0) {
            Identifier name = desc.getName();
            int count = 0;
            for (int i = 0; i < this.size; ++i) {
                if (!name.equals((Object)this.values[i].getDescriptor().getName()) || ++count <= min) continue;
                return;
            }
            throw new InvalidParameterCardinalityException(Errors.format((short)128, min, name), name.getCode());
        }
    }

    @Override
    public GeneralParameterValue remove(int index) {
        ArgumentChecks.ensureValidIndex(this.size, index);
        GeneralParameterValue value = this.values[index];
        this.ensureCanRemove(value.getDescriptor());
        System.arraycopy(this.values, index + 1, this.values, index, --this.size - index);
        this.values[this.size] = null;
        ++this.modCount;
        return value;
    }

    public GeneralParameterValue[] toArray() {
        return Arrays.copyOf(this.values, this.size);
    }

    @Override
    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        String lineSeparator = System.lineSeparator();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.size; ++i) {
            buffer.append(this.values[i]).append(lineSeparator);
        }
        return buffer.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.values = ArraysExt.resize(this.values, this.size);
        out.defaultWriteObject();
    }
}

