/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.awt.geom.AffineTransform;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.measure.UnitConverter;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform;
import org.apache.sis.referencing.operation.transform.CopyTransform;
import org.apache.sis.referencing.operation.transform.DomainDefinition;
import org.apache.sis.referencing.operation.transform.IdentityTransform;
import org.apache.sis.referencing.operation.transform.LinearInterpolator1D;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.LinearTransform1D;
import org.apache.sis.referencing.operation.transform.PassThroughTransform;
import org.apache.sis.referencing.operation.transform.ProjectiveTransform;
import org.apache.sis.referencing.operation.transform.ProjectiveTransform2D;
import org.apache.sis.referencing.operation.transform.ScaleTransform;
import org.apache.sis.referencing.operation.transform.SpecializableTransform;
import org.apache.sis.referencing.operation.transform.SpecializableTransform2D;
import org.apache.sis.referencing.operation.transform.TransformAdapter2D;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.referencing.operation.transform.TranslationTransform;
import org.apache.sis.referencing.operation.transform.UnitConversion;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Static;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class MathTransforms
extends Static {
    private MathTransforms() {
    }

    public static LinearTransform identity(int dimension) {
        ArgumentChecks.ensurePositive("dimension", dimension);
        return IdentityTransform.create(dimension);
    }

    public static LinearTransform uniformTranslation(int dimension, double offset) {
        ArgumentChecks.ensurePositive("dimension", dimension);
        if (offset == 0.0) {
            return IdentityTransform.create(dimension);
        }
        switch (dimension) {
            case 0: {
                return IdentityTransform.create(0);
            }
            case 1: {
                return LinearTransform1D.create(1, offset);
            }
            case 2: {
                return new AffineTransform2D(1.0, 0.0, 0.0, 1.0, offset, offset);
            }
        }
        return new TranslationTransform(dimension, offset);
    }

    public static LinearTransform translation(double ... vector) {
        LinearTransform tr;
        ArgumentChecks.ensureNonNull("vector", vector);
        switch (vector.length) {
            case 0: {
                return IdentityTransform.create(0);
            }
            case 1: {
                return LinearTransform1D.create(1, vector[0]);
            }
            case 2: {
                tr = new AffineTransform2D(1.0, 0.0, 0.0, 1.0, vector[0], vector[1]);
                break;
            }
            default: {
                tr = new TranslationTransform(vector);
            }
        }
        return tr.isIdentity() ? IdentityTransform.create(vector.length) : tr;
    }

    public static LinearTransform scale(double ... factors) {
        LinearTransform tr;
        ArgumentChecks.ensureNonNull("factors", factors);
        switch (factors.length) {
            case 0: {
                return IdentityTransform.create(0);
            }
            case 1: {
                return LinearTransform1D.create(factors[0], null);
            }
            case 2: {
                tr = new AffineTransform2D(factors[0], 0.0, 0.0, factors[1], 0.0, 0.0);
                break;
            }
            default: {
                tr = new ScaleTransform(factors);
            }
        }
        return tr.isIdentity() ? IdentityTransform.create(factors.length) : tr;
    }

    public static LinearTransform linear(double scale, double offset) {
        return LinearTransform1D.create(scale, offset);
    }

    public static LinearTransform linear(Matrix matrix) {
        CopyTransform candidate;
        ArgumentChecks.ensureNonNull("matrix", matrix);
        int sourceDimension = matrix.getNumCol() - 1;
        int targetDimension = matrix.getNumRow() - 1;
        if (sourceDimension == targetDimension) {
            if (matrix.isIdentity()) {
                return MathTransforms.identity(sourceDimension);
            }
            if (Matrices.isAffine(matrix)) {
                switch (sourceDimension) {
                    case 1: {
                        MatrixSIS m = MatrixSIS.castOrCopy(matrix);
                        return LinearTransform1D.create(DoubleDouble.of(m.getNumber(0, 0), true), DoubleDouble.of(m.getNumber(0, 1), true));
                    }
                    case 2: {
                        return AffineTransform2D.create(matrix);
                    }
                }
            } else if (sourceDimension == 2) {
                return new ProjectiveTransform2D(matrix);
            }
        }
        if ((candidate = CopyTransform.create(matrix)) != null) {
            return candidate;
        }
        return new ProjectiveTransform(matrix).optimize();
    }

    @Deprecated(since="1.4", forRemoval=true)
    public static LinearTransform linear(MathTransform transform, DirectPosition position) throws TransformException {
        return MathTransforms.tangent(transform, position);
    }

    public static LinearTransform tangent(MathTransform toApproximate, DirectPosition tangentPoint) throws TransformException {
        if (toApproximate instanceof LinearTransform) {
            ArgumentChecks.ensureDimensionMatches("tangentPoint", toApproximate.getSourceDimensions(), tangentPoint);
            return (LinearTransform)toApproximate;
        }
        return MathTransforms.linear(MathTransforms.getMatrix(toApproximate, tangentPoint));
    }

    public static MathTransform1D convert(UnitConverter converter) {
        ArgumentChecks.ensureNonNull("converter", converter);
        return UnitConversion.create(converter);
    }

    public static MathTransform1D interpolate(double[] preimage, double[] values) {
        return LinearInterpolator1D.create(preimage, values);
    }

    public static MathTransform specialize(MathTransform global, Map<Envelope, MathTransform> specializations) {
        ArgumentChecks.ensureNonNull("generic", global);
        ArgumentChecks.ensureNonNull("specializations", specializations);
        if (specializations.isEmpty()) {
            return global;
        }
        SpecializableTransform tr = global.getSourceDimensions() == 2 && global.getTargetDimensions() == 2 ? new SpecializableTransform2D(global, specializations) : new SpecializableTransform(global, specializations);
        MathTransform substitute = tr.getSubstitute();
        return substitute != null ? substitute : tr;
    }

    public static MathTransform passThrough(int firstAffectedCoordinate, MathTransform subTransform, int numTrailingCoordinates) {
        int dimension;
        ArgumentChecks.ensureNonNull("subTransform", subTransform);
        ArgumentChecks.ensurePositive("firstAffectedCoordinate", firstAffectedCoordinate);
        ArgumentChecks.ensurePositive("numTrailingCoordinates", numTrailingCoordinates);
        if (firstAffectedCoordinate == 0 && numTrailingCoordinates == 0) {
            return subTransform;
        }
        if (subTransform.isIdentity() && (dimension = subTransform.getSourceDimensions()) == subTransform.getTargetDimensions()) {
            return IdentityTransform.create(firstAffectedCoordinate + dimension + numTrailingCoordinates);
        }
        return PassThroughTransform.create(firstAffectedCoordinate, subTransform, numTrailingCoordinates);
    }

    public static MathTransform passThrough(int[] modifiedCoordinates, MathTransform subTransform, int resultDim) {
        ArgumentChecks.ensureNonNull("modifiedCoordinates", modifiedCoordinates);
        BitSet bitset = new BitSet();
        int previous = -1;
        for (int i = 0; i < modifiedCoordinates.length; ++i) {
            int dim = modifiedCoordinates[i];
            String message = TransformSeparator.validate("modifiedCoordinates", i, previous, resultDim, dim);
            if (message != null) {
                throw new IllegalArgumentException(message);
            }
            bitset.set(dim);
            previous = dim;
        }
        try {
            return PassThroughTransform.create(bitset, subTransform, resultDim, null);
        }
        catch (FactoryException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static MathTransform compound(MathTransform ... components) {
        ArgumentChecks.ensureNonNull("components", components);
        int sum = 0;
        int[] dimensions = new int[components.length];
        for (int i = 0; i < components.length; ++i) {
            MathTransform tr = components[i];
            ArgumentChecks.ensureNonNullElement("components", i, tr);
            dimensions[i] = tr.getSourceDimensions();
            sum += dimensions[i];
        }
        MathTransform compound = null;
        int firstAffectedCoordinate = 0;
        for (int i = 0; i < components.length; ++i) {
            MathTransform tr = components[i];
            tr = MathTransforms.passThrough(firstAffectedCoordinate, tr, sum - (firstAffectedCoordinate += dimensions[i]));
            compound = compound == null ? tr : MathTransforms.concatenate(compound, tr);
        }
        assert (MathTransforms.isValid(MathTransforms.getSteps(compound))) : compound;
        return compound;
    }

    public static MathTransform concatenate(MathTransform tr1, MathTransform tr2) throws MismatchedDimensionException {
        MathTransform tr;
        ArgumentChecks.ensureNonNull("tr1", tr1);
        ArgumentChecks.ensureNonNull("tr2", tr2);
        try {
            tr = ConcatenatedTransform.create(tr1, tr2, null);
        }
        catch (FactoryException e) {
            throw new IllegalArgumentException(e);
        }
        assert (MathTransforms.isValid(MathTransforms.getSteps(tr))) : tr;
        return tr;
    }

    public static MathTransform1D concatenate(MathTransform1D tr1, MathTransform1D tr2) throws MismatchedDimensionException {
        return (MathTransform1D)MathTransforms.concatenate((MathTransform)tr1, (MathTransform)tr2);
    }

    public static MathTransform2D concatenate(MathTransform2D tr1, MathTransform2D tr2) throws MismatchedDimensionException {
        return MathTransforms.bidimensional(MathTransforms.concatenate((MathTransform)tr1, (MathTransform)tr2));
    }

    public static MathTransform concatenate(MathTransform tr1, MathTransform tr2, MathTransform tr3) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull("tr1", tr1);
        ArgumentChecks.ensureNonNull("tr2", tr2);
        ArgumentChecks.ensureNonNull("tr3", tr3);
        return MathTransforms.concatenate(MathTransforms.concatenate(tr1, tr2), tr3);
    }

    public static MathTransform1D concatenate(MathTransform1D tr1, MathTransform1D tr2, MathTransform1D tr3) throws MismatchedDimensionException {
        return (MathTransform1D)MathTransforms.concatenate((MathTransform)tr1, (MathTransform)tr2, (MathTransform)tr3);
    }

    public static MathTransform2D concatenate(MathTransform2D tr1, MathTransform2D tr2, MathTransform2D tr3) throws MismatchedDimensionException {
        return MathTransforms.bidimensional(MathTransforms.concatenate((MathTransform)tr1, (MathTransform)tr2, (MathTransform)tr3));
    }

    public static MathTransform2D bidimensional(MathTransform transform) {
        if (transform == null || transform instanceof MathTransform2D) {
            return (MathTransform2D)transform;
        }
        ArgumentChecks.ensureDimensionsMatch("transform", 2, 2, transform);
        return new TransformAdapter2D(transform);
    }

    static boolean isValid(List<MathTransform> steps) {
        boolean wasLinear = false;
        for (MathTransform step : steps) {
            if (step instanceof LinearTransform) {
                if (wasLinear) {
                    return false;
                }
                wasLinear = true;
                continue;
            }
            wasLinear = false;
        }
        return true;
    }

    public static List<MathTransform> getSteps(MathTransform transform) {
        if (transform != null) {
            if (transform instanceof ConcatenatedTransform) {
                return ((ConcatenatedTransform)transform).getSteps();
            }
            return List.of(transform);
        }
        return List.of();
    }

    public static Matrix getMatrix(MathTransform transform) {
        if (transform instanceof LinearTransform) {
            return ((LinearTransform)transform).getMatrix();
        }
        if (transform instanceof AffineTransform) {
            return AffineTransforms2D.toMatrix((AffineTransform)transform);
        }
        return null;
    }

    public static Matrix getMatrix(MathTransform toApproximate, DirectPosition tangentPoint) throws TransformException {
        ArgumentChecks.ensureNonNull("toApproximate", toApproximate);
        int srcDim = toApproximate.getSourceDimensions();
        ArgumentChecks.ensureDimensionMatches("tangentPoint", srcDim, tangentPoint);
        Matrix affine = MathTransforms.getMatrix(toApproximate);
        if (affine != null) {
            return affine;
        }
        ArgumentChecks.ensureNonNull("tangentPoint", tangentPoint);
        int tgtDim = toApproximate.getTargetDimensions();
        double[] coordinates = new double[Math.max(tgtDim, srcDim + 1)];
        for (int i = 0; i < srcDim; ++i) {
            coordinates[i] = tangentPoint.getOrdinate(i);
        }
        Matrix derivative = MathTransforms.derivativeAndTransform(toApproximate, coordinates, 0, coordinates, 0);
        MatrixSIS m = Matrices.createAffine(derivative, new DirectPositionView.Double(coordinates, 0, tgtDim));
        coordinates = ArraysExt.resize(coordinates, srcDim + 1);
        for (int i = 0; i < srcDim; ++i) {
            coordinates[i] = -tangentPoint.getOrdinate(i);
        }
        coordinates[srcDim] = 1.0;
        m.translate(coordinates);
        return m;
    }

    public static Optional<Envelope> getDomain(MathTransform evaluated) throws TransformException {
        if (evaluated instanceof AbstractMathTransform) {
            return ((AbstractMathTransform)evaluated).getDomain(new DomainDefinition());
        }
        return Optional.empty();
    }

    public static Matrix derivativeAndTransform(MathTransform transform, double[] srcPts, int srcOff, double[] dstPts, int dstOff) throws TransformException {
        if (transform instanceof AbstractMathTransform) {
            return ((AbstractMathTransform)transform).transform(srcPts, srcOff, dstPts, dstOff, true);
        }
        Matrix derivative = transform.derivative((DirectPosition)new DirectPositionView.Double(srcPts, srcOff, transform.getSourceDimensions()));
        if (dstPts != null) {
            transform.transform(srcPts, srcOff, dstPts, dstOff, 1);
        }
        return derivative;
    }
}

