/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.geotoolkit.gml.xml.AbstractTimePosition;
import org.geotoolkit.gml.xml.v311.TimeInstantType;
import org.geotoolkit.gml.xml.v311.TimePeriodType;
import org.geotoolkit.gml.xml.v311.TimePositionType;
import org.geotoolkit.gts.xml.PeriodDurationType;
import org.geotoolkit.temporal.factory.DefaultTemporalFactory;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Period;
import org.opengis.temporal.PeriodDuration;
import org.opengis.util.InternationalString;

public class GMLTemporalFactory
extends DefaultTemporalFactory {
    public Instant createInstant(Date pstn) {
        if (pstn != null) {
            return new TimeInstantType(this.createPosition(pstn));
        }
        return null;
    }

    public Period createPeriod(Instant begin, Instant end) {
        Date beginPosition = null;
        if (begin != null) {
            beginPosition = begin.getDate();
        }
        Date endPosition = null;
        if (end != null) {
            endPosition = end.getDate();
        }
        return new TimePeriodType(this.createInstant(beginPosition), this.createInstant(endPosition));
    }

    public AbstractTimePosition createPosition(Date date) {
        if (date != null) {
            return new TimePositionType(date);
        }
        return null;
    }

    public PeriodDuration createPeriodDuration(InternationalString years, InternationalString months, InternationalString week, InternationalString days, InternationalString hours, InternationalString minutes, InternationalString seconds) {
        BigInteger iyears = null;
        if (years != null) {
            iyears = new BigInteger(years.toString());
        }
        BigInteger imonths = null;
        if (months != null) {
            imonths = new BigInteger(months.toString());
        }
        BigInteger idays = null;
        if (days != null) {
            idays = new BigInteger(days.toString());
        }
        BigInteger ihours = null;
        if (hours != null) {
            ihours = new BigInteger(hours.toString());
        }
        BigInteger iminutes = null;
        if (minutes != null) {
            iminutes = new BigInteger(minutes.toString());
        }
        BigDecimal iseconds = null;
        if (seconds != null) {
            iseconds = new BigDecimal(seconds.toString());
        }
        return new PeriodDurationType(true, iyears, imonths, idays, ihours, iminutes, iseconds);
    }
}

