/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.referencing.IdentifiedObjects;
import org.geotoolkit.geometry.jts.JTS;
import org.geotoolkit.gml.xml.AbstractGeometricAggregate;
import org.geotoolkit.gml.xml.AbstractGeometry;
import org.geotoolkit.gml.xml.AbstractRing;
import org.geotoolkit.gml.xml.GMLXmlFactory;
import org.geotoolkit.gml.xml.LineString;
import org.geotoolkit.gml.xml.LinearRing;
import org.geotoolkit.gml.xml.MultiPoint;
import org.geotoolkit.gml.xml.Point;
import org.geotoolkit.gml.xml.Polygon;
import org.geotoolkit.gml.xml.v321.DirectPositionType;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

public final class JTStoGeometry {
    private JTStoGeometry() {
    }

    public static AbstractGeometry toGML(String gmlVersion, Geometry jts) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem crs = JTS.findCoordinateReferenceSystem((Geometry)jts);
        return JTStoGeometry.toGML(gmlVersion, jts, crs);
    }

    public static AbstractGeometry toGML(String gmlVersion, Geometry jts, CoordinateReferenceSystem crs) throws NoSuchAuthorityCodeException, FactoryException {
        if (crs == null) {
            crs = JTS.findCoordinateReferenceSystem((Geometry)jts);
        }
        if (jts instanceof org.locationtech.jts.geom.Point) {
            org.locationtech.jts.geom.Point pt = (org.locationtech.jts.geom.Point)jts;
            return JTStoGeometry.toGML(gmlVersion, pt, crs);
        }
        if (jts instanceof org.locationtech.jts.geom.Polygon) {
            org.locationtech.jts.geom.Polygon po = (org.locationtech.jts.geom.Polygon)jts;
            return JTStoGeometry.toGML(gmlVersion, po, crs);
        }
        if (jts instanceof org.locationtech.jts.geom.LinearRing) {
            org.locationtech.jts.geom.LinearRing lr = (org.locationtech.jts.geom.LinearRing)jts;
            return JTStoGeometry.toGML(gmlVersion, lr, crs);
        }
        if (jts instanceof org.locationtech.jts.geom.LineString) {
            org.locationtech.jts.geom.LineString ls = (org.locationtech.jts.geom.LineString)jts;
            return JTStoGeometry.toGML(gmlVersion, ls, crs);
        }
        if (jts instanceof org.locationtech.jts.geom.MultiPoint) {
            org.locationtech.jts.geom.MultiPoint mp = (org.locationtech.jts.geom.MultiPoint)jts;
            return JTStoGeometry.toGML(gmlVersion, mp, crs);
        }
        if (jts instanceof MultiLineString) {
            MultiLineString mls = (MultiLineString)jts;
            return JTStoGeometry.toGML(gmlVersion, mls, crs);
        }
        if (jts instanceof MultiPolygon) {
            MultiPolygon mpo = (MultiPolygon)jts;
            return JTStoGeometry.toGML(gmlVersion, mpo, crs);
        }
        if (jts instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)jts;
            return JTStoGeometry.toGML(gmlVersion, gc, crs);
        }
        throw new IllegalArgumentException("Unsupported geometry type : " + jts);
    }

    public static AbstractGeometricAggregate toGML(String gmlVersion, GeometryCollection jtsGeom, CoordinateReferenceSystem crs) throws NoSuchAuthorityCodeException, FactoryException {
        JTStoGeometry.isValidGeometry(crs);
        if (jtsGeom.isEmpty()) {
            throw new IllegalArgumentException("Cannot write empty geometry for unidentified geometry collection type");
        }
        Class<Object> buffer = jtsGeom.getGeometryN(0).getClass();
        if (!(buffer.isAssignableFrom(org.locationtech.jts.geom.Polygon.class) || buffer.isAssignableFrom(org.locationtech.jts.geom.Point.class) || buffer.isAssignableFrom(org.locationtech.jts.geom.LineString.class))) {
            throw new IllegalArgumentException("Writing GML geometry collection works only for Points, LineStrings and polygons");
        }
        boolean isSupported = true;
        ArrayList<Geometry> innerGeometries = new ArrayList<Geometry>(jtsGeom.getNumGeometries());
        for (int i = 0; i < jtsGeom.getNumGeometries(); ++i) {
            Geometry subGeom = jtsGeom.getGeometryN(i);
            if (!subGeom.getClass().isAssignableFrom(buffer)) {
                throw new IllegalArgumentException("Writing GML geometry collection containing different geometry types is not supported");
            }
            innerGeometries.add(subGeom);
        }
        GeometryFactory gf = JTS.getFactory();
        if (buffer.equals(org.locationtech.jts.geom.Point.class)) {
            org.locationtech.jts.geom.MultiPoint mutlPt = gf.createMultiPoint(innerGeometries.toArray(new org.locationtech.jts.geom.Point[innerGeometries.size()]));
            JTS.setCRS((Geometry)mutlPt, (CoordinateReferenceSystem)crs);
            return JTStoGeometry.toGML(gmlVersion, mutlPt, crs);
        }
        if (buffer.equals(org.locationtech.jts.geom.LineString.class)) {
            MultiLineString multLineString = gf.createMultiLineString(innerGeometries.toArray(new org.locationtech.jts.geom.LineString[innerGeometries.size()]));
            JTS.setCRS((Geometry)multLineString, (CoordinateReferenceSystem)crs);
            return JTStoGeometry.toGML(gmlVersion, multLineString, crs);
        }
        if (buffer.equals(org.locationtech.jts.geom.Polygon.class)) {
            MultiPolygon multPoly = gf.createMultiPolygon(innerGeometries.toArray(new org.locationtech.jts.geom.Polygon[innerGeometries.size()]));
            JTS.setCRS((Geometry)multPoly, (CoordinateReferenceSystem)crs);
            return JTStoGeometry.toGML(gmlVersion, multPoly, crs);
        }
        throw new IllegalArgumentException("Writing GML geometry collection works only for Points, LineStrings and polygons");
    }

    public static MultiPoint toGML(String gmlVersion, org.locationtech.jts.geom.MultiPoint jtsGeom, CoordinateReferenceSystem crs) throws NoSuchAuthorityCodeException, FactoryException {
        JTStoGeometry.isValidGeometry(crs);
        String srsName = JTStoGeometry.getSRS(crs);
        int srsDimension = crs.getCoordinateSystem().getDimension();
        ArrayList<Point> pointList = new ArrayList<Point>();
        for (int i = 0; i < jtsGeom.getNumGeometries(); ++i) {
            Point point = JTStoGeometry.toGML(gmlVersion, (org.locationtech.jts.geom.Point)jtsGeom.getGeometryN(i), crs);
            point.setSrsDimension(null);
            point.setSrsName(null);
            pointList.add(point);
        }
        String srs = JTStoGeometry.getSRS(crs);
        MultiPoint mp = GMLXmlFactory.buildMultiPoint(gmlVersion, pointList, srs);
        mp.setSrsName(srsName);
        mp.setSrsDimension(srsDimension);
        return mp;
    }

    public static AbstractGeometricAggregate toGML(String gmlVersion, MultiLineString jtsGeom, CoordinateReferenceSystem crs) throws NoSuchAuthorityCodeException, FactoryException {
        JTStoGeometry.isValidGeometry(crs);
        String srsName = JTStoGeometry.getSRS(crs);
        int srsDimension = crs.getCoordinateSystem().getDimension();
        ArrayList<LineString> lineList = new ArrayList<LineString>();
        for (int i = 0; i < jtsGeom.getNumGeometries(); ++i) {
            LineString line = JTStoGeometry.toGML(gmlVersion, (org.locationtech.jts.geom.LineString)jtsGeom.getGeometryN(i), crs);
            line.setSrsDimension(null);
            line.setSrsName(null);
            lineList.add(line);
        }
        String srs = JTStoGeometry.getSRS(crs);
        AbstractGeometricAggregate geom = GMLXmlFactory.buildMultiLineString(gmlVersion, lineList, srs);
        geom.setSrsDimension(srsDimension);
        geom.setSrsName(srsName);
        return geom;
    }

    public static AbstractGeometricAggregate toGML(String gmlVersion, MultiPolygon jtsGeom, CoordinateReferenceSystem crs) throws NoSuchAuthorityCodeException, FactoryException {
        JTStoGeometry.isValidGeometry(crs);
        String srsName = JTStoGeometry.getSRS(crs);
        int srsDimension = crs.getCoordinateSystem().getDimension();
        ArrayList<Polygon> polyList = new ArrayList<Polygon>();
        for (int i = 0; i < jtsGeom.getNumGeometries(); ++i) {
            Polygon poly = JTStoGeometry.toGML(gmlVersion, (org.locationtech.jts.geom.Polygon)jtsGeom.getGeometryN(i), crs);
            poly.setSrsDimension(null);
            poly.setSrsName(null);
            polyList.add(poly);
        }
        String srs = JTStoGeometry.getSRS(crs);
        AbstractGeometricAggregate geom = GMLXmlFactory.buildMultiPolygon(gmlVersion, polyList, srs);
        geom.setSrsDimension(srsDimension);
        geom.setSrsName(srsName);
        return geom;
    }

    public static Polygon toGML(String gmlVersion, org.locationtech.jts.geom.Polygon jtsGeom, CoordinateReferenceSystem crs) throws NoSuchAuthorityCodeException, FactoryException {
        JTStoGeometry.isValidGeometry(crs);
        String srsName = JTStoGeometry.getSRS(crs);
        int srsDimension = crs.getCoordinateSystem().getDimension();
        LinearRing gmlExterior = JTStoGeometry.toGML(gmlVersion, jtsGeom.getExteriorRing(), crs);
        gmlExterior.setSrsName(null);
        gmlExterior.setSrsDimension(null);
        ArrayList<AbstractRing> gmlInterior = new ArrayList<AbstractRing>();
        for (int i = 0; i < jtsGeom.getNumInteriorRing(); ++i) {
            LinearRing interior = JTStoGeometry.toGML(gmlVersion, jtsGeom.getInteriorRingN(i), crs);
            interior.setSrsName(null);
            interior.setSrsDimension(null);
            gmlInterior.add(interior);
        }
        return GMLXmlFactory.buildPolygon(gmlVersion, gmlExterior, gmlInterior, srsName, srsDimension);
    }

    public static LineString toGML(String gmlVersion, org.locationtech.jts.geom.LineString jtsGeom, CoordinateReferenceSystem crs) throws NoSuchAuthorityCodeException, FactoryException {
        JTStoGeometry.isValidGeometry(crs);
        Coordinate[] jtsCoord = jtsGeom.getCoordinates();
        ArrayList<Double> coordList = new ArrayList<Double>();
        for (Coordinate c : jtsCoord) {
            coordList.add(c.x);
            coordList.add(c.y);
        }
        String srsName = JTStoGeometry.getSRS(crs);
        LineString gmlString = GMLXmlFactory.buildLineString(gmlVersion, coordList, srsName, crs.getCoordinateSystem().getDimension());
        return gmlString;
    }

    public static LinearRing toGML(String gmlVersion, org.locationtech.jts.geom.LinearRing jtsGeom, CoordinateReferenceSystem crs) throws NoSuchAuthorityCodeException, FactoryException {
        JTStoGeometry.isValidGeometry(crs);
        Coordinate[] jtsCoord = jtsGeom.getCoordinates();
        ArrayList<Double> coordList = new ArrayList<Double>();
        for (Coordinate c : jtsCoord) {
            coordList.add(c.x);
            coordList.add(c.y);
        }
        return GMLXmlFactory.buildLinearRing(gmlVersion, coordList, JTStoGeometry.getSRS(crs), crs.getCoordinateSystem().getDimension());
    }

    public static Point toGML(String gmlVersion, org.locationtech.jts.geom.Point jtsPoint, CoordinateReferenceSystem crs) throws NoSuchAuthorityCodeException, FactoryException {
        JTStoGeometry.isValidGeometry(crs);
        Point gmlPoint = GMLXmlFactory.buildPoint(gmlVersion, null, JTStoGeometry.coordinateToDirectPosition(gmlVersion, jtsPoint.getCoordinate(), crs));
        gmlPoint.setSrsName(JTStoGeometry.getSRS(crs));
        gmlPoint.setSrsDimension(JTStoGeometry.getSRSDimension(crs));
        return gmlPoint;
    }

    private static DirectPosition coordinateToDirectPosition(String version, Coordinate coord, CoordinateReferenceSystem crs) throws FactoryException {
        if (Double.isNaN(coord.z)) {
            return new DirectPosition2D(crs, coord.x, coord.y);
        }
        String srs = JTStoGeometry.getSRS(crs);
        if ("3.2.1".equals(version)) {
            return new DirectPositionType(srs, (Integer)3, Arrays.asList(coord.x, coord.y, coord.z));
        }
        if ("3.1.1".equals(version)) {
            return new org.geotoolkit.gml.xml.v311.DirectPositionType(srs, (Integer)3, Arrays.asList(coord.x, coord.y, coord.z));
        }
        throw new IllegalArgumentException("unexpected gml version number:" + version);
    }

    private static CoordinateReferenceSystem getCRS(Geometry jtsGeom) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem crs = JTS.findCoordinateReferenceSystem((Geometry)jtsGeom);
        if (crs == null) {
            throw new IllegalArgumentException("JTS geometry must specify a Coordinate Reference System.");
        }
        return crs;
    }

    private static void isValidGeometry(CoordinateReferenceSystem crs) {
        if (crs == null || crs.getCoordinateSystem() == null) {
            throw new IllegalArgumentException("This service support only 2D JTS Geometry (CRS null, or coordinate system null).");
        }
        if (crs.getCoordinateSystem().getDimension() != 2) {
            throw new IllegalArgumentException("This service support only 2D JTS Geometry. (CRS dimension != 2) => " + crs.getCoordinateSystem().getDimension());
        }
    }

    private static String getSRS(CoordinateReferenceSystem crs) throws FactoryException {
        String srs = null;
        String method1 = IdentifiedObjects.lookupURN((IdentifiedObject)crs, null);
        if (method1 != null) {
            srs = method1;
        } else {
            String method2 = IdentifiedObjects.getIdentifierOrName((IdentifiedObject)crs);
            if (method2 != null) {
                srs = method2;
            } else {
                throw new IllegalArgumentException("Can't get Coordinate Reference System identifier.");
            }
        }
        return srs;
    }

    private static Integer getSRSDimension(CoordinateReferenceSystem crs) throws FactoryException {
        if (crs != null && crs.getCoordinateSystem() != null) {
            return crs.getCoordinateSystem().getDimension();
        }
        return null;
    }
}

