/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v321;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.util.ComparisonMode;
import org.geotoolkit.gml.xml.AbstractGeometry;
import org.geotoolkit.gml.xml.v321.AbstractGMLType;
import org.geotoolkit.gml.xml.v321.AbstractGeometricAggregateType;
import org.geotoolkit.gml.xml.v321.AbstractGeometricPrimitiveType;
import org.geotoolkit.gml.xml.v321.GeometricComplexType;
import org.geotoolkit.gml.xml.v321.GridType;
import org.opengis.filter.Expression;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.TransfiniteSet;
import org.opengis.geometry.complex.Complex;
import org.opengis.geometry.primitive.PrimitiveBoundary;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.opengis.util.ScopedName;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AbstractGeometryType")
@XmlSeeAlso(value={GeometricComplexType.class, GridType.class, AbstractGeometricPrimitiveType.class, AbstractGeometricAggregateType.class})
public abstract class AbstractGeometryType
extends AbstractGMLType
implements Geometry,
Expression,
AbstractGeometry {
    @XmlAttribute
    @XmlSchemaType(name="anyURI")
    private String srsName;
    @XmlAttribute
    @XmlSchemaType(name="positiveInteger")
    private Integer srsDimension;
    @XmlAttribute
    private List<String> axisLabels;
    @XmlAttribute
    private List<String> uomLabels;

    AbstractGeometryType() {
    }

    public AbstractGeometryType(Integer srsDimension, String srsName, List<String> axisLabels, List<String> uomLabels) {
        this.axisLabels = axisLabels;
        this.srsDimension = srsDimension;
        this.srsName = srsName;
        this.uomLabels = uomLabels;
    }

    public AbstractGeometryType(String srsName) {
        this.srsName = srsName;
    }

    public AbstractGeometryType(String id, String srsName) {
        super(id);
        this.srsName = srsName;
    }

    @Override
    public String getSrsName() {
        return this.srsName;
    }

    @Override
    public void setSrsName(String value) {
        this.srsName = value;
    }

    @Override
    public Integer getSrsDimension() {
        return this.srsDimension;
    }

    @Override
    public void setSrsDimension(Integer value) {
        this.srsDimension = value;
    }

    public List<String> getAxisLabels() {
        if (this.axisLabels == null) {
            this.axisLabels = new ArrayList<String>();
        }
        return this.axisLabels;
    }

    public List<String> getUomLabels() {
        if (this.uomLabels == null) {
            this.uomLabels = new ArrayList<String>();
        }
        return this.uomLabels;
    }

    public PrimitiveBoundary getBoundary() {
        return null;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.getCoordinateReferenceSystem(true);
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem(boolean longitudeFirst) {
        if (this.srsName != null) {
            try {
                CoordinateReferenceSystem crs = CRS.forCode((String)this.srsName);
                if (longitudeFirst) {
                    crs = AbstractCRS.castOrCopy((CoordinateReferenceSystem)crs).forConvention(AxesConvention.RIGHT_HANDED);
                }
                return crs;
            }
            catch (FactoryException ex) {
                Logger.getLogger("org.geotoolkit.gml.xml.v321").log(Level.WARNING, "Could not decode CRS which name is : " + this.srsName, ex);
            }
        }
        return null;
    }

    public Geometry getMbRegion() {
        return null;
    }

    public DirectPosition getRepresentativePoint() {
        return null;
    }

    public Complex getClosure() {
        return null;
    }

    public boolean isSimple() {
        return false;
    }

    public boolean isCycle() {
        return false;
    }

    public double distance(Geometry geometry) {
        return -1.0;
    }

    public int getDimension(DirectPosition point) {
        return -1;
    }

    @Override
    public int getCoordinateDimension() {
        Integer bi = this.getSrsDimension();
        if (bi == null) {
            return 2;
        }
        return bi;
    }

    public Set<? extends Complex> getMaximalComplex() {
        return new HashSet();
    }

    public Geometry transform(CoordinateReferenceSystem newCRS) throws TransformException {
        return null;
    }

    public Envelope getEnvelope() {
        return null;
    }

    public DirectPosition getCentroid() {
        return null;
    }

    public Geometry getConvexHull() {
        return null;
    }

    public Geometry getBuffer(double distance) {
        return null;
    }

    public boolean contains(TransfiniteSet pointSet) {
        return false;
    }

    public boolean contains(DirectPosition point) {
        return false;
    }

    public boolean intersects(TransfiniteSet pointSet) {
        return false;
    }

    public boolean equals(TransfiniteSet pointSet) {
        return this.equals(pointSet, ComparisonMode.STRICT);
    }

    public TransfiniteSet union(TransfiniteSet pointSet) {
        return null;
    }

    public TransfiniteSet intersection(TransfiniteSet pointSet) {
        return null;
    }

    public TransfiniteSet difference(TransfiniteSet pointSet) {
        return null;
    }

    public TransfiniteSet symmetricDifference(TransfiniteSet pointSet) {
        return null;
    }

    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object != null && this.getClass().equals(object.getClass())) {
            AbstractGeometryType that = (AbstractGeometryType)object;
            return Objects.equals(this.axisLabels, that.axisLabels) && Objects.equals(this.srsDimension, that.srsDimension) && Objects.equals(this.srsName, that.srsName) && Objects.equals(this.uomLabels, that.uomLabels);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.srsDimension != null ? this.srsDimension.hashCode() : 0);
        hash = 37 * hash + (this.srsName != null ? this.srsName.hashCode() : 0);
        hash = 37 * hash + (this.axisLabels != null ? this.axisLabels.hashCode() : 0);
        hash = 37 * hash + (this.uomLabels != null ? this.uomLabels.hashCode() : 0);
        return hash;
    }

    public AbstractGeometryType clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (this.axisLabels != null && !this.axisLabels.isEmpty()) {
            sb.append("axisLabels:\n");
            for (String s : this.axisLabels) {
                sb.append(s).append('\n');
            }
        }
        if (this.uomLabels != null && !this.uomLabels.isEmpty()) {
            sb.append("uomLabels:\n");
            for (String s : this.uomLabels) {
                sb.append(s).append('\n');
            }
        }
        if (this.srsName != null) {
            sb.append("srsName:").append(this.srsName).append('\n');
        }
        if (this.srsDimension != null) {
            sb.append("srsDimension:").append(this.srsDimension).append('\n');
        }
        return sb.toString();
    }

    public ScopedName getFunctionName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Class getResourceClass() {
        return null;
    }

    public List<Expression> getParameters() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object apply(Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Expression toValueType(Class type) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

