/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v321;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.geotoolkit.gml.xml.DirectPosition;
import org.geotoolkit.gml.xml.Envelope;
import org.geotoolkit.gml.xml.v321.CoordinatesType;
import org.geotoolkit.gml.xml.v321.DirectPositionType;
import org.geotoolkit.gml.xml.v321.EnvelopeWithTimePeriodType;
import org.geotoolkit.util.Utilities;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="EnvelopeType", propOrder={"lowerCorner", "upperCorner", "pos", "coordinates"})
@XmlSeeAlso(value={EnvelopeWithTimePeriodType.class})
@XmlRootElement(name="Envelope")
public class EnvelopeType
implements org.opengis.geometry.Envelope,
Envelope {
    private static final Logger LOGGER = Logger.getLogger("org.geotoolkit.gml.xml.v321");
    private DirectPositionType lowerCorner;
    private DirectPositionType upperCorner;
    private List<DirectPositionType> pos;
    private CoordinatesType coordinates;
    @XmlAttribute
    @XmlSchemaType(name="anyURI")
    private String srsName;
    @XmlAttribute
    @XmlSchemaType(name="positiveInteger")
    private Integer srsDimension;
    @XmlAttribute
    private List<String> axisLabels;
    @XmlAttribute
    private List<String> uomLabels;

    protected EnvelopeType() {
    }

    public EnvelopeType(DirectPositionType lowerCorner, DirectPositionType upperCorner, String srsName) {
        this.lowerCorner = lowerCorner;
        this.upperCorner = upperCorner;
        this.srsName = srsName;
    }

    public EnvelopeType(EnvelopeType that) {
        if (that != null) {
            if (that.axisLabels != null) {
                this.axisLabels = new ArrayList<String>(that.axisLabels);
            }
            if (that.uomLabels != null) {
                this.uomLabels = new ArrayList<String>(that.uomLabels);
            }
            if (that.coordinates != null) {
                this.coordinates = new CoordinatesType(that.coordinates);
            }
            if (that.lowerCorner != null) {
                this.lowerCorner = new DirectPositionType(that.lowerCorner);
            }
            if (that.upperCorner != null) {
                this.upperCorner = new DirectPositionType(that.upperCorner);
            }
            if (that.pos != null) {
                this.pos = new ArrayList<DirectPositionType>();
                for (DirectPositionType dp : that.pos) {
                    this.pos.add(new DirectPositionType(dp));
                }
            }
            this.srsDimension = that.srsDimension;
            this.srsName = that.srsName;
        }
    }

    public EnvelopeType(Envelope that) {
        if (that != null) {
            if (that.getLowerCorner() != null) {
                this.lowerCorner = new DirectPositionType(that.getLowerCorner(), false);
            }
            if (that.getUpperCorner() != null) {
                this.upperCorner = new DirectPositionType(that.getUpperCorner(), false);
            }
            this.srsDimension = that.getSrsDimension();
            this.srsName = that.getSrsName();
            this.axisLabels = that.getAxisLabels();
            this.uomLabels = that.getUomLabels();
            if (that.getCoordinates() != null) {
                this.coordinates = new CoordinatesType(that.getCoordinates());
            }
            if (that.getPos() != null) {
                this.pos = new ArrayList<DirectPositionType>();
                for (DirectPosition directPosition : that.getPos()) {
                    this.pos.add(new DirectPositionType(directPosition));
                }
            }
        }
    }

    public EnvelopeType(org.opengis.geometry.Envelope env) {
        this.pos = new ArrayList<DirectPositionType>();
        if (env != null) {
            this.lowerCorner = new DirectPositionType(env.getLowerCorner(), false);
            this.upperCorner = new DirectPositionType(env.getUpperCorner(), false);
            CoordinateReferenceSystem crs = env.getCoordinateReferenceSystem();
            if (crs != null) {
                try {
                    if (crs instanceof CompoundCRS) {
                        StringBuilder sb = new StringBuilder();
                        CompoundCRS compCrs = (CompoundCRS)crs;
                        sb.append("urn:ogc:def:crs,");
                        for (CoordinateReferenceSystem child : compCrs.getComponents()) {
                            String childSrs = IdentifiedObjects.lookupURN((IdentifiedObject)child, null);
                            if (childSrs != null) {
                                if (childSrs.startsWith("urn:ogc:def:")) {
                                    childSrs = childSrs.substring(12);
                                }
                                sb.append(childSrs).append(',');
                                continue;
                            }
                            sb.append("crs:EPSG::unknow,");
                        }
                        sb.deleteCharAt(sb.length() - 1);
                        this.srsName = sb.toString();
                    } else {
                        this.srsName = IdentifiedObjects.lookupURN((IdentifiedObject)crs, null);
                        if (this.srsName == null) {
                            this.srsName = "urn:ogc:def:crs:EPSG::unknow";
                        }
                    }
                    this.srsDimension = crs.getCoordinateSystem().getDimension();
                }
                catch (FactoryException ex) {
                    LOGGER.log(Level.SEVERE, "Factory exception while creating GML envelope from opengis one", ex);
                }
            }
        }
    }

    public DirectPositionType getLowerCorner() {
        return this.lowerCorner;
    }

    public void setLowerCorner(DirectPositionType value) {
        this.lowerCorner = value;
    }

    public DirectPositionType getUpperCorner() {
        return this.upperCorner;
    }

    public void setUpperCorner(DirectPositionType value) {
        this.upperCorner = value;
    }

    public List<DirectPositionType> getPos() {
        if (this.pos == null) {
            this.pos = new ArrayList<DirectPositionType>();
        }
        return this.pos;
    }

    @Override
    public CoordinatesType getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(CoordinatesType value) {
        this.coordinates = value;
    }

    @Override
    public String getSrsName() {
        return this.srsName;
    }

    @Override
    public void setSrsName(String value) {
        this.srsName = value;
    }

    @Override
    public Integer getSrsDimension() {
        return this.srsDimension;
    }

    @Override
    public void setSrsDimension(Integer value) {
        this.srsDimension = value;
    }

    @Override
    public List<String> getAxisLabels() {
        if (this.axisLabels == null) {
            this.axisLabels = new ArrayList<String>();
        }
        return this.axisLabels;
    }

    @Override
    public void setAxisLabels(List<String> axisLabels) {
        this.axisLabels = axisLabels;
    }

    public void setAxisLabels(String axisLabel) {
        if (axisLabel != null) {
            if (this.axisLabels == null) {
                this.axisLabels = new ArrayList<String>();
            }
            this.axisLabels.add(axisLabel);
        }
    }

    @Override
    public List<String> getUomLabels() {
        if (this.uomLabels == null) {
            this.uomLabels = new ArrayList<String>();
        }
        return this.uomLabels;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        if (this.srsName != null) {
            try {
                return CRS.forCode((String)this.srsName);
            }
            catch (NoSuchAuthorityCodeException ex) {
                LOGGER.log(Level.SEVERE, "NoSuchAuthorityCodeException while looking for GML envelope crs:" + this.srsName, ex);
            }
            catch (FactoryException ex) {
                LOGGER.log(Level.SEVERE, "FactoryException while looking for GML envelope crs:" + this.srsName, ex);
            }
        }
        return null;
    }

    public int getDimension() {
        CoordinateReferenceSystem crs;
        if (this.srsDimension == null && this.srsName != null && (crs = this.getCoordinateReferenceSystem()) != null) {
            this.srsDimension = crs.getCoordinateSystem().getDimension();
        }
        return this.srsDimension;
    }

    public double getMinimum(int i) throws IndexOutOfBoundsException {
        if (this.lowerCorner != null) {
            return this.lowerCorner.getOrdinate(i);
        }
        return -1.0;
    }

    public double getMaximum(int i) throws IndexOutOfBoundsException {
        if (this.upperCorner != null) {
            return this.upperCorner.getOrdinate(i);
        }
        return -1.0;
    }

    public double getMedian(int i) throws IndexOutOfBoundsException {
        if (this.upperCorner == null || this.lowerCorner == null) {
            return Double.NaN;
        }
        return 0.5 * (this.upperCorner.getOrdinate(i) + this.lowerCorner.getOrdinate(i));
    }

    public double getSpan(int i) throws IndexOutOfBoundsException {
        if (this.upperCorner == null || this.lowerCorner == null) {
            return Double.NaN;
        }
        return this.upperCorner.getOrdinate(i) - this.lowerCorner.getOrdinate(i);
    }

    @Override
    public boolean isCompleteEnvelope2D() {
        return this.getLowerCorner() != null && this.getUpperCorner() != null && this.getLowerCorner().getValue().size() == 2 && this.getUpperCorner().getValue().size() == 2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof EnvelopeType) {
            EnvelopeType that = (EnvelopeType)object;
            return Utilities.listNullEquals(this.axisLabels, that.axisLabels) && Objects.equals(this.coordinates, that.coordinates) && Objects.equals(this.lowerCorner, that.lowerCorner) && Utilities.listNullEquals(this.pos, that.pos) && Objects.equals(this.srsDimension, that.srsDimension) && Utilities.listNullEquals(this.uomLabels, that.uomLabels) && Objects.equals(this.srsName, that.srsName);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.lowerCorner != null ? this.lowerCorner.hashCode() : 0);
        hash = 79 * hash + (this.upperCorner != null ? this.upperCorner.hashCode() : 0);
        hash = 79 * hash + (this.pos != null ? this.pos.hashCode() : 0);
        hash = 79 * hash + (this.coordinates != null ? this.coordinates.hashCode() : 0);
        hash = 79 * hash + (this.srsName != null ? this.srsName.hashCode() : 0);
        hash = 79 * hash + (this.srsDimension != null ? this.srsDimension.hashCode() : 0);
        hash = 79 * hash + (this.axisLabels != null ? this.axisLabels.hashCode() : 0);
        hash = 79 * hash + (this.uomLabels != null ? this.uomLabels.hashCode() : 0);
        return hash;
    }

    public String toString() {
        int i;
        StringBuilder s = new StringBuilder();
        if (this.srsDimension != null) {
            s.append("srsDImension:").append(this.srsDimension).append(" ");
        }
        if (this.srsName != null) {
            s.append("srsName:").append(this.srsName).append(" ");
        }
        if (this.lowerCorner != null) {
            s.append('\n').append("lowerCorner:").append(this.lowerCorner.toString());
        }
        if (this.upperCorner != null) {
            s.append('\n').append("upperCorner:").append(this.upperCorner.toString());
        }
        if (this.pos != null) {
            i = 0;
            for (DirectPositionType posi : this.pos) {
                s.append('\n').append("pos").append(i).append(":").append(posi.toString());
                ++i;
            }
            s.append('\n');
        }
        if (this.coordinates != null) {
            s.append("coordinates:").append(this.coordinates.toString());
        }
        if (this.axisLabels != null) {
            i = 0;
            for (String axis : this.axisLabels) {
                s.append('\n').append("axis").append(i).append(":").append(axis);
                ++i;
            }
            s.append('\n');
        }
        if (this.uomLabels != null) {
            i = 0;
            for (String uom : this.uomLabels) {
                s.append('\n').append("uom").append(i).append(":").append(uom);
                ++i;
            }
            s.append('\n');
        }
        return s.toString();
    }
}

