/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.isoonjts.spatialschema.geometry.complex;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.geotoolkit.geometry.isoonjts.JTSUtils;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.AbstractJTSGeometry;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.JTSGeometry;
import org.geotoolkit.internal.jaxb.GeometryAdapter;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.complex.Complex;
import org.opengis.geometry.primitive.Primitive;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class JTSComplex<T extends Geometry>
extends AbstractJTSGeometry
implements Complex {
    @XmlElement(name="curveMember", namespace="http://www.opengis.net/gml")
    @XmlJavaTypeAdapter(value=GeometryAdapter.class)
    private List<T> elements = new ArrayList<T>(){

        @Override
        public boolean add(T o) {
            JTSComplex.this.invalidateCachedJTSPeer();
            return super.add(o);
        }

        @Override
        public boolean remove(Object o) {
            JTSComplex.this.invalidateCachedJTSPeer();
            return super.remove(o);
        }
    };
    protected Set setViewOfElements = JTSComplex.listAsSet(this.elements);
    private Set subComplexes = new HashSet();

    public JTSComplex() {
        this(null);
    }

    public JTSComplex(CoordinateReferenceSystem crs) {
        super(crs);
    }

    protected List<T> getElementList() {
        return this.elements;
    }

    public final boolean isMaximal() {
        return false;
    }

    public final Complex[] getSuperComplexes() {
        return null;
    }

    public final Complex[] getSubComplexes() {
        Complex[] result = new Complex[this.subComplexes.size()];
        this.subComplexes.toArray(result);
        return result;
    }

    public final Set getSubComplexSet() {
        return this.subComplexes;
    }

    public final Collection<Primitive> getElements() {
        return this.setViewOfElements;
    }

    @Override
    protected final org.locationtech.jts.geom.Geometry computeJTSPeer() {
        ArrayList<org.locationtech.jts.geom.Geometry> subParts = new ArrayList<org.locationtech.jts.geom.Geometry>();
        for (JTSGeometry prim : this.elements) {
            subParts.add(prim.getJTSGeometry());
        }
        return JTSUtils.GEOMETRY_FACTORY.buildGeometry(subParts);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("elements:").append('\n');
        for (Geometry g : this.elements) {
            sb.append(g).append('\n');
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof JTSComplex && super.equals(object)) {
            JTSComplex that = (JTSComplex)object;
            return Objects.equals(this.elements, that.elements);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 59 * hash + (this.elements != null ? this.elements.hashCode() : 0);
        return hash;
    }
}

