/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.jaxb;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Cache;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

public class CoordinateReferenceSystemAdapter
extends XmlAdapter<String, CoordinateReferenceSystem> {
    private static final CoordinateReferenceSystem DEFAULT_CRS = CommonCRS.WGS84.normalizedGeographic();
    private static final Cache<CoordinateReferenceSystem, String> cachedIdentifier = new Cache();

    public CoordinateReferenceSystem unmarshal(String v) throws Exception {
        if (v != null) {
            return CRS.forCode((String)v);
        }
        return null;
    }

    public String marshal(CoordinateReferenceSystem v) throws Exception {
        return CoordinateReferenceSystemAdapter.getSrsName(v);
    }

    public static String getSrsName(CoordinateReferenceSystem crs) {
        String srsName = null;
        if (crs != null) {
            try {
                srsName = (String)cachedIdentifier.get((Object)crs);
                if (srsName == null && !cachedIdentifier.containsKey((Object)crs)) {
                    CoordinateReferenceSystem candidate = Utilities.equalsIgnoreMetadata((Object)crs, (Object)DEFAULT_CRS) || CRS.findOperation((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)DEFAULT_CRS, null).getMathTransform().isIdentity() ? DEFAULT_CRS : crs;
                    srsName = IdentifiedObjects.lookupURN((IdentifiedObject)candidate, (Citation)Citations.EPSG);
                    if (srsName == null && (srsName = IdentifiedObjects.lookupURN((IdentifiedObject)candidate, null)) == null) {
                        srsName = IdentifiedObjects.getIdentifierOrName((IdentifiedObject)candidate);
                    }
                    cachedIdentifier.put((Object)crs, (Object)srsName);
                }
            }
            catch (FactoryException ex) {
                Logger.getLogger("org.geotoolkit.referencing").log(Level.WARNING, null, ex);
            }
        }
        return srsName;
    }
}

