/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.jts;

import java.awt.geom.Rectangle2D;
import java.util.Objects;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.util.Classes;
import org.geotoolkit.geometry.jts.JTS;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.resources.Errors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class JTSEnvelope2D
extends Envelope
implements org.opengis.geometry.Envelope {
    public static final JTSEnvelope2D EVERYTHING = new JTSEnvelope2D(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, null){
        private static final long serialVersionUID = -3188702602373537164L;

        @Override
        public boolean contains(Coordinate p) {
            return true;
        }

        @Override
        public boolean contains(DirectPosition pos) {
            return true;
        }

        @Override
        public boolean contains(double x, double y) {
            return true;
        }

        @Override
        public boolean contains(Envelope other) {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isNull() {
            return true;
        }
    };
    private static final long serialVersionUID = -3188702602373537163L;
    private CoordinateReferenceSystem crs;

    public JTSEnvelope2D() {
        this((CoordinateReferenceSystem)null);
    }

    public JTSEnvelope2D(CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        this.crs = crs;
        this.checkCoordinateReferenceSystemDimension();
    }

    public JTSEnvelope2D(double x1, double x2, double y1, double y2, CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        super(x1, x2, y1, y2);
        this.crs = crs;
        this.checkCoordinateReferenceSystemDimension();
    }

    public JTSEnvelope2D(Rectangle2D rectangle, CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        this(rectangle.getMinX(), rectangle.getMaxX(), rectangle.getMinY(), rectangle.getMaxY(), crs);
    }

    public JTSEnvelope2D(JTSEnvelope2D envelope) throws MismatchedDimensionException {
        super(envelope);
        this.crs = envelope.getCoordinateReferenceSystem();
        this.checkCoordinateReferenceSystemDimension();
    }

    public JTSEnvelope2D(org.opengis.geometry.Envelope envelope) throws MismatchedDimensionException {
        super(envelope.getMinimum(0), envelope.getMaximum(0), envelope.getMinimum(1), envelope.getMaximum(1));
        this.crs = envelope.getCoordinateReferenceSystem();
        this.checkCoordinateReferenceSystemDimension();
    }

    public JTSEnvelope2D(Envelope envelope, CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        super(envelope);
        this.crs = crs;
        this.checkCoordinateReferenceSystemDimension();
    }

    private void checkCoordinateReferenceSystemDimension() throws MismatchedDimensionException {
        if (this.crs != null) {
            int expected = this.getDimension();
            int dimension = this.crs.getCoordinateSystem().getDimension();
            if (dimension != expected) {
                throw new MismatchedDimensionException(Errors.format((short)95, this.crs.getName().getCode(), dimension, expected));
            }
        }
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public int getDimension() {
        return 2;
    }

    public double getMinimum(int dimension) {
        switch (dimension) {
            case 0: {
                return this.getMinX();
            }
            case 1: {
                return this.getMinY();
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    public double getMaximum(int dimension) {
        switch (dimension) {
            case 0: {
                return this.getMaxX();
            }
            case 1: {
                return this.getMaxY();
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    public double getMedian(int dimension) {
        switch (dimension) {
            case 0: {
                return 0.5 * (this.getMinX() + this.getMaxX());
            }
            case 1: {
                return 0.5 * (this.getMinY() + this.getMaxY());
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    public double getSpan(int dimension) {
        switch (dimension) {
            case 0: {
                return this.getWidth();
            }
            case 1: {
                return this.getHeight();
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    public DirectPosition getLowerCorner() {
        return new DirectPosition2D(this.crs, this.getMinX(), this.getMinY());
    }

    public DirectPosition getUpperCorner() {
        return new DirectPosition2D(this.crs, this.getMaxX(), this.getMaxY());
    }

    public boolean isEmpty() {
        return super.isNull();
    }

    public boolean contains(DirectPosition pos) {
        return super.contains(pos.getOrdinate(0), pos.getOrdinate(1));
    }

    public void include(double x, double y) {
        super.expandToInclude(x, y);
    }

    public JTSEnvelope2D transform(CoordinateReferenceSystem targetCRS) throws TransformException, FactoryException {
        return this.transform(targetCRS, 5);
    }

    public JTSEnvelope2D transform(CoordinateReferenceSystem targetCRS, int numPointsForTransformation) throws TransformException, FactoryException {
        if (this.crs == null) {
            if (this.isEmpty()) {
                return new JTSEnvelope2D(targetCRS);
            }
            throw new NullPointerException("Unable to transform referenced envelope, crs has not yet been provided.");
        }
        CoordinateOperationFactory coordinateOperationFactory = CRS.getCoordinateOperationFactory();
        CoordinateOperation operation = coordinateOperationFactory.createOperation(this.crs, targetCRS);
        GeneralEnvelope transformed = Envelopes.transform((CoordinateOperation)operation, (org.opengis.geometry.Envelope)this);
        transformed.setCoordinateReferenceSystem(targetCRS);
        JTSEnvelope2D target = new JTSEnvelope2D((org.opengis.geometry.Envelope)transformed);
        MathTransform transform = operation.getMathTransform();
        JTS.transform(this, target, transform, numPointsForTransformation);
        return target;
    }

    @Override
    public int hashCode() {
        int code = super.hashCode() ^ 0xAB296275;
        if (this.crs != null) {
            code ^= this.crs.hashCode();
        }
        return code;
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            CoordinateReferenceSystem otherCRS = object instanceof JTSEnvelope2D ? ((JTSEnvelope2D)object).crs : null;
            return Objects.equals(this.crs, otherCRS);
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(Classes.getShortClassName((Object)this)).append('[');
        int dimension = this.getDimension();
        for (int i = 0; i < dimension; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.getMinimum(i)).append(" : ").append(this.getMaximum(i));
        }
        return buffer.append(']').toString();
    }

    public static JTSEnvelope2D reference(Envelope e) {
        if (e == null) {
            return null;
        }
        if (e instanceof JTSEnvelope2D) {
            return (JTSEnvelope2D)e;
        }
        return new JTSEnvelope2D(e, null);
    }
}

