/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.jts;

import org.apache.sis.util.ArgumentChecks;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;

public class LineStringTranslator {
    private static final double TOLERANCE = 1.0E-9;
    private static final IllegalArgumentException NO_INTERSECTION_EXCEPTION = new IllegalArgumentException("no intersection between lines.");

    public static MultiLineString translateLineString(MultiLineString line, double offset) {
        ArgumentChecks.ensureNonNull((String)"MultiLineString", (Object)line);
        if (offset == 0.0) {
            return line;
        }
        GeometryFactory geomFact = line.getFactory();
        LineString[] ls = new LineString[line.getNumGeometries()];
        for (int i = 0; i < ls.length; ++i) {
            ls[i] = LineStringTranslator.translateLineString((LineString)line.getGeometryN(i), offset);
        }
        MultiLineString mls = geomFact.createMultiLineString(ls);
        mls.setSRID(line.getSRID());
        mls.setUserData(line.getUserData());
        return mls;
    }

    public static LineString translateLineString(LineString line, double offset) {
        ArgumentChecks.ensureNonNull((String)"linestring", (Object)line);
        if (offset == 0.0) {
            return line;
        }
        GeometryFactory geomFact = line.getFactory();
        Coordinate[] coords = line.getCoordinates();
        int coordsLength = coords.length;
        Coordinate[] dstCoords = new Coordinate[coordsLength];
        Coordinate dstPtn0 = new Coordinate();
        Coordinate dstPtn1 = new Coordinate();
        LineStringTranslator.translateVector(coords[0], coords[1], dstPtn0, dstPtn1, offset);
        dstCoords[0] = dstPtn0;
        if (coordsLength == 2) {
            dstCoords[1] = dstPtn1;
            return geomFact.createLineString(dstCoords);
        }
        int segmentNumber = coordsLength - 1;
        for (int c = 1; c < segmentNumber; ++c) {
            Coordinate i;
            Coordinate dstc0 = new Coordinate();
            Coordinate dstc1 = new Coordinate();
            LineStringTranslator.translateVector(coords[c], coords[c + 1], dstc0, dstc1, offset);
            dstCoords[c] = i = LineStringTranslator.intersectionRightLine(dstPtn0, dstPtn1, dstc0, dstc1);
            dstPtn0 = dstc0;
            dstPtn1 = dstc1;
            if (c != segmentNumber - 1) continue;
            if (coords[0].equals2D(coords[coordsLength - 1])) {
                Coordinate iend;
                dstCoords[0] = iend = LineStringTranslator.intersectionRightLine(dstPtn0, dstPtn1, dstCoords[0], dstCoords[1]);
                dstCoords[++c] = new Coordinate(iend);
                continue;
            }
            dstCoords[++c] = dstc1;
        }
        LineString ls = geomFact.createLineString(dstCoords);
        ls.setSRID(line.getSRID());
        ls.setUserData(line.getUserData());
        return ls;
    }

    private static void translateVector(Coordinate srcPt0, Coordinate srcPt1, Coordinate destPt0, Coordinate destPt1, double offset) {
        double vy;
        double vx = srcPt1.x - srcPt0.x;
        double ox = vy = srcPt1.y - srcPt0.y;
        double oy = -vx;
        double normO = StrictMath.hypot(ox, oy);
        ox /= normO;
        oy /= normO;
        destPt0.x = srcPt0.x + (ox *= offset);
        destPt0.y = srcPt0.y + (oy *= offset);
        destPt1.x = srcPt1.x + ox;
        destPt1.y = srcPt1.y + oy;
    }

    private static Coordinate intersectionRightLine(Coordinate A, Coordinate B, Coordinate C, Coordinate D) {
        double ux = B.x - A.x;
        double uy = B.y - A.y;
        double vx = D.x - C.x;
        double vy = D.y - C.y;
        if (StrictMath.abs(B.x - C.x) < 1.0E-9 && StrictMath.abs(B.y - C.y) < 1.0E-9) {
            return new Coordinate(B.x, B.y);
        }
        if (StrictMath.abs(A.x - D.x) < 1.0E-9 && StrictMath.abs(A.y - D.y) < 1.0E-9) {
            return new Coordinate(A.x, A.y);
        }
        if (StrictMath.abs(A.x - B.x) < 1.0E-9 && StrictMath.abs(A.y - B.y) < 1.0E-9) {
            double wx = A.x - C.x;
            double wy = A.y - C.y;
            if (StrictMath.abs(wx * vy - wy * vx) < 1.0E-9) {
                return new Coordinate(A.x, A.y);
            }
            throw NO_INTERSECTION_EXCEPTION;
        }
        if (StrictMath.abs(C.x - D.x) < 1.0E-9 && StrictMath.abs(C.y - D.y) < 1.0E-9) {
            double wy = C.y - A.y;
            double wx = C.x - A.x;
            if (StrictMath.abs(ux * wy - uy * wx) < 1.0E-9) {
                return new Coordinate(C.x, C.y);
            }
            throw NO_INTERSECTION_EXCEPTION;
        }
        if (StrictMath.abs(vy) < 1.0E-9 && StrictMath.abs(ux) < 1.0E-9) {
            return new Coordinate(A.x, C.y);
        }
        if (StrictMath.abs(vx) < 1.0E-9 && StrictMath.abs(uy) < 1.0E-9) {
            return new Coordinate(C.x, A.y);
        }
        if (StrictMath.abs(ux) < 1.0E-9 && StrictMath.abs(vx) < 1.0E-9) {
            if (StrictMath.abs(A.x - C.x) > 1.0E-9) {
                throw NO_INTERSECTION_EXCEPTION;
            }
            return new Coordinate(A.x, LineStringTranslator.getIntersectionOnOneDimension(A.y, B.y, C.y, D.y));
        }
        if (StrictMath.abs(uy) < 1.0E-9 && StrictMath.abs(vy) < 1.0E-9) {
            if (StrictMath.abs(A.y - C.y) > 1.0E-9) {
                throw NO_INTERSECTION_EXCEPTION;
            }
            return new Coordinate(LineStringTranslator.getIntersectionOnOneDimension(A.x, B.x, C.x, D.x), A.y);
        }
        if (StrictMath.abs(ux) <= 1.0E-9) {
            double yv = (A.x - C.x) * (vy / vx) + C.y;
            return new Coordinate(A.x, yv);
        }
        if (StrictMath.abs(uy) <= 1.0E-9) {
            double xv = (A.y - C.y) * (vx / vy) + C.x;
            return new Coordinate(xv, A.y);
        }
        if (StrictMath.abs(vx) <= 1.0E-9) {
            double yu = (C.x - A.x) * (uy / ux) + A.y;
            return new Coordinate(C.x, yu);
        }
        if (StrictMath.abs(vy) <= 1.0E-9) {
            double xu = (C.y - A.y) * (ux / uy) + A.x;
            return new Coordinate(xu, C.y);
        }
        double vx_vy = vx / vy;
        double t = ((A.y - C.y) * vx_vy + C.x - A.x) / (ux - uy * vx_vy);
        double x = t * ux + A.x;
        double y = t * uy + A.y;
        double y2 = (x - C.x) / vx_vy + C.y;
        assert (StrictMath.abs(y - y2) <= 1.0E-9) : "Error computing y from lines should be equal : y(AB) = " + y + " y(CD) = " + y2;
        return new Coordinate(x, y);
    }

    private static double getIntersectionOnOneDimension(double a, double b, double c, double d) {
        double iminx = StrictMath.max(a, c);
        double imaxx = StrictMath.min(b, d);
        if (imaxx + 1.0E-9 < iminx - 1.0E-9) {
            throw NO_INTERSECTION_EXCEPTION;
        }
        return (iminx + imaxx) / 2.0;
    }
}

