/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.jts.distance;

import java.util.function.ToDoubleBiFunction;
import javax.measure.UnitConverter;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.GeodeticCalculator;
import org.locationtech.jts.geom.Coordinate;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class OrthodromicEngine
implements ToDoubleBiFunction<Coordinate, Coordinate> {
    private final GeodeticCalculator engine;
    private final UnitConverter toMeters;

    OrthodromicEngine(CoordinateReferenceSystem crs) {
        this.engine = GeodeticCalculator.create((CoordinateReferenceSystem)crs);
        this.toMeters = this.engine.getDistanceUnit().getConverterTo(Units.METRE);
    }

    @Override
    public double applyAsDouble(Coordinate start, Coordinate end) {
        this.engine.setStartPoint((Position)new DirectPosition2D(start.x, start.y));
        this.engine.setEndPoint((Position)new DirectPosition2D(end.x, end.y));
        return this.toMeters.convert(this.engine.getGeodesicDistance());
    }
}

