/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.html;

import com.occamlab.te.util.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class EarlToHtmlTransformation {
    private static final Logger LOGR = Logger.getLogger(EarlToHtmlTransformation.class.getName());

    public void earlHtmlReport(String outputDir) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL resourceDirUrl = cl.getResource("com/occamlab/te/earl/lib");
        String earlXsl = cl.getResource("com/occamlab/te/earl_html_report.xsl").toString();
        File htmlOutput = new File(outputDir, "result");
        htmlOutput.mkdir();
        File earlResult = this.findEarlResultFile(outputDir);
        LOGR.log(Level.FINE, "Try to transform earl result file '" + earlResult + "' to directory " + htmlOutput);
        try {
            if (earlResult != null && earlResult.exists()) {
                Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(earlXsl));
                transformer.setParameter("outputDir", htmlOutput);
                File indexHtml = new File(htmlOutput, "index.html");
                indexHtml.createNewFile();
                FileOutputStream fo = new FileOutputStream(indexHtml);
                transformer.transform(new StreamSource(earlResult), new StreamResult(fo));
                fo.close();
                Utils.copyResourceDir(resourceDirUrl, htmlOutput);
            }
        }
        catch (Exception e) {
            LOGR.log(Level.SEVERE, "Transformation of EARL to HTML failed.", e);
        }
    }

    private File findEarlResultFile(String outputDir) {
        File testngDir = new File(outputDir, "testng");
        if (!testngDir.exists()) {
            return new File(outputDir, "earl-results.rdf");
        }
        String[] dir = testngDir.list();
        File testngUuidDirectory = new File(testngDir, dir[0]);
        if (testngUuidDirectory.isDirectory()) {
            return new File(testngUuidDirectory, "earl-results.rdf");
        }
        return null;
    }
}

