/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.vocabulary;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Config {
    private File baseDir;
    private File scriptsDir;
    private File resourcesDir;
    private File usersDir;
    private List<String> organizationList;
    private Map<String, List<String>> standardMap;
    private Map<String, List<String>> versionMap;
    private Map<String, List<String>> revisionMap;
    private Map<String, List<String>> conformanceClassMap;
    private Map<String, File> resources;

    public Config() {
        String basePath = System.getProperty("TE_BASE");
        if (null == basePath) {
            basePath = System.getenv("TE_BASE");
        }
        if (null == basePath) {
            basePath = System.getProperty("user.home") + System.getProperty("file.separator") + "teamengine";
        }
        this.baseDir = new File(basePath);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setExpandEntityReferences(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new File(this.baseDir, "config.xml"));
            Element configElem = (Element)doc.getElementsByTagName("config").item(0);
            this.resourcesDir = this.getScriptsDir();
            this.organizationList = new ArrayList<String>();
            this.standardMap = new HashMap<String, List<String>>();
            this.versionMap = new HashMap<String, List<String>>();
            this.revisionMap = new HashMap<String, List<String>>();
            this.conformanceClassMap = new HashMap<String, List<String>>();
            String suiteLocalName = null;
            for (Element organizationEl : this.getElementsByTagName(configElem, "organization")) {
                String organization = this.getElementByTagName(organizationEl, "name").getTextContent();
                for (Element standardEl : this.getElementsByTagName(organizationEl, "standard")) {
                    String standard = this.getElementByTagName(standardEl, "name").getTextContent();
                    ArrayList<String> versionList = new ArrayList<String>();
                    for (Element versionEl : this.getElementsByTagName(standardEl, "version")) {
                        String version = this.getElementByTagName(versionEl, "name").getTextContent();
                        versionList.add(version);
                        String verKey = organization + "_" + standard;
                        Element suiteEl = this.getElementByTagName(versionEl, "suite");
                        suiteLocalName = this.getElementByTagName(suiteEl, "local-name").getTextContent();
                        String key = null;
                        ArrayList<String> revisionList = new ArrayList<String>();
                        for (Element el : this.getChildElements(versionEl)) {
                            if (!el.getNodeName().equals("revision")) continue;
                            String revision = this.getElementByTagName(el, "name").getTextContent();
                            revisionList.add(revision);
                            String revKey = verKey + "_" + version;
                            key = revKey + "_" + revision;
                        }
                        ArrayList<String> ccList = new ArrayList<String>();
                        Element conformanceClasses = this.getElementByTagName(suiteEl, "BasicConformanceClasses");
                        if (null == conformanceClasses) continue;
                        for (Element ccElement : this.getChildElements(conformanceClasses)) {
                            if (!ccElement.getNodeName().equals("conformanceClass")) continue;
                            String confClass = ccElement.getTextContent();
                            ccList.add(confClass);
                        }
                        this.conformanceClassMap.put(suiteLocalName, ccList);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public File getScriptsDir() {
        if (null == this.scriptsDir) {
            File dir = new File(this.baseDir, "scripts");
            if (!dir.exists() && !dir.mkdir()) {
                throw new RuntimeException("Failed to create directory at " + dir.getAbsolutePath());
            }
            this.scriptsDir = dir;
        }
        return this.scriptsDir;
    }

    public File getUsersDir() {
        if (null == this.usersDir) {
            File dir = new File(this.baseDir, "users");
            if (!dir.exists() && !dir.mkdir()) {
                throw new RuntimeException("Failed to create directory at " + dir.getAbsolutePath());
            }
            this.usersDir = dir;
        }
        return this.usersDir;
    }

    public List<String> getOrganizationList() {
        return this.organizationList;
    }

    public Map<String, List<String>> getRevisionMap() {
        return this.revisionMap;
    }

    public Map<String, List<String>> getStandardMap() {
        return this.standardMap;
    }

    public Map<String, List<String>> getVersionMap() {
        return this.versionMap;
    }

    public Map<String, File> getResources() {
        return this.resources;
    }

    public Map<String, List<String>> getConformanceClassMap() {
        return this.conformanceClassMap;
    }

    public List<Element> getElementsByTagName(Node node, String tagname) {
        NodeList nl;
        ArrayList<Element> list = new ArrayList<Element>();
        if (node.getNodeType() == 9) {
            nl = ((Document)node).getElementsByTagName(tagname);
        } else if (node.getNodeType() == 1) {
            nl = ((Element)node).getElementsByTagName(tagname);
        } else {
            return null;
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            list.add((Element)nl.item(i));
        }
        return list;
    }

    public Element getElementByTagName(Node node, String tagname) {
        NodeList nl;
        if (node.getNodeType() == 9) {
            nl = ((Document)node).getElementsByTagName(tagname);
        } else if (node.getNodeType() == 1) {
            nl = ((Element)node).getElementsByTagName(tagname);
        } else {
            return null;
        }
        if (nl.getLength() >= 0) {
            return (Element)nl.item(0);
        }
        return null;
    }

    public List<Element> getChildElements(Node node) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            list.add((Element)nl.item(i));
        }
        return list;
    }
}

