/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.assembler;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.BadObjectException;
import org.apache.jena.assembler.ImportManager;
import org.apache.jena.assembler.JA;
import org.apache.jena.assembler.ModelExpansion;
import org.apache.jena.assembler.assemblers.AssemblerGroup;
import org.apache.jena.assembler.exceptions.AmbiguousSpecificTypeException;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.BadDescriptionMultipleRootsException;
import org.apache.jena.shared.BadDescriptionNoRootException;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class AssemblerHelp {
    protected static final Property ANY = null;

    public static Resource withFullModel(Resource root) {
        return root.inModel(AssemblerHelp.fullModel(root.getModel()));
    }

    public static Model fullModel(Model m3) {
        return AssemblerHelp.fullModel(ImportManager.instance, m3);
    }

    public static Model fullModel(ImportManager im, Model m3) {
        return m3.contains(JA.This, RDF.type, JA.Expanded) ? m3 : (Model)ModelExpansion.withSchema(im.withImports(m3), JA.getSchema()).add(JA.This, RDF.type, JA.Expanded).setNsPrefixes(PrefixMapping.Extended).setNsPrefixes(m3);
    }

    public static void loadArbitraryClasses(AssemblerGroup g2, Model m3) {
        StmtIterator it = m3.listStatements(null, JA.loadClass, ANY);
        while (it.hasNext()) {
            AssemblerHelp.loadArbitraryClass(g2, it.nextStatement());
        }
    }

    public static void loadAssemblerClasses(AssemblerGroup group, Model m3) {
        StmtIterator it = m3.listStatements((Resource)ANY, JA.assembler, ANY);
        while (it.hasNext()) {
            AssemblerHelp.loadAssemblerClass(group, it.nextStatement());
        }
    }

    private static void loadAssemblerClass(AssemblerGroup group, Statement s2) {
        Class<?> c = AssemblerHelp.loadArbitraryClass(group, s2);
        AssemblerHelp.runAnyAssemblerConstructor(group, s2, c);
    }

    private static Class<?> loadArbitraryClass(AssemblerGroup ag, Statement s2) {
        Class<?> loaded = AssemblerHelp.loadClassNamedBy(s2);
        try {
            Method m3 = loaded.getDeclaredMethod("whenRequiredByAssembler", AssemblerGroup.class);
            m3.invoke(null, ag);
        }
        catch (NoSuchMethodException m3) {
        }
        catch (Exception e) {
            throw new JenaException(e);
        }
        return loaded;
    }

    private static Class<?> loadClassNamedBy(Statement s2) {
        String x = AssemblerHelp.getString(s2);
        if (x.startsWith("com.hp.hpl.jena")) {
            String x1 = x.replaceFirst("com.hp.hpl.jena", "org.apache.jena");
            Log.warnOnce(AssemblerHelp.class, "ja:loadClass: Migration to Jena3: Converting " + x + " to " + x1, x);
            x = x1;
        }
        try {
            return Class.forName(x);
        }
        catch (Exception e) {
            throw new JenaException(e);
        }
    }

    private static void runAnyAssemblerConstructor(AssemblerGroup group, Statement s2, Class<?> c) {
        try {
            Resource type = s2.getSubject();
            Constructor<?> con = AssemblerHelp.getResourcedConstructor(c);
            if (con == null) {
                AssemblerHelp.establish(group, type, c.newInstance());
            } else {
                AssemblerHelp.establish(group, type, con.newInstance(s2.getSubject()));
            }
        }
        catch (Exception e) {
            throw new JenaException(e);
        }
    }

    private static void establish(AssemblerGroup group, Resource type, Object x) {
        if (!(x instanceof Assembler)) {
            throw new JenaException("constructed entity is not an Assembler: " + x);
        }
        group.implementWith(type, (Assembler)x);
    }

    private static Constructor<?> getResourcedConstructor(Class<?> c) {
        try {
            return c.getConstructor(Resource.class);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Resource findSpecificType(Resource root) {
        return AssemblerHelp.findSpecificType(root, JA.Object);
    }

    public static Resource findSpecificType(Resource root, Resource baseType) {
        Set<Resource> types = AssemblerHelp.findSpecificTypes(root, baseType);
        if (types.size() == 1) {
            return types.iterator().next();
        }
        if (types.size() == 0) {
            return baseType;
        }
        throw new AmbiguousSpecificTypeException(root, new ArrayList<Resource>(types));
    }

    public static Set<Resource> findSpecificTypes(Resource root, Resource baseType) {
        List<RDFNode> types = root.listProperties(RDF.type).mapWith(Statement::getObject).toList();
        HashSet<Resource> results = new HashSet<Resource>();
        for (int i = 0; i < types.size(); ++i) {
            Resource candidate = (Resource)types.get(i);
            if (!candidate.hasProperty(RDFS.subClassOf, baseType) || !AssemblerHelp.hasNoCompetingSubclass(types, candidate)) continue;
            results.add(candidate);
        }
        return results;
    }

    private static boolean hasNoCompetingSubclass(List<RDFNode> types, Resource candidate) {
        for (RDFNode type : types) {
            Resource other = (Resource)type;
            if (!other.hasProperty(RDFS.subClassOf, candidate) || candidate.equals(other)) continue;
            return false;
        }
        return true;
    }

    public static Resource getResource(Statement s2) {
        RDFNode ob = s2.getObject();
        if (ob.isLiteral()) {
            throw new BadObjectException(s2);
        }
        return (Resource)ob;
    }

    public static String getString(Statement s2) {
        RDFNode ob = s2.getObject();
        if (ob.isResource()) {
            throw new BadObjectException(s2);
        }
        Literal L = (Literal)ob;
        if (!L.getLanguage().equals("")) {
            throw new BadObjectException(s2);
        }
        if (L.getDatatype() == null) {
            return L.getLexicalForm();
        }
        if (L.getDatatype() == XSDDatatype.XSDstring) {
            return L.getLexicalForm();
        }
        throw new BadObjectException(s2);
    }

    public static String getString(Statement s2, Literal L) {
        if (!L.getLanguage().equals("")) {
            throw new BadObjectException(s2);
        }
        if (L.getDatatype() == null) {
            return L.getLexicalForm();
        }
        if (L.getDatatype() == XSDDatatype.XSDstring) {
            return L.getLexicalForm();
        }
        throw new BadObjectException(s2);
    }

    public static Set<Resource> findAssemblerRoots(Model model) {
        return AssemblerHelp.findAssemblerRoots(model, JA.Object);
    }

    public static Set<Resource> findAssemblerRoots(Model model, Resource type) {
        return AssemblerHelp.fullModel(model).listResourcesWithProperty(RDF.type, type).toSet();
    }

    public static Resource singleModelRoot(Model singleRoot) {
        return AssemblerHelp.singleRoot(singleRoot, JA.Model);
    }

    public static Resource singleRoot(Model singleRoot, Resource type) {
        Set<Resource> roots = AssemblerHelp.findAssemblerRoots(singleRoot, type);
        if (roots.size() == 1) {
            return roots.iterator().next();
        }
        if (roots.size() == 0) {
            throw new BadDescriptionNoRootException(singleRoot, type);
        }
        throw new BadDescriptionMultipleRootsException(singleRoot, type);
    }
}

